/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DROutputParamsWithoutFlow
extends DesignRule {
    private final String RULE_ID = "0EF91FDF-186C-07D0-BA97-9632C02883F2";

    public DROutputParamsWithoutFlow() {
        this.setName(Messages.getString("DROutputParamsWithoutFlow.IdentifyOutputParametersWithoutIncomingFlowsConnectedToThem"));
        this.setDescription(Messages.getString("DROutputParamsWithoutFlow.OutputParametersShouldHaveIncomingFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TransformationTask task = (TransformationTask)object;
        InOutParams outputParams = task.getOutputParamsObject();
        if (outputParams.getParams().size() > 0 && outputParams.getIncomingFlows().size() == 0) {
            return CheckResult.createFailed(object, this, Messages.getString("DROutputParamsWithoutFlow.OutputParametersDoesntHaveIncomingFlowsConnectedToThem"));
        }
        if (outputParams.getParams().size() == 0 && outputParams.getIncomingFlows().size() > 0) {
            return CheckResult.createFailed(object, this, Messages.getString("DROutputParamsWithoutFlow.ThereIsIncomingFlowConnectedToNoneOutputParameters"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DROutputParamsWithoutFlow.OutputParametersHaveIncomingFlowsConnectedToThem"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "0EF91FDF-186C-07D0-BA97-9632C02883F2";
    }
}

