/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.logical.DREntity;

public class DREntityNoPrimaryKey
extends DREntity {
    private final String RULE_ID = "81CC8D14-EBB2-E0A6-50C4-C5252CAE6962";

    public DREntityNoPrimaryKey() {
        this.setName(Messages.getString("DREntityNoPrimaryKey.IdentifyEntitiesWithoutPrimaryKey"));
        this.setDescription(Messages.getString("DREntityNoPrimaryKey.EntitiesWithoutPKNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Entity entity = (Entity)object;
        this.setEntityToCheck(entity);
        Entity entityToCheck = this.getEntityToCheck();
        Iterator itKey = entity.getKeySet().iterator();
        while (itKey.hasNext()) {
            KeyObject key = (KeyObject)itKey.next();
            if (!key.isPK()) continue;
            this.clearEntityToCheck();
            return CheckResult.createOk(entityToCheck, this, Messages.getString("DREntityNoPrimaryKey.EntityHasPrimaryKey"));
        }
        Entity superEntity = entity.getHierarchicalParent();
        if (superEntity != null) {
            return this.doCheck(superEntity);
        }
        this.clearEntityToCheck();
        return CheckResult.createWarning(entityToCheck, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "81CC8D14-EBB2-E0A6-50C4-C5252CAE6962";
    }
}

