/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.undo.RemoveDO_Edit;

public class NoteRemoveEdit
extends RemoveDO_Edit {
    Note note;
    String id;
    String text;
    List views = new ArrayList();
    List fonts = new ArrayList();

    public NoteRemoveEdit(Note note) {
        super(note);
        this.note = note;
        this.id = note.getObjectID();
        this.text = note.getText();
        this.saveShapedTopViews(note, this.views);
        NoteRemoveEdit.saveFonts(note.getTopView(), this.fonts);
    }

    @Override
    public String getRedoPresentationName() {
        return Messages.getString("NoteRemoveEdit.RedoRemoveNote");
    }

    @Override
    public String getUndoPresentationName() {
        return Messages.getString("NoteRemoveEdit.UndoRemoveNote");
    }

    @Override
    protected void removeObject() {
        this.note.remove();
    }

    @Override
    protected void restoreObject() {
        this.note.setText(this.text);
        this.note.setObjectID(this.id);
        this.note.getDesign().addDesignObject(this.note);
        this.note.getDesignPart().getNoteSet().add(this.note);
        this.restoreShapedTopViews(this.note, this.views);
        this.restoreFonts(this.note.getTopView(), this.fonts);
    }
}

