/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StagingTableUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableCheckConstraintProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableCheckConstraintProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableCheckConstraintProxySetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableCheckConstraintProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TablePropertyDialogUDBv81;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyUDBv81
extends TableProxyUDB
implements TableCheckConstraintListener,
PropertiesPropagator {
    protected String restrictOnDrop = "NO";
    protected String valueCompression = "NO";
    protected boolean organizeByDimensions = false;
    protected String dimensions = "";
    protected boolean useRemoteOptions = false;
    protected String roRemoteServer = "";
    protected String roRemoteSchema = "";
    protected String roRemoteTabName = "";
    private String validation = "ENFORCED";
    private String queryOptimization = "ENABLE";
    public static final String ENFORCED = "ENFORCED";
    public static final String NOT_ENFORCED = "NOT ENFORCED";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static String[] validationChoices = new String[]{"ENFORCED", "NOT ENFORCED"};
    private static Set validationSet = null;
    public static String[] queryOptimizationChoices = new String[]{"ENABLE", "DISABLE"};
    private static Set queryOptimizationSet = null;
    private List propertyWrapperList = null;

    public TableProxyUDBv81(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.stagingTables = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        this.stagingTables.setParent(this);
        this.stagingTables.setName(Messages.getString("TableProxyUDBv81.StagingTables"));
        this.stagingTables.setClassForParent(TableProxyUDB.class);
        this.stagingTables.setSetMethod("setTable");
        this.stagingTables.setAllowedNumberOfElements(1);
        this.stagingTables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getStagingTableSet().addSetListener(this);
        this.addStagingTablesFromDesign(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        if (this.summaryQuery.equalsIgnoreCase("YES") && this.summaryRefreshOptions.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
            this.enableStagingTables();
        } else {
            this.disableStagingTables();
        }
        this.tableCheckConstraints = new StorageObjectCollection();
        this.tableCheckConstraints.setParent(this);
        this.tableCheckConstraints.setName(Messages.getString("TableProxyOracle.TableCheckConstraints"));
        this.tableCheckConstraints.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().addSetListener(this);
        this.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet());
    }

    public TableProxyUDBv81(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.stagingTables = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        this.stagingTables.setParent(this);
        this.stagingTables.setName(Messages.getString("TableProxyUDBv81.StagingTables"));
        this.stagingTables.setClassForParent(TableProxyUDB.class);
        this.stagingTables.setSetMethod("setTable");
        this.stagingTables.setAllowedNumberOfElements(1);
        this.stagingTables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getTriggerSet().addSetListener(this);
        this.addStagingTablesFromDesign(((StorageDesignUDBv81)storageDesign).getStagingTableSet());
        if (this.summaryQuery.equalsIgnoreCase("YES") && this.summaryRefreshOptions.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
            this.enableStagingTables();
        } else {
            this.disableStagingTables();
        }
        this.tableCheckConstraints = new StorageObjectCollection();
        this.tableCheckConstraints.setParent(this);
        this.tableCheckConstraints.setName(Messages.getString("TableProxyOracle.TableCheckConstraints"));
        this.tableCheckConstraints.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet().addSetListener(this);
        this.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)storageDesign).getTableCheckConstraintSet());
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
        this.fireDataFieldChange();
    }

    public boolean getOrganizeByDimensions() {
        return this.organizeByDimensions;
    }

    public void setOrganizeByDimensions(boolean organizeByDimensions) {
        this.organizeByDimensions = organizeByDimensions;
    }

    public String getRestrictOnDrop() {
        return this.restrictOnDrop;
    }

    public void setRestrictOnDrop(String resrictOnDrop) {
        if (this.checkYesNo(resrictOnDrop)) {
            this.restrictOnDrop = resrictOnDrop;
            this.fireDataFieldChange();
        }
    }

    public String getValueCompression() {
        return this.valueCompression;
    }

    public void setValueCompression(String valueCompression) {
        if (this.checkYesNo(valueCompression)) {
            this.valueCompression = valueCompression;
            this.fireDataFieldChange();
        }
    }

    public boolean getUseRemoteOptions() {
        return this.useRemoteOptions;
    }

    public void setUseRemoteOptions(boolean useRemoteOptions) {
        this.useRemoteOptions = useRemoteOptions;
    }

    public String getRoRemoteSchema() {
        return this.roRemoteSchema;
    }

    public void setRoRemoteSchema(String roRemoteSchema) {
        this.roRemoteSchema = roRemoteSchema;
        this.fireDataFieldChange();
    }

    public String getRoRemoteServer() {
        return this.roRemoteServer;
    }

    public void setRoRemoteServer(String roRemoteServer) {
        this.roRemoteServer = roRemoteServer;
        this.fireDataFieldChange();
    }

    public String getRoRemoteTabName() {
        return this.roRemoteTabName;
    }

    public void setRoRemoteTabName(String roRemoteTabName) {
        this.roRemoteTabName = roRemoteTabName;
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogUDBv81 dialog = new TablePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    private void addStagingTablesFromDesign(StorageObjectSet set) {
        for (StagingTableUDBv81 staging : set) {
            staging.addObjectListener(this);
            if (staging.getTable() != null && staging.getTable() == this) {
                staging.setParent(this.stagingTables);
                this.stagingTables.add(staging);
                continue;
            }
            this.stagingTables.remove(staging);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 2;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.getNumberOfChildren() - 3) {
            return this.stagingTables;
        }
        if (index == this.getNumberOfChildren() - 4) {
            return this.tableCheckConstraints;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.stagingTables) {
            return this.getNumberOfChildren() - 3;
        }
        if (child == this.tableCheckConstraints) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.stagingTables) {
            return this.getNumberOfChildren() - 3;
        }
        if (child == this.tableCheckConstraints) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ColumnProxy) {
                ColumnProxy cp = (ColumnProxy)event.getAffected();
                if (this.getObject() == ((Column)cp.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(event.getAffected());
                }
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                if (this.getObject() == ((Index)ip.getObject()).getContainerWithKeyObject()) {
                    if (((Index)ip.getObject()).isFK()) {
                        if (!this.fkeys.contains(ip)) {
                            ip.setParent(this.fkeys);
                            this.fkeys.add(event.getAffected());
                        }
                    } else if (!this.indexes.contains(ip)) {
                        ip.setParent(this.indexes);
                        this.indexes.add(event.getAffected());
                    }
                }
            } else if (event.getAffected() instanceof TriggerUDB) {
                TriggerUDB tr = (TriggerUDB)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getTable() != null && tr.getTable() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            } else if (event.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB staging = (StagingTableUDB)event.getAffected();
                staging.addObjectListener(this);
                if (staging.getTable() != null && staging.getTable() == this) {
                    staging.setParent(this.stagingTables);
                    this.stagingTables.add(staging);
                } else {
                    this.stagingTables.remove(staging);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)event.getAffected()).getObject().getObjectID());
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                if (this.indexes.contains(ip)) {
                    this.indexes.remove(event.getAffected());
                }
                if (this.fkeys.contains(ip)) {
                    this.fkeys.remove(event.getAffected());
                }
            } else if (event.getAffected() instanceof TriggerUDB) {
                TriggerUDB tr = (TriggerUDB)event.getAffected();
                this.triggers.remove(tr);
                tr.removeObjectListener(this);
            } else if (event.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB staging = (StagingTableUDB)event.getAffected();
                this.stagingTables.remove(staging);
                staging.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TriggerUDB) {
            TriggerUDB tr = (TriggerUDB)event.getAffected();
            if (tr.getTable() != null && tr.getTable() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            } else {
                this.triggers.remove(tr);
            }
        } else if (event.getAffected() instanceof StagingTableUDB) {
            StagingTableUDB staging = (StagingTableUDB)event.getAffected();
            if (staging.getTable() != null && staging.getTable() == this) {
                staging.setParent(this.stagingTables);
                this.stagingTables.add(staging);
            } else {
                this.stagingTables.remove(staging);
            }
        } else if (event.getAffected() instanceof TableCheckConstraintProxyUDB) {
            TableCheckConstraintProxyUDB tcc = (TableCheckConstraintProxyUDB)event.getAffected();
            if (tcc.getTable() != null && tcc.getTable() == this) {
                this.removeExisting(tcc);
                tcc.setParent(this.tableCheckConstraints);
                this.tableCheckConstraints.add(tcc);
            } else {
                this.tableCheckConstraints.remove(tcc);
            }
        }
    }

    private void removeExisting(TableCheckConstraintProxyUDB check) {
        for (int i = this.tableCheckConstraints.size() - 1; i >= 0; --i) {
            TableCheckConstraintProxyUDB tcc = (TableCheckConstraintProxyUDB)this.tableCheckConstraints.getElement(i);
            if (tcc == check || !tcc.getName().equalsIgnoreCase(check.getName())) continue;
            this.tableCheckConstraints.remove(tcc);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TriggerUDB) {
                TriggerUDB tr = (TriggerUDB)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getTable() != null && tr.getTable() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            } else if (event.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB staging = (StagingTableUDB)event.getAffected();
                staging.addObjectListener(this);
                if (staging.getTable() != null && staging.getTable() == this) {
                    staging.setParent(this.stagingTables);
                    this.stagingTables.add(staging);
                } else {
                    this.stagingTables.remove(staging);
                }
            } else if (event.getAffected() instanceof TableCheckConstraintProxyUDB) {
                TableCheckConstraintProxyUDB tcc = (TableCheckConstraintProxyUDB)event.getAffected();
                tcc.addObjectListener(this);
                if (tcc.getTable() != null && tcc.getTable() == this) {
                    tcc.setParent(this.tableCheckConstraints);
                    this.tableCheckConstraints.add(tcc);
                } else {
                    this.tableCheckConstraints.remove(tcc);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof TriggerUDB) {
                TriggerUDB tr = (TriggerUDB)event.getAffected();
                this.triggers.remove(tr);
                tr.removeObjectListener(this);
            } else if (event.getAffected() instanceof StagingTableUDB) {
                StagingTableUDB staging = (StagingTableUDB)event.getAffected();
                this.stagingTables.remove(staging);
                staging.removeObjectListener(this);
            } else if (event.getAffected() instanceof TableCheckConstraintProxyUDB) {
                TableCheckConstraintProxyUDB tcc = (TableCheckConstraintProxyUDB)event.getAffected();
                this.tableCheckConstraints.remove(tcc);
                tcc.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(TableLevelConstraint object, TableLevelConstraintEvent event) {
        if (event.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED)) {
            StorageDesignUDBv81 sd = (StorageDesignUDBv81)this.getStorageDesign();
            TableCheckConstraintProxySetUDBv81 set = (TableCheckConstraintProxySetUDBv81)sd.getTableCheckConstraintSet();
            set.addTableCheckConstraint(this, object);
        } else if (event.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED)) {
            StorageDesignUDBv81 sd = (StorageDesignUDBv81)this.getStorageDesign();
            TableCheckConstraintProxySetUDBv81 tcc = (TableCheckConstraintProxySetUDBv81)sd.getTableCheckConstraintSet();
            tcc.removeTableCheckConstraint(this, object);
        }
    }

    public StorageObjectCollection getStagingTables() {
        return this.stagingTables;
    }

    private void enableStagingTables() {
        this.stagingTables.setForbiddenCreateElement(false);
    }

    private void disableStagingTables() {
        this.stagingTables.setForbiddenCreateElement(true);
        this.stagingTables.removeAll();
    }

    @Override
    public void setSummaryQuery(String summaryQuery) {
        if (this.checkYesNo(summaryQuery)) {
            super.setSummaryQuery(summaryQuery);
            if (summaryQuery.equalsIgnoreCase("YES") && this.summaryRefreshOptions.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
                this.enableStagingTables();
            } else {
                this.disableStagingTables();
            }
        }
    }

    @Override
    public void setSummaryRefreshOptions(String summaryRefreshOptions) {
        if (this.checkSummaryRefreshOptions(summaryRefreshOptions)) {
            this.summaryRefreshOptions = summaryRefreshOptions;
            if (this.summaryQuery.equalsIgnoreCase("YES") && summaryRefreshOptions.equalsIgnoreCase(SUMMARY_REFRESH_OPTIONS_STATES[0])) {
                this.enableStagingTables();
            } else {
                this.disableStagingTables();
            }
            this.fireDataFieldChange();
        }
    }

    protected boolean checkValidation(String value) {
        if (validationSet == null) {
            validationSet = new HashSet();
            validationSet.addAll(Arrays.asList(validationChoices));
        }
        return validationSet.contains(value);
    }

    protected boolean checkQueryOptimization(String value) {
        if (queryOptimizationSet == null) {
            queryOptimizationSet = new HashSet();
            queryOptimizationSet.addAll(Arrays.asList(queryOptimizationChoices));
        }
        return queryOptimizationSet.contains(value);
    }

    public String getQueryOptimization() {
        return this.queryOptimization;
    }

    public void setQueryOptimization(String queryOptimization) {
        if (this.checkQueryOptimization(queryOptimization)) {
            this.queryOptimization = queryOptimization;
            this.fireDataFieldChange();
        }
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        if (this.checkValidation(validation)) {
            this.validation = validation;
            this.fireDataFieldChange();
        }
    }

    private void addTableCheckConstraintFromDesign(TableCheckConstraintProxySetUDB set) {
        for (TableCheckConstraintProxyUDB tcc : set) {
            if (tcc.getTable() == null || tcc.getTable() != this || this.tableCheckConstraints.contains(tcc)) continue;
            tcc.setParent(this.tableCheckConstraints);
            this.tableCheckConstraints.add(tcc);
        }
        Table table = (Table)this.getObject();
        for (TableLevelConstraint constraint : table.getCheckConstraints()) {
            ((TableCheckConstraintProxySetUDBv81)set).addTableCheckConstraint(this, constraint);
            this.fireDataFieldChange();
        }
        this.fireDataFieldChange();
    }

    public StorageObjectCollection getTableCheckConstraints() {
        return this.tableCheckConstraints;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Part. Key Hashing", this, "getPartKeyHashing", "setPartKeyHashing", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Index TableSpace", this, "getIndexInTableSpace", "setIndexInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Long TableSpace", this, "getLongInTableSpace", "setLongInTableSpace", TableSpaceUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Initial Logging", this, "getInitialLogging", "setInitialLogging", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Federated", this, "getFederated", "setFederated", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Summary Query", this, "getSummaryQuery", "setSummaryQuery", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Restrict On Drop", this, "getRestrictOnDrop", "setRestrictOnDrop", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Value Compression", this, "getValueCompression", "setValueCompression", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyUDBv81 tableProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignUDBv81)targetDesign).getTableProxySet().getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxyUDBv81)storageObject;
        }
        if (tableProxy != null) {
            TableSpaceUDBv81 newTablespace;
            TableSpaceUDBv81 tablespace;
            tableProxy.setName(this.getName());
            for (TableCheckConstraintProxyUDBv81 constraint : this.getTableCheckConstraints()) {
                TableCheckConstraintProxyUDBv81 targetConstraint = (TableCheckConstraintProxyUDBv81)((StorageDesignUDBv81)targetDesign).getTableCheckConstraintSet().getByName(constraint.getName());
                if (targetConstraint == null) {
                    TableCheckConstraintProxyUDBv81 newConstraint = (TableCheckConstraintProxyUDBv81)((StorageDesignUDBv81)targetDesign).getTableCheckConstraintSet().createTableCheckConstraintProxy();
                    newConstraint.setName(constraint.getName());
                    newConstraint.setRawObject(true);
                    newConstraint.setTable(tableProxy);
                    tableProxy.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)targetDesign).getTableCheckConstraintSet());
                    continue;
                }
                targetConstraint.setTable(tableProxy);
                tableProxy.addTableCheckConstraintFromDesign(((StorageDesignUDBv81)targetDesign).getTableCheckConstraintSet());
            }
            for (StagingTableUDBv81 stTable : this.getStagingTables()) {
                StagingTableUDBv81 targetStTable = (StagingTableUDBv81)((StorageDesignUDBv81)targetDesign).getStagingTableSet().getByName(stTable.getName());
                if (targetStTable == null) {
                    StagingTableUDBv81 newStTable = (StagingTableUDBv81)((StorageDesignUDBv81)targetDesign).getStagingTableSet().createStagingTable();
                    newStTable.setName(stTable.getName());
                    newStTable.setRawObject(true);
                    newStTable.setTable(tableProxy);
                    tableProxy.addStagingTablesFromDesign(((StorageDesignUDBv81)targetDesign).getStagingTableSet());
                    continue;
                }
                targetStTable.setTable(tableProxy);
                tableProxy.addStagingTablesFromDesign(((StorageDesignUDBv81)targetDesign).getStagingTableSet());
            }
            for (TriggerUDBv81 trigger : this.triggers) {
                TriggerUDBv81 targetTrigger = (TriggerUDBv81)((StorageDesignUDBv81)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerUDBv81 newTrigger = (TriggerUDBv81)((StorageDesignUDBv81)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.addTriggersFromDesign(((StorageDesignUDBv81)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setTable(tableProxy);
                tableProxy.addTriggersFromDesign(((StorageDesignUDBv81)targetDesign).getTriggerSet());
            }
            if (this.getSchema() != null) {
                SchemaUDBv81 schema = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schema == null) {
                    SchemaUDBv81 newSchema = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    tableProxy.setSchema(newSchema);
                } else {
                    tableProxy.setSchema(schema);
                }
            }
            tableProxy.setPartKeyHashing(this.getPartKeyHashing());
            if (this.getTableSpace() != null) {
                tablespace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    newTablespace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTableSpace().getName());
                    newTablespace.setRawObject(true);
                    tableProxy.setTableSpace(newTablespace);
                } else {
                    tableProxy.setTableSpace(tablespace);
                }
            }
            if (this.getIndexInTableSpace() != null) {
                tablespace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().getByName(this.getIndexInTableSpace().getName());
                if (tablespace == null) {
                    newTablespace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getIndexInTableSpace().getName());
                    newTablespace.setRawObject(true);
                    tableProxy.setIndexInTableSpace(newTablespace);
                } else {
                    tableProxy.setIndexInTableSpace(tablespace);
                }
            }
            if (this.getLongInTableSpace() != null) {
                tablespace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().getByName(this.getLongInTableSpace().getName());
                if (tablespace == null) {
                    newTablespace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getLongInTableSpace().getName());
                    newTablespace.setRawObject(true);
                    tableProxy.setLongInTableSpace(newTablespace);
                } else {
                    tableProxy.setLongInTableSpace(tablespace);
                }
            }
            tableProxy.setInitialLogging(this.getInitialLogging());
            tableProxy.setDataCapture(this.getDataCapture());
            tableProxy.setFederated(this.getFederated());
            tableProxy.setSummaryQuery(this.getSummaryQuery());
            tableProxy.setRestrictOnDrop(this.getRestrictOnDrop());
            tableProxy.setValueCompression(this.getValueCompression());
            tableProxy.recreateColumnListSet(this.getColumnSet().toString());
            tableProxy.setSummaryQueryDefinition(this.getSummaryQueryDefinition());
            tableProxy.setSummaryStatus(this.getSummaryStatus());
            tableProxy.setSummaryMaintenance(this.getSummaryMaintenance());
            tableProxy.setSummaryRefreshOptions(this.getSummaryRefreshOptions());
            tableProxy.setSummaryQueryOptimization(this.getSummaryQueryOptimization());
            tableProxy.setSummaryIdentityColumn(this.getSummaryIdentityColumn());
            tableProxy.setSummaryCopyColumnDefaults(this.getSummaryCopyColumnDefaults());
            tableProxy.setReplicated(this.getReplicated());
            tableProxy.setUseRemoteOptions(this.getUseRemoteOptions());
            tableProxy.setRoRemoteServer(this.getRoRemoteServer());
            tableProxy.setRoRemoteSchema(this.getRoRemoteSchema());
            tableProxy.setRoRemoteTabName(this.getRoRemoteTabName());
            tableProxy.setOrganizeByDimensions(this.getOrganizeByDimensions());
            tableProxy.setDimensions(this.getDimensions());
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }
}

