/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.swingui.editor.storage.udb.BufferPoolPropertyDialogUDB;

public class BufferPoolUDB
extends AbstractStorageObjectDB2 {
    private static Object[] availablePageSizes = new Object[]{new Integer(4), new Integer(8), new Integer(16), new Integer(32)};
    private String scope = "";
    private InlineScopeList scopeSet = null;
    private int size = 1024;
    private String nodesWithDiffSize = "";
    private int pageSize = 4;
    private boolean useExtendedStorage = false;
    public static final String TYPE_NAME = "Bufferpool";

    @Override
    public String getIDPrefix() {
        return "BP";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateScopeSet(scope);
        } else {
            this.addScope(scope);
        }
        this.scope = this.getScopeSet().toString();
        this.fireDataFieldChange();
    }

    private void addScope(String scope) {
        String scopeName = scope.substring(scope.lastIndexOf(46) + 1, scope.length());
        if (!this.getScopeSet().contains(scopeName)) {
            this.getScopeSet().add(scopeName);
        }
    }

    public void recreateScopeSet(String scopes) {
        this.getScopeSet().clear();
        StringTokenizer st = new StringTokenizer(scopes, ",");
        while (st.hasMoreTokens()) {
            this.getScopeSet().add(st.nextToken().trim());
        }
    }

    public void setSize(int numberOfPages) {
        this.size = numberOfPages;
    }

    public int getSize() {
        return this.size;
    }

    public void setNodesWithDiffSize(String nodesWithDiffSize) {
        this.nodesWithDiffSize = nodesWithDiffSize;
    }

    public String getNodesWithDiffSize() {
        return this.nodesWithDiffSize;
    }

    public static Object[] getAvailablePageSizes() {
        return availablePageSizes;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setExtendedStorage(boolean useExtendedStorage) {
        this.useExtendedStorage = useExtendedStorage;
    }

    public boolean getExtendedStorage() {
        return this.useExtendedStorage;
    }

    public boolean isSystemBufferPool() {
        return false;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            BufferPoolPropertyDialogUDB dialog = new BufferPoolPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public InlineScopeList getScopeSet() {
        if (this.scopeSet == null) {
            this.scopeSet = new InlineScopeList();
        }
        return this.scopeSet;
    }

    public void clear() {
        this.getScopeSet().removeAllElements();
        this.scope = "";
    }

    public class InlineScopeList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

