/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.FileGroupSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;

public class IndexProxySqlServerv2k
extends IndexProxySqlServer {
    public IndexProxySqlServerv2k(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxySqlServerv2k(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)((StorageDesignSqlServerv2k)targetDesign).getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxySqlServerv2k indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxySqlServerv2k)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            indexProxy.setClustered(this.isClustered());
            if (this.getFilegroup() != null) {
                FileGroupSqlServerv2k fileGroup = (FileGroupSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (fileGroup == null) {
                    FileGroupSqlServerv2k newFileGroup = (FileGroupSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getFileGroupSet().createFileGroup();
                    newFileGroup.setName(this.getFilegroup().getName());
                    newFileGroup.setRawObject(true);
                    indexProxy.setFilegroup(newFileGroup);
                } else {
                    indexProxy.setFilegroup(fileGroup);
                }
            }
            indexProxy.setPadIndex(this.getPadIndex());
            indexProxy.setFillFactor(this.getFillFactor());
            indexProxy.setRecomputeStatistics(this.getRecomputeStatistics());
            indexProxy.setSortInTempDB(this.getSortInTempDB());
            indexProxy.setIgnoreDupKey(this.getIgnoreDupKey());
            indexProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
        }
    }

    @Override
    public String getLongName() {
        return this.getName();
    }
}

