/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageObjectSetOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class RoleSetOracle
extends StorageObjectSet
implements StorageObjectSetOracle {
    private static final Object[] PROTO_ARRAY = new RoleOracle[0];
    private List<RoleOracle> depOrderList = new ArrayList<RoleOracle>();

    public RoleOracle createRole() {
        return this.createRole(null);
    }

    public RoleOracle createRole(String id) {
        return (RoleOracle)this.createElement(id);
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Role";
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16);
    }

    public List<RoleOracle> getDependencyList() {
        this.depOrderList.clear();
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle rs = sd.getRoleSet();
        this.parseDependencies(this.getElementsList(), rs);
        return this.depOrderList;
    }

    private List<RoleOracle> parseDependencies(List roles, RoleSetOracle rs) {
        List<RoleOracle> depRoles = new ArrayList<RoleOracle>();
        for (int i = 0; i < roles.size(); ++i) {
            RoleOracle role = (RoleOracle)roles.get(i);
            Object[] depRoleIDs = role.getRolesSet().toArray();
            boolean depNotFound = false;
            for (int j = 0; j < depRoleIDs.length; ++j) {
                String depRoleID = (String)depRoleIDs[j];
                RoleOracle depRole = (RoleOracle)rs.getById(depRoleID);
                if (depRole == null || this.depOrderList.contains(depRole)) continue;
                depNotFound = true;
            }
            if (depNotFound) {
                depRoles.add(role);
                continue;
            }
            this.depOrderList.add(role);
        }
        if (!depRoles.isEmpty()) {
            if (depRoles.size() < roles.size()) {
                depRoles = this.parseDependencies(depRoles, rs);
            } else {
                this.depOrderList.addAll(depRoles);
                depRoles.clear();
            }
        }
        return depRoles;
    }
}

