/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.storage.MethodParamProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.MethodParamPropertyDialogOracle;

public class MethodParamProxyOracle
extends MethodParamProxy {
    protected String directionType = DIRECTION_TYPE_CHOICES[1];
    private String defaultValue = "";
    private boolean defaultValueChanged = false;
    protected String copyArgument = "YES";
    public static final String[] DIRECTION_TYPE_CHOICES = new String[]{"", "IN", "OUT", "IN OUT"};
    private static Set directionTypeSet = null;

    public MethodParamProxyOracle(MethodParam object, StorageDesign storageDesign) {
        super(object, storageDesign);
    }

    public MethodParamProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getCopyArgument() {
        return this.copyArgument;
    }

    public void setCopyArgument(String copyArgument) {
        if (ConstantsOracle.checkYesNo(copyArgument)) {
            this.copyArgument = copyArgument;
            this.fireDataFieldChange();
        }
    }

    public String getDirectionType() {
        return this.directionType;
    }

    public void setDirectionType(String directionType) {
        if (this.checkDirectionType(directionType)) {
            this.directionType = directionType;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkDirectionType(String value) {
        if (directionTypeSet == null) {
            directionTypeSet = new HashSet();
            directionTypeSet.addAll(Arrays.asList(DIRECTION_TYPE_CHOICES));
        }
        return directionTypeSet.contains(value);
    }

    public String getDefaultValue() {
        if (this.defaultValueChanged) {
            return this.defaultValue;
        }
        return ((MethodParam)this.getObject()).getDefaultValue();
    }

    public void setDefaultValue(String value) {
        if (value.equals(((MethodParam)this.getObject()).getDefaultValue())) {
            this.setDefaultValueChanged(false);
        } else {
            this.defaultValue = value;
            this.setDefaultValueChanged(true);
        }
    }

    public boolean isDefaultValueChanged() {
        return this.defaultValueChanged;
    }

    public void setDefaultValueChanged(boolean value) {
        this.defaultValueChanged = value;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MethodParamPropertyDialogOracle dialog = new MethodParamPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

