/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;

public abstract class MaterializedViewLogOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator,
OwnedObjectOracle {
    public static final String[] rowIDLoggedItems = new String[]{"YES", "NO"};
    public static final String[] pkLoggedItems = new String[]{"YES", "NO"};
    public static final String[] newValuesItems = new String[]{"Excluding", "Including"};
    public static final String[] cacheItems = new String[]{"No cache", "Cache"};
    public static final String[] parallelDegreeItems = new String[]{"NO", "YES"};
    public static final String[] seqLoggedItems = new String[]{"YES", "NO"};
    public static final String[] units = ConstantsOracle.UNITS_CHOICES;
    public static final String[] loggingItems = new String[]{"YES", "NO"};
    public static final String[] bufferModeItems = new String[]{"DEFAULT", "KEEP", "RECYCLE"};
    public static final String[] refreshItems = new String[]{" ", "SYNCHRONOUS", "FAST"};
    public static final String PURGE_SYNC = "IMMEDIATE SYNCHRONOUS";
    public static final String PURGE_ASYNC = "IMMEDIATE ASYNCHRONOUS";
    public static final String[] purgeItems = new String[]{" ", "IMMEDIATE ASYNCHRONOUS", "IMMEDIATE SYNCHRONOUS", "DEFERRED"};
    public static final String[] objectIDLoggedItems = new String[]{"YES", "NO"};
    public static final String defaultName = "mvLog_temp";
    private UserOracle user = null;
    private String rowIDLogged = "NO";
    private String pkLogged = "NO";
    private String newValues = "NO";
    private String cache = "";
    private String parallel = "";
    private String degree = "";
    private String sequenceLogged = "NO";
    private String objectIDLogged = "NO";
    private boolean commitSCN;
    private TableSpaceOracle tablespace;
    private String logging = "";
    private String bufferMode = "";
    private String percentFree = "";
    private String initrans = "";
    private String freelists = "";
    private String percentUsed = "";
    private String freelistGroups = "";
    private String initialExtent = "";
    private String initialExtentUnit = "";
    private String minExtent = "";
    private String minExtentUnit = "";
    private String percentIncrease = "";
    private String nextExtent = "";
    private String nextExtentUnit = "";
    private String maxExtent = "";
    private String maxExtentUnit = "";
    private boolean maxExtentUnlimited;
    private String tableSchema = "";
    private String tableName = "";
    private String logTableName;
    private TableProxyOracle tableProxy;
    private TableProxyOracle logTableProxy;
    private SegmentOracle segment;
    private String columns = "";
    private String columnNames = "";
    private ArrayList<ColumnProxyOracle> columnProxiesList;
    protected StorageObjectCollection partitions;
    private List propertyWrapperList = null;
    private String purgeType = "IMMEDIATE SYNCHRONOUS";
    private String purgeSWExpression = "";
    private String purgeNextExpression = "";
    private String purgeRIExpression = "";
    private String refreshType = "";
    private String refreshSLName = "";
    public static final String TYPE_NAME = "MVLog";

    public MaterializedViewLogOracle(StorageDesign storage) {
        this.setStorageDesign(storage);
    }

    @Override
    public UserOracle getUser() {
        TableProxyOracle tp = this.getTableProxy();
        if (tp != null) {
            Table table;
            SchemaObject so;
            UserOracle tableUser = tp.getUser();
            if (tableUser == null && (so = (table = (Table)tp.getObject()).getSchemaObject()) != null) {
                tableUser = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(so);
            }
            return tableUser;
        }
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
    }

    @Override
    public SchemaObject getSchemaObject() {
        TableProxyOracle tp = this.getTableProxy();
        if (tp != null) {
            return ((Table)tp.getObject()).getSchemaObject();
        }
        return super.getSchemaObject();
    }

    @Override
    public String getName() {
        TableProxyOracle tp = this.getTableProxy();
        if (tp != null) {
            return tp.getName();
        }
        return super.getName();
    }

    @Override
    public String getLongName() {
        TableProxyOracle tp = this.getTableProxy();
        if (tp != null) {
            return tp.getLongName();
        }
        Object res = null;
        String schema = this.getTableSchema();
        if (schema != null && !schema.isEmpty()) {
            return this.getStorageDesign().getFormatedSimpleName(schema) + "." + this.getStorageDesign().getFormatedSimpleName(this.getTableName());
        }
        return this.getStorageDesign().getFormatedSimpleName(this.getTableName());
    }

    @Override
    public String getLongNameDDL() {
        TableProxyOracle tp = this.getTableProxy();
        if (tp != null) {
            return tp.getLongNameDDL();
        }
        return super.getLongNameDDL();
    }

    public String getRowIDLogged() {
        return this.rowIDLogged;
    }

    public void setRowIDLogged(String rowIDLogged) {
        this.rowIDLogged = rowIDLogged;
        this.fireDataFieldChange();
    }

    public String getPkLogged() {
        return this.pkLogged;
    }

    public void setPkLogged(String pkLogged) {
        this.pkLogged = pkLogged;
        this.fireDataFieldChange();
    }

    public String getNewValues() {
        return this.newValues;
    }

    public void setNewValues(String newValues) {
        this.newValues = newValues;
        this.fireDataFieldChange();
    }

    public String getParallel() {
        if (this.logTableProxy != null) {
            return this.logTableProxy.getParallel();
        }
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
        if (this.logTableProxy != null) {
            this.logTableProxy.setParallel(parallel);
        }
        this.fireDataFieldChange();
    }

    public String getSequenceLogged() {
        return this.sequenceLogged;
    }

    public void setSequenceLogged(String sequenceLogged) {
        this.sequenceLogged = sequenceLogged;
        this.fireDataFieldChange();
    }

    public String getObjectIDLogged() {
        return this.objectIDLogged;
    }

    public void setObjectIDLogged(String objectIDLogged) {
        this.objectIDLogged = objectIDLogged;
    }

    public boolean isCommitSCN() {
        return this.commitSCN;
    }

    public void setCommitSCN(boolean commitSCN) {
        this.commitSCN = commitSCN;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
        this.fireDataFieldChange();
    }

    public ArrayList<ColumnProxyOracle> getColumnProxiesList() {
        if (this.columnProxiesList == null) {
            this.columnProxiesList = new ArrayList();
        }
        return this.columnProxiesList;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
        this.fireDataFieldChange();
    }

    public String getLogging() {
        if (this.logTableProxy != null) {
            return this.logTableProxy.getLogging();
        }
        return this.logging;
    }

    public void setLogging(String logging) {
        this.logging = logging;
        this.fireDataFieldChange();
    }

    public String getDegree() {
        if (this.logTableProxy != null) {
            return this.logTableProxy.getDegree();
        }
        return this.degree;
    }

    public void setDegree(String degree) {
        if (this.logTableProxy != null) {
            this.logTableProxy.setDegree(degree);
        }
        this.degree = degree;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTablespace() {
        if (this.logTableProxy != null) {
            return this.logTableProxy.getTableSpace();
        }
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOracle tablespace) {
        this.tablespace = tablespace;
        this.fireDataFieldChange();
    }

    public String getBufferPool() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCBufferPool());
        }
        return this.bufferMode;
    }

    public void setBufferPool(String bufferMode) {
        this.bufferMode = bufferMode;
        this.fireDataFieldChange();
    }

    public String getPercentFree() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getPCTFree());
        }
        return this.percentFree;
    }

    public void setPercentFree(String percentFree) {
        this.percentFree = percentFree;
        this.fireDataFieldChange();
    }

    public String getInitrans() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getInitrans());
        }
        return this.initrans;
    }

    public void setInitrans(String initrans) {
        this.initrans = initrans;
        this.fireDataFieldChange();
    }

    public String getFreelists() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCFreeLists());
        }
        return this.freelists;
    }

    public void setFreelists(String freelists) {
        this.freelists = freelists;
        this.fireDataFieldChange();
    }

    public String getPercentUsed() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getPCTUsed());
        }
        return this.percentUsed;
    }

    public void setPercentUsed(String percentUsed) {
        this.percentUsed = percentUsed;
        this.fireDataFieldChange();
    }

    public String getFreelistGroups() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCFreelistGroups());
        }
        return this.freelistGroups;
    }

    public void setFreelistGroups(String freelistGroups) {
        this.freelistGroups = freelistGroups;
        this.fireDataFieldChange();
    }

    public String getInitialExtent() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCInitialExtent());
        }
        return this.initialExtent;
    }

    public void setInitialExtent(String initialExtent) {
        this.initialExtent = initialExtent;
        this.fireDataFieldChange();
    }

    public String getInitialExtentUnit() {
        return this.initialExtentUnit;
    }

    public void setInitialExtentUnit(String initialExtentUnit) {
        this.initialExtentUnit = initialExtentUnit;
        this.fireDataFieldChange();
    }

    public String getMinExtent() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCMinExtents());
        }
        return this.minExtent;
    }

    public void setMinExtent(String minExtent) {
        this.minExtent = minExtent;
        this.fireDataFieldChange();
    }

    public String getMinExtentUnit() {
        return this.minExtentUnit;
    }

    public void setMinExtentUnit(String minExtentUnit) {
        this.minExtentUnit = minExtentUnit;
        this.fireDataFieldChange();
    }

    public String getPercentIncrease() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCPctIncrease());
        }
        return this.percentIncrease;
    }

    public void setPercentIncrease(String percentIncrease) {
        this.percentIncrease = percentIncrease;
        this.fireDataFieldChange();
    }

    public String getNextExtent() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCNextExtent());
        }
        return this.nextExtent;
    }

    public void setNextExtent(String nextExtent) {
        this.nextExtent = nextExtent;
        this.fireDataFieldChange();
    }

    public String getNextExtentUnit() {
        return this.nextExtentUnit;
    }

    public void setNextExtentUnit(String nextExtentUnit) {
        this.nextExtentUnit = nextExtentUnit;
        this.fireDataFieldChange();
    }

    public String getMaxExtent() {
        if (this.getSegment() != null) {
            return String.valueOf(this.getSegment().getSCMaxExtents());
        }
        return this.maxExtent;
    }

    public void setMaxExtent(String maxExtent) {
        this.maxExtent = maxExtent;
        this.fireDataFieldChange();
    }

    public String getMaxExtentUnit() {
        return this.maxExtentUnit;
    }

    public void setMaxExtentUnit(String maxExtentUnit) {
        this.maxExtentUnit = maxExtentUnit;
        this.fireDataFieldChange();
    }

    public boolean isMaxExtentUnlimited() {
        return this.maxExtentUnlimited;
    }

    public void setMaxExtentUnlimited(boolean maxExtentUnlimited) {
        this.maxExtentUnlimited = maxExtentUnlimited;
        this.fireDataFieldChange();
    }

    public void setPropertyWrapperList(List propertyWrapperList) {
        this.propertyWrapperList = propertyWrapperList;
        this.fireDataFieldChange();
    }

    public SegmentOracle getSegment() {
        if (this.logTableProxy != null) {
            return this.logTableProxy.getSegment();
        }
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        if (this.logTableProxy != null) {
            this.logTableProxy.setSegment(segment);
        }
        this.segment = segment;
        this.fireDataFieldChange();
    }

    public String getPurgeType() {
        return this.purgeType;
    }

    public void setPurgeType(String purgeType) {
        this.purgeType = purgeType;
        this.fireDataFieldChange();
    }

    public String getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshType(String refreshType) {
        this.refreshType = refreshType;
        this.fireDataFieldChange();
    }

    public String getPurgeSWExpression() {
        return this.purgeSWExpression;
    }

    public void setPurgeSWExpression(String purgeSWExpression) {
        this.purgeSWExpression = purgeSWExpression;
        this.fireDataFieldChange();
    }

    public String getPurgeNextExpression() {
        return this.purgeNextExpression;
    }

    public void setPurgeNextExpression(String purgeNextExpression) {
        this.purgeNextExpression = purgeNextExpression;
        this.fireDataFieldChange();
    }

    public String getPurgeRIExpression() {
        return this.purgeRIExpression;
    }

    public void setPurgeRIExpression(String purgeRIExpression) {
        this.purgeRIExpression = purgeRIExpression;
        this.fireDataFieldChange();
    }

    public String getRefreshSLName() {
        return this.refreshSLName;
    }

    public void setRefreshSLName(String refreshSLName) {
        this.refreshSLName = refreshSLName;
        this.fireDataFieldChange();
    }

    public List getListOfPermissions() {
        ArrayList list = new ArrayList();
        for (PermissionsOracle permissionsOracle : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
        }
        return list;
    }

    @Override
    public List getPropertyWrapperList() {
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_LOG_ICON", 16);
    }

    public abstract void copy(MaterializedViewLogOracle var1);

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getTableSchema() {
        if (this.tableProxy != null) {
            String lname = this.tableProxy.getLongName();
            int ind = lname.indexOf(46);
            if (ind > 0) {
                return Token.getName(lname.substring(0, ind));
            }
            return "";
        }
        return this.tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }

    public String getTableName() {
        if (this.tableProxy != null) {
            String lname = this.tableProxy.getLongName();
            int ind = lname.indexOf(46);
            if (ind > 0) {
                return Token.getName(lname.substring(ind + 1));
            }
            return Token.getName(lname);
        }
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TableProxyOracle getTableProxy() {
        return this.tableProxy;
    }

    public Table getTable() {
        if (this.getTableProxy() != null) {
            return this.tableProxy.getTable();
        }
        return null;
    }

    public void setTableProxy(TableProxyOracle tableProxy) {
        this.tableProxy = tableProxy;
    }

    public String getFormattedLongNameDDL() {
        if (this.tableProxy != null) {
            this.getStorageDesignOracle().getFormatedLongNameDDL(this.tableProxy);
        }
        if (this.tableSchema != null && !this.tableSchema.isEmpty()) {
            return this.getStorageDesignOracle().getFormatedName(this.tableSchema) + "." + this.getStorageDesignOracle().getFormatedName(this.tableName);
        }
        return this.getStorageDesignOracle().getFormatedName(this.tableName);
    }

    public String getLogTableName() {
        if (this.logTableProxy != null) {
            return this.logTableProxy.getName();
        }
        return this.logTableName;
    }

    public void setLogTableName(String logTableName) {
        this.logTableName = logTableName;
    }

    public TableProxyOracle getLogTableProxy() {
        return this.logTableProxy;
    }

    public void setLogTableProxy(TableProxyOracle logTableProxy) {
        this.logTableProxy = logTableProxy;
        if (logTableProxy != null) {
            logTableProxy.setLogTable(true);
        }
    }

    public String getColumnNames() {
        if ((this.columnNames == null || this.columnNames.isEmpty()) && !this.getColumns().isEmpty()) {
            this.columnNames = this.getStorageDesign().getFormatedNamesFromIDs(this.getColumns(), this.getStorageDesign().getColumnProxySet());
        }
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    public List<String> getSortedColumnNamesList() {
        ArrayList<String> list = new ArrayList<String>();
        String cs = this.getColumnNames();
        if (cs != null && !cs.isEmpty()) {
            String[] names;
            for (String name : names = cs.split(",")) {
                list.add(name.toUpperCase());
            }
            Collections.sort(list);
        }
        return list;
    }

    public String getSortedColumnNames() {
        List<String> list = this.getSortedColumnNamesList();
        boolean first = true;
        Object names = "";
        for (String name : list) {
            if (first) {
                names = name;
                first = false;
                continue;
            }
            names = (String)names + "," + name;
        }
        return names;
    }
}

