/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;

public class TableProxySetDB2v80
extends TableProxySetDB2 {
    public TableProxySetDB2v80(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public RelationalObjectProxy createProxy(DesignObject object) {
        String name;
        TableProxyDB2v80 proxy = new TableProxyDB2v80((Table)object, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            name = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            DataBaseDB2 db = null;
            if (name != null) {
                db = (DataBaseDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().getByName(name);
            }
            if (db != null && this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) {
                TableSpaceDB2 tableSpace = ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                proxy.setTableSpace(tableSpace);
                tableSpace.setDataBase(db);
                String namingRule = this.getDesign().getAppView().getSettings().getNamingRuleTablespaceDB2();
                String tname = ApplyNamingStandards.createTableSpaceDB2_Name(object.getName(), namingRule, object.getDesignPart().getName());
                tableSpace.setName(tname);
                if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace() && tableSpace.getStorageTemplate() != null) {
                    tableSpace.synchronizeStorageTemplateName();
                }
            }
        }
        if (!((name = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) == null || "".equalsIgnoreCase(name.trim()) || "[Implicit]".equalsIgnoreCase(name.trim()) || "PUBLIC".equalsIgnoreCase(name.trim()))) {
            Owner owner;
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name) == null) {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(name);
            } else {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name);
            }
            proxy.setOwner(owner);
        }
        return proxy;
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        String name;
        TableProxyDB2v80 proxy = new TableProxyDB2v80(design, id, longName, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            name = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            DataBaseDB2 db = null;
            if (name != null) {
                db = (DataBaseDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().getByName(name);
            }
            if (db != null && this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) {
                TableSpaceDB2 tableSpace = ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                proxy.setTableSpace(tableSpace);
                tableSpace.setDataBase(db);
            }
        }
        if ((name = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) != null && !"".equalsIgnoreCase(name.trim()) && !"[Implicit]".equalsIgnoreCase(name.trim())) {
            Owner owner;
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name) == null) {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(name);
            } else {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name);
            }
            proxy.setOwner(owner);
        }
        return proxy;
    }

    @Override
    public void doAfterAdd(RelationalObjectProxy addedProxy) {
        TableProxyDB2v80 proxy = (TableProxyDB2v80)addedProxy;
        Table table = (Table)proxy.getObject();
        if (!table.isBeingRecreated() && table.getTypeID().equals("4")) {
            proxy.setMaterializedQuery(TableProxyDB2v80.YES_NO_STATES[0]);
        }
    }
}

