/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TablePartitionDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TriggerDB2v80;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.TablePropertyDialogDB2v80;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyDB2v80
extends TableProxyDB2
implements ModelObjectSetListener,
StorageObjectListener {
    protected StorageObjectCollection fkeys;
    protected String partitioned = YES_NO_STATES[1];
    private String partitioningKey = "";
    private InlineList partitioningKeySet = null;
    protected String materializedQuery = YES_NO_STATES[1];
    protected String tableAccess = TABLE_ACCESS_STATES[0];
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String[] TABLE_ACCESS_STATES = new String[]{"NOT VOLATILE", "VOLATILE"};
    private static Set tableAccessSet = null;
    private boolean materializedQueryChanged = false;
    private boolean mqQueryDefinitionChanged = false;
    protected String mqQueryDefinition = "";
    protected String mqStatus = MQ_STATUS_STATES[0];
    protected String mqMaintenance = MQ_MAINTENANCE_STATES[0];
    protected String mqQueryOptimization = MQ_QUERY_OPTIMIZATION_STATES[0];
    protected String mqIdentityColumnAttr = MQ_IDENTITY_COLUMN_ATTR_STATES[0];
    protected String mqColumnDefaults = MQ_COLUMN_DEFAULTS_STATES[0];
    public static final String[] MQ_STATUS_STATES = new String[]{"MATERIALIZED QUERY", "NO DATA"};
    private static Set mqStatusSet = null;
    public static final String[] MQ_MAINTENANCE_STATES = new String[]{"BY SYSTEM", "BY USER"};
    private static Set mqMaintenanceSet = null;
    public static final String[] MQ_QUERY_OPTIMIZATION_STATES = new String[]{"ENABLE", "DISABLE"};
    private static Set mqQueryOptimizationSet = null;
    public static final String[] MQ_IDENTITY_COLUMN_ATTR_STATES = new String[]{"EXCLUDE", "INCLUDE"};
    private static Set mqIdentityColumnAttrSet = null;
    public static final String[] MQ_COLUMN_DEFAULTS_STATES = new String[]{"EXCLUDING", "INCLUDING", "USING TYPE DEFAULTS"};
    private static Set mqColumnDefaultsSet = null;
    private List propertyWrapperList = null;
    int numbChildren = 6;

    public TableProxyDB2v80(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyDB2v80.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxiesFromDesign(((StorageDesignDB2v80)storageDesign).getFKProxySet());
        ((StorageDesignDB2v80)storageDesign).getFKProxySet().addSetListener(this);
        this.tablePartitions = new StorageObjectCollection(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        this.tablePartitions.setParent(this);
        this.tablePartitions.setName(Messages.getString("TableProxyDB2v80.Partitions"));
        this.tablePartitions.setClassForParent(TableProxyDB2.class);
        this.tablePartitions.setSetMethod("setTable");
        this.tablePartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((StorageDesignDB2v80)storageDesign).getTablePartitionSet().addSetListener(this);
        this.addPartitionsFromDesign(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        if (this.partitioned.equalsIgnoreCase(YES_NO_STATES[0])) {
            this.enablePartitions();
        } else {
            this.disablePartitions();
        }
    }

    public TableProxyDB2v80(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyDB2v80.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.addFKProxiesFromDesign(((StorageDesignDB2v80)storageDesign).getFKProxySet());
        ((StorageDesignDB2v80)storageDesign).getFKProxySet().addSetListener(this);
        this.tablePartitions = new StorageObjectCollection(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        this.tablePartitions.setParent(this);
        this.tablePartitions.setName(Messages.getString("TableProxyDB2v80.Partitions"));
        this.tablePartitions.setSetMethod("setTable");
        this.tablePartitions.setClassForParent(TableProxyDB2v80.class);
        this.tablePartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((StorageDesignDB2v80)storageDesign).getTablePartitionSet().addSetListener(this);
        this.addPartitionsFromDesign(((StorageDesignDB2v80)storageDesign).getTablePartitionSet());
        if (this.partitioned.equalsIgnoreCase(YES_NO_STATES[0])) {
            this.enablePartitions();
        } else {
            this.disablePartitions();
        }
    }

    private void enablePartitions() {
        this.tablePartitions.setForbiddenCreateElement(false);
    }

    private void disablePartitions() {
        this.tablePartitions.setForbiddenCreateElement(true);
        this.tablePartitions.removeAll();
    }

    public StorageObjectCollection getTablePartitions() {
        return this.tablePartitions;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogDB2v80 dialog = new TablePropertyDialogDB2v80(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public void addFKProxiesFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexProxy ip = (IndexProxy)it.next();
            Index ind = (Index)ip.getObject();
            if (this.getObject() != ind.getContainerWithKeyObject() || !ind.isFK()) continue;
            ip.setParent(this.fkeys);
            this.fkeys.add(ip);
        }
    }

    public void addPartitionsFromDesign(StorageObjectSet set) {
        for (TablePartitionDB2v80 part : set) {
            part.addObjectListener(this);
            if (part.getTable() != null && part.getTable() == this) {
                part.setParent(this.tablePartitions);
                this.tablePartitions.add(part);
                continue;
            }
            this.tablePartitions.remove(part);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.numbChildren;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.getNumberOfChildren() - 1) {
            return this.fkeys;
        }
        if (index == this.getNumberOfChildren() - 2) {
            return this.tablePartitions;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (child == this.tablePartitions) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.fkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (child == this.tablePartitions) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ColumnProxy) {
                ColumnProxy cp = (ColumnProxy)event.getAffected();
                if (this.getObject() == ((Column)cp.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(event.getAffected());
                    cp.setPAC_Element(this);
                }
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                Index ind = (Index)ip.getObject();
                if (this.getObject() == ind.getContainerWithKeyObject()) {
                    if (ind.isFK() && !this.fkeys.contains(ip)) {
                        ip.setParent(this.fkeys);
                        ip.setPAC_Element(this);
                        this.fkeys.add(ip);
                    } else {
                        ip.addObjectListener(this);
                        if (!this.indexes.contains(ip)) {
                            this.addIndexProxyWithoutCheck(ip);
                        }
                    }
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)event.getAffected()).getObject().getObjectID());
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                ip.removeObjectListener(this);
                if (this.indexes.contains(ip)) {
                    this.indexes.remove(event.getAffected());
                }
                if (this.integrityIndexes.contains(ip)) {
                    this.integrityIndexes.remove(event.getAffected());
                }
                if (this.fkeys.contains(ip)) {
                    this.fkeys.remove(event.getAffected());
                }
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.getAffected() instanceof TablePartitionDB2v80) {
            TablePartitionDB2v80 part = (TablePartitionDB2v80)event.getAffected();
            if (part.getTable() != null && part.getTable() == this) {
                part.setParent(this.tablePartitions);
                this.tablePartitions.add(part);
                if (!this.getStorageDesign().isLoading()) {
                    part.removeObjectListener(this);
                    part.setPartNumber(this.tablePartitions.size());
                    part.addObjectListener(this);
                }
                this.synchronizeTablespacePartNum();
            } else {
                this.tablePartitions.remove(part);
                this.synchronizeTablespacePartNum();
            }
        }
    }

    private void synchronizeTablespacePartNum() {
        if (this.getTableSpace() != null) {
            this.getTableSpace().setMaxPartitionCount(this.getNumParts());
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TriggerDB2) {
                TriggerDB2 tr = (TriggerDB2)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getTable() != null && tr.getTable() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            } else if (event.getAffected() instanceof TablePartitionDB2v80) {
                TablePartitionDB2v80 part = (TablePartitionDB2v80)event.getAffected();
                part.addObjectListener(this);
                if (part.getTable() != null && part.getTable() == this) {
                    part.setParent(this.tablePartitions);
                    if (!this.getStorageDesign().isLoading()) {
                        part.removeObjectListener(this);
                        part.setPartNumber(this.tablePartitions.size());
                        part.addObjectListener(this);
                    }
                    this.tablePartitions.add(part);
                } else {
                    this.tablePartitions.remove(part);
                    if (!this.getStorageDesign().isLoading()) {
                        for (int i = 0; i < this.tablePartitions.size(); ++i) {
                            ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).removeObjectListener(this);
                            ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).setPartNumber(i + 1);
                            ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).addObjectListener(this);
                        }
                    }
                }
            } else if (event.getAffected() instanceof SynonymDB2) {
                SynonymDB2 syn = (SynonymDB2)event.getAffected();
                syn.addObjectListener(this);
                if (syn.getTable() != null && syn.getTable() == this) {
                    syn.setParent(this.synonyms);
                    this.synonyms.add(syn);
                } else {
                    this.synonyms.remove(syn);
                }
            } else if (event.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instCol = (InstanceDescriptorColumnDB2)event.getAffected();
                instCol.addObjectListener(this);
                if (instCol.getTable() != null && instCol.getTable() == this) {
                    instCol.setParent(this.instDescriptorCols);
                    this.instDescriptorCols.add(instCol);
                } else {
                    this.instDescriptorCols.remove(instCol);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof TriggerDB2) {
                TriggerDB2 tr = (TriggerDB2)event.getAffected();
                this.triggers.remove(tr);
                tr.removeObjectListener(this);
            } else if (event.getAffected() instanceof TablePartitionDB2v80) {
                TablePartitionDB2v80 part = (TablePartitionDB2v80)event.getAffected();
                this.tablePartitions.remove(part);
                for (int i = 0; i < this.tablePartitions.size(); ++i) {
                    ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).removeObjectListener(this);
                    ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).setPartNumber(i + 1);
                    ((TablePartitionDB2v80)this.tablePartitions.getElement(i)).removeObjectListener(this);
                }
                part.removeObjectListener(this);
            } else if (event.getAffected() instanceof SynonymDB2) {
                SynonymDB2 syn = (SynonymDB2)event.getAffected();
                this.synonyms.remove(syn);
                syn.removeObjectListener(this);
            } else if (event.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instCol = (InstanceDescriptorColumnDB2)event.getAffected();
                this.instDescriptorCols.remove(instCol);
                instCol.removeObjectListener(this);
            }
        }
    }

    @Override
    public void setPrimaryQuantity(int value) {
        this.primaryQuantity = value;
        this.fireUpdate();
        PRIMARY_QTY_CHANGED.setAffected(this);
        this.fireChange(PRIMARY_QTY_CHANGED);
        PRIMARY_QTY_CHANGED.setAffected(null);
    }

    public int getNumParts() {
        return this.tablePartitions.size();
    }

    public TablePartitionDB2[] getPartitions() {
        TablePartitionSetDB2 partitionsSet = ((StorageDesignDB2v80)this.getStorageDesign()).getTablePartitionSet();
        return partitionsSet.getPartitionsFor(this);
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(TableProxyDB2v80.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public static String[] getTableAccessChoices() {
        return TABLE_ACCESS_STATES;
    }

    protected boolean checkTableAccess(String value) {
        if (tableAccessSet == null) {
            tableAccessSet = new HashSet();
            tableAccessSet.addAll(Arrays.asList(TableProxyDB2v80.getTableAccessChoices()));
        }
        return tableAccessSet.contains(value);
    }

    public String getMaterializedQuery() {
        if (!this.materializedQueryChanged) {
            Table table = (Table)this.getObject();
            return table.isMaterializedQueryTable() ? YES_NO_STATES[0] : YES_NO_STATES[1];
        }
        return this.materializedQuery;
    }

    public void setMaterializedQuery(String materializedQuery) {
        if (this.checkYesNo(materializedQuery)) {
            this.materializedQuery = materializedQuery;
            boolean isMQTable = ((Table)this.getObject()).isMaterializedQueryTable();
            this.materializedQueryChanged = materializedQuery.equals(YES_NO_STATES[0]) ? !isMQTable : isMQTable;
            this.fireDataFieldChange();
        }
    }

    public boolean isMaterializedQueryChanged() {
        return this.materializedQueryChanged;
    }

    public void setMaterializedQueryChanged(boolean materializedQueryChanged) {
        this.materializedQueryChanged = materializedQueryChanged;
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String partitioned) {
        if (this.checkYesNo(partitioned)) {
            if (partitioned.equalsIgnoreCase(YES_NO_STATES[0]) && this.tableSpace != null) {
                ((TableSpaceDB2v80)this.tableSpace).setPartTable(this);
            }
            if (partitioned.equalsIgnoreCase(YES_NO_STATES[0])) {
                this.enablePartitions();
            } else {
                this.disablePartitions();
            }
            this.partitioned = partitioned;
            this.fireDataFieldChange();
        }
    }

    public String getTableAccess() {
        return this.tableAccess;
    }

    public void setTableAccess(String tableAccess) {
        if (this.checkTableAccess(tableAccess)) {
            this.tableAccess = tableAccess;
            this.fireDataFieldChange();
        }
    }

    public static String[] getMQStatusChoices() {
        return MQ_STATUS_STATES;
    }

    protected boolean checkMQStatus(String value) {
        if (mqStatusSet == null) {
            mqStatusSet = new HashSet();
            mqStatusSet.addAll(Arrays.asList(TableProxyDB2v80.getMQStatusChoices()));
        }
        return mqStatusSet.contains(value);
    }

    public static String[] getMQMaintenanceChoices() {
        return MQ_MAINTENANCE_STATES;
    }

    protected boolean checkMQMaintenance(String value) {
        if (mqMaintenanceSet == null) {
            mqMaintenanceSet = new HashSet();
            mqMaintenanceSet.addAll(Arrays.asList(TableProxyDB2v80.getMQMaintenanceChoices()));
        }
        return mqMaintenanceSet.contains(value);
    }

    public static String[] getMQQueryOptimizationChoices() {
        return MQ_QUERY_OPTIMIZATION_STATES;
    }

    protected boolean checkMQQueryOptimization(String value) {
        if (mqQueryOptimizationSet == null) {
            mqQueryOptimizationSet = new HashSet();
            mqQueryOptimizationSet.addAll(Arrays.asList(TableProxyDB2v80.getMQQueryOptimizationChoices()));
        }
        return mqQueryOptimizationSet.contains(value);
    }

    public static String[] getMQIdentityColumnAttrChoices() {
        return MQ_IDENTITY_COLUMN_ATTR_STATES;
    }

    protected boolean checkMQIdentityColumnAttr(String value) {
        if (mqIdentityColumnAttrSet == null) {
            mqIdentityColumnAttrSet = new HashSet();
            mqIdentityColumnAttrSet.addAll(Arrays.asList(TableProxyDB2v80.getMQIdentityColumnAttrChoices()));
        }
        return mqIdentityColumnAttrSet.contains(value);
    }

    public static String[] getMQColumnDefaultsChoices() {
        return MQ_COLUMN_DEFAULTS_STATES;
    }

    protected boolean checkMQColumnDefaults(String value) {
        if (mqColumnDefaultsSet == null) {
            mqColumnDefaultsSet = new HashSet();
            mqColumnDefaultsSet.addAll(Arrays.asList(TableProxyDB2v80.getMQColumnDefaultsChoices()));
        }
        return mqColumnDefaultsSet.contains(value);
    }

    public String getMqColumnDefaults() {
        return this.mqColumnDefaults;
    }

    public void setMqColumnDefaults(String mqColumnDefaults) {
        if (this.checkMQColumnDefaults(mqColumnDefaults)) {
            this.mqColumnDefaults = mqColumnDefaults;
            this.fireDataFieldChange();
        }
    }

    public String getMqIdentityColumnAttr() {
        return this.mqIdentityColumnAttr;
    }

    public void setMqIdentityColumnAttr(String mqIdentityColumnAttr) {
        if (this.checkMQIdentityColumnAttr(mqIdentityColumnAttr)) {
            this.mqIdentityColumnAttr = mqIdentityColumnAttr;
            this.fireDataFieldChange();
        }
    }

    public String getMqMaintenance() {
        return this.mqMaintenance;
    }

    public void setMqMaintenance(String mqMaintenance) {
        if (this.checkMQMaintenance(mqMaintenance)) {
            this.mqMaintenance = mqMaintenance;
            this.fireDataFieldChange();
        }
    }

    public boolean isMqQueryDefinitionChanged() {
        return this.mqQueryDefinitionChanged;
    }

    public void setMqQueryDefinitionChanged(boolean mqQueryDefinitionChanged) {
        this.mqQueryDefinitionChanged = mqQueryDefinitionChanged;
    }

    public String getMqQueryDefinition() {
        Table table;
        if (!this.mqQueryDefinitionChanged && (table = (Table)this.getObject()) != null) {
            return table.getUserDefinedSQL();
        }
        return this.mqQueryDefinition;
    }

    public void setMqQueryDefinition(String mqQueryDefinition) {
        String tableSQL;
        Table table = (Table)this.getObject();
        String string = tableSQL = table != null ? table.getUserDefinedSQL() : "";
        if (mqQueryDefinition.isEmpty() || mqQueryDefinition.equals(tableSQL)) {
            this.mqQueryDefinitionChanged = false;
        } else {
            this.mqQueryDefinitionChanged = true;
            this.mqQueryDefinition = mqQueryDefinition;
        }
        this.fireDataFieldChange();
    }

    public String getMqQueryOptimization() {
        return this.mqQueryOptimization;
    }

    public void setMqQueryOptimization(String mqQueryOptimization) {
        if (this.checkMQQueryOptimization(mqQueryOptimization)) {
            this.mqQueryOptimization = mqQueryOptimization;
            this.fireDataFieldChange();
        }
    }

    public String getMqStatus() {
        return this.mqStatus;
    }

    public void setMqStatus(String mqStatus) {
        if (this.checkMQStatus(mqStatus)) {
            this.mqStatus = mqStatus;
            this.fireDataFieldChange();
        }
    }

    public String getPartitioningKey() {
        return this.partitioningKey;
    }

    public void setPartitioningKey(String partitioningKey) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePartitioningKeySet(partitioningKey);
        } else {
            this.addColumnToPartitioningKey(partitioningKey);
        }
        this.partitioningKey = this.getPartitioningKeySet().toString();
        this.fireDataFieldChange();
    }

    private void addColumnToPartitioningKey(String partitioningKey) {
        this.getPartitioningKeySet().add(partitioningKey);
    }

    private void recreatePartitioningKeySet(String partKey) {
        this.getPartitioningKeySet().clear();
        StringTokenizer st = new StringTokenizer(partKey, ",");
        this.partitioningKeySet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getPartitioningKeySet().add(st.nextToken().trim());
        }
    }

    public InlineList getPartitioningKeySet() {
        if (this.partitioningKeySet == null) {
            this.partitioningKeySet = new InlineList();
        }
        return this.partitioningKeySet;
    }

    public void clear() {
        this.getPartitioningKeySet().removeAllElements();
        this.partitioningKey = "";
    }

    public String getPartKeySortOrder(String columnID) {
        StringTokenizer st = new StringTokenizer(this.partitioningKey, ",");
        String colID = "";
        String sortOrder = "";
        while (st.hasMoreTokens()) {
            colID = st.nextToken().trim();
            sortOrder = st.nextToken().trim();
            if (!colID.equalsIgnoreCase(columnID)) continue;
            return sortOrder;
        }
        return "ASC";
    }

    @Override
    public void setTableSpace(TableSpaceDB2 tableSpace) {
        if (this.tableSpace != tableSpace) {
            if (this.tableSpace != null) {
                ((TableSpaceDB2v80)this.tableSpace).setPartTable(null);
                this.tableSpace.setMaxPartitionCount(0);
            }
            if (this.partitioned.equalsIgnoreCase(YES_NO_STATES[0]) && tableSpace != null) {
                ((TableSpaceDB2v80)tableSpace).setPartTable(this);
                tableSpace.setMaxPartitionCount(this.getPartitions().length);
            }
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public StorageObjectCollection getFkeys() {
        return this.fkeys;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Edit Proc", this, "getEditProc", "setEditProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Valid Proc", this, "getValidProc", "setValidProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Audit", this, "getAudit", "setAudit", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Drop Restrict", this, "getDropRestrict", "setDropRestrict", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("CCSID", this, "getCcsid", "setCcsid", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Materialized Query", this, "getMaterializedQuery", "setMaterializedQuery", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Table Access", this, "getTableAccess", "setTableAccess", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyDB2v80 tableProxy = null;
        RelationalObjectProxy storageObject = targetDesign.getTableProxySet().getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxyDB2v80)storageObject;
        }
        if (tableProxy != null) {
            tableProxy.setName(this.getName());
            for (TablePartitionDB2v80 tablePart : this.getTablePartitions()) {
                TablePartitionDB2v80 targetTblPart = (TablePartitionDB2v80)((StorageDesignDB2v80)targetDesign).getTablePartitionSet().getByName(tablePart.getName());
                if (targetTblPart == null) {
                    TablePartitionDB2v80 newTblPart = (TablePartitionDB2v80)((StorageDesignDB2v80)targetDesign).getTablePartitionSet().createTablePartition();
                    newTblPart.setName(tablePart.getName());
                    newTblPart.setRawObject(true);
                    newTblPart.setTable(tableProxy);
                    continue;
                }
                targetTblPart.setTable(tableProxy);
            }
            for (SynonymDB2 synonym : this.getSynonyms()) {
                SynonymDB2 targetSynonym = (SynonymDB2)((StorageDesignDB2v80)targetDesign).getSynonymSet().getByName(synonym.getName());
                if (targetSynonym == null) {
                    SynonymDB2 newSynonym = ((StorageDesignDB2v80)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setRawObject(true);
                    newSynonym.setTable(tableProxy);
                    continue;
                }
                targetSynonym.setTable(tableProxy);
            }
            for (TriggerDB2v80 trigger : this.getTriggers()) {
                TriggerDB2v80 targetTrigger = (TriggerDB2v80)((StorageDesignDB2v80)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerDB2v80 newTrigger = (TriggerDB2v80)((StorageDesignDB2v80)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.addTriggersFromDesign(((StorageDesignDB2v80)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setTable(tableProxy);
                tableProxy.addTriggersFromDesign(((StorageDesignDB2v80)targetDesign).getTriggerSet());
            }
            if (this.getOwner() != null) {
                Owner owner = (Owner)((StorageDesignDB2v80)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    Owner newOwner = (Owner)((StorageDesignDB2v80)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    tableProxy.setOwner(newOwner);
                } else {
                    tableProxy.setOwner(owner);
                }
            }
            if (this.getTableSpace() != null) {
                TableSpaceDB2 tblSpace = (TableSpaceDB2)((StorageDesignDB2v80)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tblSpace == null) {
                    TableSpaceDB2 newTblSpace = ((StorageDesignDB2v80)targetDesign).getTableSpaceSet().createTableSpace();
                    newTblSpace.setName(this.getTableSpace().getName());
                    newTblSpace.setRawObject(true);
                    tableProxy.setTableSpace(newTblSpace);
                } else {
                    tableProxy.setTableSpace(tblSpace);
                }
            }
            tableProxy.setObid(this.getObid());
            tableProxy.setEditProc(this.getEditProc());
            tableProxy.setValidProc(this.getValidProc());
            tableProxy.setAudit(this.getAudit());
            tableProxy.setDataCapture(this.getDataCapture());
            tableProxy.setDropRestrict(this.getDropRestrict());
            tableProxy.setCcsid(this.getCcsid());
            tableProxy.setLabel(this.getLabel());
            tableProxy.setPartitioned(this.getPartitioned());
            tableProxy.setMaterializedQuery(this.getMaterializedQuery());
            tableProxy.setTableAccess(this.getTableAccess());
            tableProxy.setMqQueryDefinition(this.getMqQueryDefinition());
            tableProxy.setMqStatus(this.getMqStatus());
            tableProxy.setMqMaintenance(this.getMqMaintenance());
            tableProxy.setMqQueryOptimization(this.getMqQueryOptimization());
            tableProxy.setMqIdentityColumnAttr(this.getMqIdentityColumnAttr());
            tableProxy.setMqColumnDefaults(this.getMqColumnDefaults());
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }

    public TablePartitionDB2v80 createPartition() {
        TablePartitionDB2v80 part = (TablePartitionDB2v80)this.tablePartitions.createElement(null);
        part.setTable(this);
        return part;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

