/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class VisibleTablesCollection
extends StorageObjectCollection
implements RelationalObjectProxySetListener,
StorageObjectListener,
ObjectListener {
    AbstractStorageDesignDB2 storageDesign = null;

    public VisibleTablesCollection(AbstractStorageDesignDB2 design) {
        this.storageDesign = design;
        this.registerToTableProxyFromDesign(design.getTableProxySet());
        design.getTableProxySet().addSetListener(this);
        this.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
    }

    public StorageObject[] getElements() {
        Object[] arr = this.getElementsList().toArray();
        StorageObject[] stoArray = new StorageObject[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            stoArray[i] = (StorageObject)arr[i];
        }
        return stoArray;
    }

    private void registerToTableProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableProxyDB2 tp = (TableProxyDB2)it.next();
            tp.addObjectListener(this);
            Table table = (Table)tp.getObject();
            table.addObjectListener(this);
            if (table.getTypeSubstitution() != null) continue;
            tp.setParent(this);
            this.add(tp);
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        TableProxyDB2 tp;
        Table table;
        if (event.isType(1)) {
            TableProxyDB2 tp2;
            Table table2;
            if (event.getAffected() instanceof TableProxy && (table2 = (Table)(tp2 = (TableProxyDB2)event.getAffected()).getObject()).getTypeSubstitution() == null) {
                tp2.addObjectListener(this);
                tp2.setParent(this);
                this.add(tp2);
            }
        } else if (event.isType(0) && event.getAffected() instanceof TableProxy && (table = (Table)(tp = (TableProxyDB2)event.getAffected()).getObject()).getTypeSubstitution() == null) {
            tp.removeObjectListener(this);
            this.remove(tp);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        TableProxyDB2 tp;
        Table table;
        if (event.getAffected() instanceof TableProxy && (table = (Table)(tp = (TableProxyDB2)event.getAffected()).getObject()).getTypeSubstitution() == null) {
            tp.setParent(this);
            this.add(tp);
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.ROOT_CHANGED) && object instanceof Table && this.storageDesign.getProxy(object) != null) {
            TableProxyDB2 tp = (TableProxyDB2)this.storageDesign.getProxy(object);
            if (((Table)object).getTypeSubstitution() == null) {
                tp.addObjectListener(this);
                this.add(tp);
            } else {
                tp.removeObjectListener(this);
                this.remove(tp);
            }
        }
    }
}

