/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;

public class TableProxySetDB2
extends TableProxySet {
    public TableProxySetDB2(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public RelationalObjectProxy createProxy(DesignObject object) {
        String ownerName;
        TableProxyDB2 proxy = new TableProxyDB2((Table)object, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            String name = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            DataBaseDB2 db = null;
            if (name != null) {
                db = (DataBaseDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().getByName(name);
            }
            if (db != null && this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) {
                TableSpaceDB2 tableSpace = ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                proxy.setTableSpace(tableSpace);
                tableSpace.setDataBase(db);
            }
        }
        if (!((ownerName = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) == null || "".equalsIgnoreCase(ownerName.trim()) || "[Implicit]".equalsIgnoreCase(ownerName.trim()) || "PUBLIC".equalsIgnoreCase(ownerName.trim()))) {
            Owner owner;
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(ownerName) == null) {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(ownerName);
                owner.setName(ownerName);
            } else {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(ownerName);
            }
            proxy.setOwner(owner);
        }
        return proxy;
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        String ownerName;
        TableProxyDB2 proxy = new TableProxyDB2(design, id, longName, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            String name = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            DataBaseDB2 db = null;
            if (name != null) {
                db = (DataBaseDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().getByName(name);
            }
            if (db != null && this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) {
                TableSpaceDB2 tableSpace = ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                proxy.setTableSpace(tableSpace);
                tableSpace.setDataBase(db);
            }
        }
        if ((ownerName = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) != null && !"".equalsIgnoreCase(ownerName.trim()) && !"[Implicit]".equalsIgnoreCase(ownerName.trim())) {
            Owner owner;
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(ownerName) == null) {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(ownerName);
                owner.setName(ownerName);
            } else {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(ownerName);
            }
            proxy.setOwner(owner);
        }
        return proxy;
    }

    @Override
    public TableProxyDB2 getByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            TableProxyDB2 tpo = (TableProxyDB2)it.next();
            if (!name.equals(tpo.getName())) continue;
            return tpo;
        }
        return null;
    }
}

