/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.StorageTemplatePropertyDialogDB2;

public class StorageTemplateDB2
extends AbstractStorageObjectDB2 {
    public static final String[] GBCACHE = new String[]{"", "CHANGED", "ALL", "SYSTEM", "NONE"};
    private VCatDB2 vcat = null;
    private StorageGroupDB2 storageGroup = null;
    private int sgPriqty = 0;
    private int sgSeqty = 0;
    private boolean sgErase = false;
    private int freePage = 0;
    private int pctFree = 5;
    private String gbCache = GBCACHE[0];
    private boolean trackMode = true;
    private boolean define = true;
    StorageObjectCollection tablespaces;
    StorageObjectCollection partitions;
    StorageObjectCollection indexes;
    StorageObjectCollection atindexes;
    public static final String TYPE_NAME = "Template";
    public static final String OLD_TYPE_NAME = "StorageTemplate";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ST";
    }

    public void setVCat(VCatDB2 vcat) {
        this.vcat = vcat;
        if (vcat != null) {
            this.storageGroup = null;
        }
        this.fireDataFieldChange();
    }

    public VCatDB2 getVCat() {
        return this.vcat;
    }

    public void setStorageGroup(StorageGroupDB2 storageGroup) {
        this.storageGroup = storageGroup;
        if (storageGroup != null) {
            this.vcat = null;
        }
        this.fireDataFieldChange();
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    public int getSgPriqty() {
        return this.sgPriqty;
    }

    public void setSgPriqty(int sgPriqty) {
        this.sgPriqty = sgPriqty;
        this.fireDataFieldChange();
    }

    public int getSgSeqty() {
        return this.sgSeqty;
    }

    public void setSgSeqty(int sgSeqty) {
        this.sgSeqty = sgSeqty;
        this.fireDataFieldChange();
    }

    public boolean isSgErase() {
        return this.sgErase;
    }

    public void setSgErase(boolean sgErase) {
        this.sgErase = sgErase;
        this.fireDataFieldChange();
    }

    public int getFreePage() {
        return this.freePage;
    }

    public void setFreePage(int freePage) {
        this.freePage = freePage;
        this.fireDataFieldChange();
    }

    public int getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(int pctFree) {
        this.pctFree = pctFree;
        this.fireDataFieldChange();
    }

    public String getGbCache() {
        return this.gbCache;
    }

    public void setGbCache(String gbCache) {
        this.gbCache = gbCache;
        this.fireDataFieldChange();
    }

    public boolean isTrackMode() {
        return this.trackMode;
    }

    public void setTrackMode(boolean trackMode) {
        this.trackMode = trackMode;
        this.fireDataFieldChange();
    }

    public boolean isDefine() {
        return this.define;
    }

    public void setDefine(boolean define) {
        this.define = define;
        this.fireDataFieldChange();
    }

    public static final String[] getGBCacheValues() {
        return GBCACHE;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StorageTemplatePropertyDialogDB2 dialog = new StorageTemplatePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public boolean equalsToST(Object object) {
        if (object instanceof StorageTemplateDB2) {
            StorageTemplateDB2 st = (StorageTemplateDB2)object;
            if (this.getStorageGroup() != st.getStorageGroup()) {
                return false;
            }
            if (this.getVCat() != st.getVCat()) {
                return false;
            }
            if (this.getFreePage() != st.getFreePage()) {
                return false;
            }
            if (this.getPctFree() != st.getPctFree()) {
                return false;
            }
            if (this.getSgPriqty() != st.getSgPriqty()) {
                return false;
            }
            if (this.getSgSeqty() != st.getSgSeqty()) {
                return false;
            }
            if (this.isDefine() != st.isDefine()) {
                return false;
            }
            if (this.isSgErase() != st.isSgErase()) {
                return false;
            }
            if (this.isTrackMode() != st.isTrackMode()) {
                return false;
            }
            return this.getGbCache().equalsIgnoreCase(st.getGbCache());
        }
        return false;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        StorageTemplateDB2 storageTemplate = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                storageTemplate = (StorageTemplateDB2)storageObject;
            }
        } else {
            storageTemplate = ((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().createStorageTemplate();
        }
        if (storageTemplate != null) {
            storageTemplate.setName(this.getName());
            if (this.getVCat() != null) {
                VCatDB2 targetVCat = (VCatDB2)((AbstractStorageDesignDB2)targetDesign).getVCatSet().getByName(this.getVCat().getName());
                if (targetVCat == null) {
                    VCatDB2 newVCat = ((AbstractStorageDesignDB2)targetDesign).getVCatSet().createVCat();
                    newVCat.setName(this.getVCat().getName());
                    newVCat.setRawObject(true);
                    storageTemplate.setVCat(newVCat);
                } else {
                    storageTemplate.setVCat(targetVCat);
                }
            }
            if (this.getStorageGroup() != null) {
                StorageGroupDB2 targetGroup = (StorageGroupDB2)((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().getByName(this.getStorageGroup().getName());
                if (targetGroup == null) {
                    StorageGroupDB2 newGroup = ((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().createStorageGroup();
                    newGroup.setName(this.getStorageGroup().getName());
                    newGroup.setRawObject(true);
                    storageTemplate.setStorageGroup(newGroup);
                } else {
                    storageTemplate.setStorageGroup(targetGroup);
                }
            }
            storageTemplate.setSgPriqty(this.getSgPriqty());
            storageTemplate.setSgSeqty(this.getSgSeqty());
            storageTemplate.setSgErase(this.isSgErase());
            storageTemplate.setFreePage(this.getFreePage());
            storageTemplate.setPctFree(this.getPctFree());
            storageTemplate.setGbCache(this.getGbCache());
            storageTemplate.setTrackMode(this.isTrackMode());
            storageTemplate.setDefine(this.isDefine());
            storageTemplate.setComment(this.getComment());
            storageTemplate.setRawObject(false);
        }
    }

    public boolean isUsedInOtherDefinitions(StorageObject stObject) {
        for (TableSpaceDB2 ts : ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet()) {
            if (ts.getStorageTemplate() == null || ts == stObject || ts.getStorageTemplate() != this) continue;
            return true;
        }
        Iterator it = this.getStorageDesign().getIndexProxySet().iterator();
        while (it.hasNext()) {
            IndexProxyDB2 index;
            Object obj = it.next();
            if (!(obj instanceof IndexProxyDB2) || (index = (IndexProxyDB2)obj).getStorageTemplate() == null || index == stObject || index.getStorageTemplate() != this) continue;
            return true;
        }
        for (PartitionDB2 part : ((AbstractStorageDesignDB2)this.getStorageDesign()).getPartitionSet()) {
            if (part.getStorageTemplate() == null || part == stObject || part.getStorageTemplate() != this) continue;
            return true;
        }
        for (AUXTableIndexDB2 tableIndexDB2 : ((AbstractStorageDesignDB2)this.getStorageDesign()).getAUXTableIndexSet()) {
            if (tableIndexDB2.getStorageTemplate() == null || tableIndexDB2 == stObject || tableIndexDB2.getStorageTemplate() != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TEMPLATE_ICON", 16);
    }
}

