/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.StorageGroupPropertyDialogDB2;

public class StorageGroupDB2
extends AbstractStorageObjectDB2 {
    private String volumes = "";
    private VolumeSet volumeSet = null;
    private boolean smsManaged = false;
    private int smsVolumes = 1;
    private VCatDB2 vcat = null;
    private String users = "";
    private UserSet userSet = null;
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    private static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "StorageGroup";

    public StorageGroupDB2(StorageDesign storage) {
        this.setStorageDesign(storage);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "STG";
    }

    protected String getDefaultNamePrefix() {
        return "STOGR";
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    private void addVolume(String volume) {
        if (!this.getVolumeSet().contains(volume)) {
            this.getVolumeSet().add(volume);
        }
    }

    public void recreateVolumeSet(String volumes) {
        this.getVolumeSet().clear();
        StringTokenizer st = new StringTokenizer(volumes, ",");
        while (st.hasMoreTokens()) {
            String volume = st.nextToken().trim();
            if (this.getVolumeSet().contains(volume)) continue;
            this.getVolumeSet().add(volume);
        }
        this.volumes = this.getVolumeSet().toString();
        this.fireDataFieldChange();
    }

    public void setVolumes(String volumes) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateVolumeSet(volumes);
        } else {
            this.addVolume(volumes);
        }
        this.volumes = this.getVolumeSet().toString();
        this.fireDataFieldChange();
    }

    public String getVolumes() {
        return this.volumes;
    }

    public String getVolumesNames() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.volumes, ",");
        while (st.hasMoreTokens()) {
            String volID = st.nextToken().trim();
            VolumesDB2 volume = (VolumesDB2)this.getStorageDesignDB2().getVolumesSet().getById(volID);
            if (volume == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\"" + volume.getName() + "\"");
        }
        return result.toString();
    }

    public void setSMSManaged(boolean value) {
        if (this.smsManaged != value) {
            this.smsManaged = value;
            this.fireDataFieldChange();
        }
    }

    public boolean isSMSManaged() {
        return this.smsManaged;
    }

    public void setSMSVolumes(int smsVolumes) {
        if (this.smsVolumes != smsVolumes) {
            this.smsVolumes = smsVolumes;
            this.fireDataFieldChange();
        }
    }

    public int getSMSVolumes() {
        return this.smsVolumes;
    }

    public VCatDB2 getVCat() {
        return this.vcat;
    }

    public void setVCat(VCatDB2 vcat) {
        if (this.vcat != vcat) {
            this.vcat = vcat;
            this.addObjectListener(vcat);
            this.fireDataFieldChange();
        }
    }

    public String getAsteriskVolumes() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.getSMSVolumes(); ++i) {
            buffer.append('\'').append('*').append('\'');
            if (i >= this.getSMSVolumes() - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private void addUser(String user) {
        if (!this.getUserSet().contains(user)) {
            this.getUserSet().add(user);
        }
    }

    public void recreateUserSet(String users) {
        this.getUserSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.getUserSet().add(st.nextToken().trim());
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public void setUsers(String users) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(users);
        } else {
            this.addUser(users);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public String getUserNames() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.users, ",");
        while (st.hasMoreTokens()) {
            String userID = st.nextToken().trim();
            Owner owner = (Owner)this.getStorageDesignDB2().getOwnerSet().getById(userID);
            if (owner == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(owner.getName());
        }
        return result.toString();
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clearUsers() {
        this.getUserSet().removeAllElements();
        this.users = "";
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StorageGroupPropertyDialogDB2 dialog = new StorageGroupPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public VolumeSet getVolumeSet() {
        if (this.volumeSet == null) {
            this.volumeSet = new VolumeSet();
        }
        return this.volumeSet;
    }

    public void clearVolumes() {
        this.getVolumeSet().removeAllElements();
        this.volumes = "";
    }

    public boolean containsTableSpace(TableSpaceDB2 so) {
        return this.getName().equalsIgnoreCase("SYSDEFLT") ? so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() != null && this == so.getStorageTemplate().getStorageGroup() || so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() == null && so.getDataBase() != null && this == so.getDataBase().getStorageGroup() || so.getStorageTemplate() == null && so.getDataBase() != null && this == so.getDataBase().getStorageGroup() || so.getStorageTemplate() == null && so.getDataBase() == null : so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() != null && this == so.getStorageTemplate().getStorageGroup() || so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() == null && so.getDataBase() != null && this == so.getDataBase().getStorageGroup() || so.getStorageTemplate() == null && so.getDataBase() != null && this == so.getDataBase().getStorageGroup();
    }

    public boolean containsIndex(IndexProxyDB2 so) {
        TableProxyDB2 proxy = (TableProxyDB2)so.getTableProxy();
        return this.getName().equalsIgnoreCase("SYSDEFLT") ? so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() != null && this == so.getStorageTemplate().getStorageGroup() || so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() == null && so.getTableProxy() != null && proxy.getTableSpace() != null && proxy.getTableSpace().getDataBase() != null && proxy.getTableSpace().getDataBase().getStorageGroup() != null && this == proxy.getTableSpace().getDataBase().getStorageGroup() || so.getStorageTemplate() == null && proxy.getTableSpace() != null && proxy.getTableSpace().getDataBase() != null && proxy.getTableSpace().getDataBase().getStorageGroup() != null && this == proxy.getTableSpace().getDataBase().getStorageGroup() || so.getStorageTemplate() == null && proxy.getTableSpace() != null && proxy.getTableSpace().getDataBase() != null && proxy.getTableSpace().getDataBase().getStorageGroup() == null || so.getStorageTemplate() == null && proxy.getTableSpace() == null : so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() != null && this == so.getStorageTemplate().getStorageGroup() || so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() == null && so.getTableProxy() != null && proxy.getTableSpace() != null && proxy.getTableSpace().getDataBase() != null && proxy.getTableSpace().getDataBase().getStorageGroup() != null && this == proxy.getTableSpace().getDataBase().getStorageGroup() || so.getStorageTemplate() == null && so.getTableProxy() != null && proxy.getTableSpace() != null && proxy.getTableSpace().getDataBase() != null && proxy.getTableSpace().getDataBase().getStorageGroup() != null && this == proxy.getTableSpace().getDataBase().getStorageGroup();
    }

    public boolean containsAUXTableIndex(AUXTableIndexDB2 so) {
        return this.getName().equalsIgnoreCase("SYSDEFLT") ? so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() != null && this == so.getStorageTemplate().getStorageGroup() || so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() == null && so.getTableProxy() != null && so.getTableProxy().getTableSpace() != null && so.getTableProxy().getTableSpace().getDataBase() != null && so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() || so.getStorageTemplate() == null && so.getTableProxy() != null && so.getTableProxy().getTableSpace() != null && so.getTableProxy().getTableSpace().getDataBase() != null && so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() || so.getStorageTemplate() == null && so.getTableProxy() != null && so.getTableProxy().getTableSpace() != null && so.getTableProxy().getTableSpace().getDataBase() != null && so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() == null || so.getStorageTemplate() == null && so.getTableProxy().getTableSpace() == null : so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() != null && this == so.getStorageTemplate().getStorageGroup() || so.getStorageTemplate() != null && so.getStorageTemplate().getStorageGroup() == null && so.getTableProxy() != null && so.getTableProxy().getTableSpace() != null && so.getTableProxy().getTableSpace().getDataBase() != null && so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() || so.getStorageTemplate() == null && so.getTableProxy() != null && so.getTableProxy().getTableSpace() != null && so.getTableProxy().getTableSpace().getDataBase() != null && so.getTableProxy().getTableSpace().getDataBase().getStorageGroup() != null && this == so.getTableProxy().getTableSpace().getDataBase().getStorageGroup();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        StorageGroupDB2 storageGroup = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                storageGroup = (StorageGroupDB2)storageObject;
            }
        } else {
            storageGroup = ((AbstractStorageDesignDB2)targetDesign).getStorageGroupSet().createStorageGroup();
        }
        if (storageGroup != null) {
            storageGroup.setName(this.getName());
            if (this.getVCat() != null) {
                VCatDB2 targetVCat = (VCatDB2)((AbstractStorageDesignDB2)targetDesign).getVCatSet().getByName(this.getVCat().getName());
                if (targetVCat == null) {
                    VCatDB2 newVCat = ((AbstractStorageDesignDB2)targetDesign).getVCatSet().createVCat();
                    newVCat.setName(this.getVCat().getName());
                    newVCat.setRawObject(true);
                    storageGroup.setVCat(newVCat);
                } else {
                    storageGroup.setVCat(targetVCat);
                }
            }
            storageGroup.setSMSManaged(this.isSMSManaged());
            storageGroup.setSMSVolumes(this.getSMSVolumes());
            storageGroup.recreateVolumeSet(this.getVolumeSet().toString());
            storageGroup.recreateUserSet(this.getUserSet().toString());
            storageGroup.setGrantOption(this.getGrantOption());
            storageGroup.setRawObject(false);
            storageGroup.setComment(this.getComment());
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }

    public class VolumeSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

