/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.util.compare.StringComparator;

public class PrivilegesDB2
extends StorageObject {
    protected DataBaseDB2 db = null;
    protected Owner user = null;
    private String systemPrivileges = "";
    private PrivilegesSet systemPrivilegesSet = null;
    private static final String[] PRIVILEGES = new String[]{"DBADM", "DBCTRL", "DBMAINT", "CREATETAB", "CREATETS", "DISPLAYDB", "DROP", "IMAGCOMPY", "LOAD", "RECOVERDB", "REORG", "REPAIR", "STARTDB", "STATS", "STOPDB"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "Privileges";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Priv";
    }

    private void addSystemPrivileges(String systemPrivileges) {
        if (!this.getSystemPrivilegesSet().contains(systemPrivileges)) {
            this.getSystemPrivilegesSet().add(systemPrivileges);
        }
    }

    private void recreateSystemPrivilegesSet(String privileges) {
        this.getSystemPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.systemPrivilegesSet = new PrivilegesSet();
        while (st.hasMoreTokens()) {
            String privilege = st.nextToken().trim();
            if (!this.checkPrivileges(privilege)) continue;
            this.getSystemPrivilegesSet().add(privilege);
        }
    }

    public void setSystemPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else if (this.checkPrivileges(privilege)) {
            this.addSystemPrivileges(privilege);
        }
        this.systemPrivileges = this.getSystemPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public PrivilegesSet getSystemPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new PrivilegesSet();
        }
        return this.systemPrivilegesSet;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    public void clear() {
        this.getSystemPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(PrivilegesDB2.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    public DataBaseDB2 getDb() {
        return this.db;
    }

    public void setDb(DataBaseDB2 db) {
        if (this.db != db) {
            this.db = db;
            this.fireDataFieldChange();
        }
    }

    public Owner getUser() {
        return this.user;
    }

    public void setUser(Owner user) {
        if (this.user != user) {
            this.user = user;
            this.setPAC_Element(user);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PrivilegesDB2 privilege = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getPrivilegesSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                privilege = (PrivilegesDB2)stObject;
            }
        } else {
            privilege = ((AbstractStorageDesignDB2)targetDesign).getPrivilegesSet().createPriv();
        }
        if (privilege != null) {
            privilege.setName(this.getName());
            if (this.getDb() != null) {
                DataBaseDB2 database = (DataBaseDB2)((AbstractStorageDesignDB2)targetDesign).getDataBaseSet().getByName(this.getDb().getName());
                if (database == null) {
                    DataBaseDB2 newDatabase = ((AbstractStorageDesignDB2)targetDesign).getDataBaseSet().createDataBase();
                    newDatabase.setName(this.getDb().getName());
                    newDatabase.setRawObject(true);
                    privilege.setDb(newDatabase);
                } else {
                    privilege.setDb(database);
                }
            }
            if (this.getUser() != null) {
                Owner owner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().getByName(this.getUser().getName());
                if (owner == null) {
                    Owner newOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getUser().getName());
                    newOwner.setRawObject(true);
                    privilege.setUser(newOwner);
                } else {
                    privilege.setUser(owner);
                }
            }
            privilege.recreateSystemPrivilegesSet(this.getSystemPrivilegesSet().toString());
            privilege.setGrantOption(this.getGrantOption());
            privilege.setRawObject(false);
        }
    }

    public class PrivilegesSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

