/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;

public class InstanceDescriptorColumnDB2
extends StorageObject
implements DataTypeObject {
    private TableProxyDB2 table;
    private String typeId;
    private boolean isReference;
    private String size;
    private int precision;
    private int scale;
    public static final short LOGICAL_TYPE = 0;
    public static final short DISTINCT_TYPE = 1;
    public static final short STRUCTURED_TYPE = 2;
    private short use = 0;
    public static final String DEFAULT_NAME = "InstanceDescriptorCol";
    public static final String TYPE_NAME = "InstanceDescriptorCol";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return "InstanceDescriptorCol";
    }

    @Override
    public String getIDPrefix() {
        return "DescrCol";
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public void setReference(boolean isReference) {
        this.isReference = isReference;
        this.fireDataFieldChange();
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
        this.fireDataFieldChange();
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setScale(int scale) {
        this.scale = scale;
        this.fireDataFieldChange();
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public void setSize(String size) {
        this.size = size;
        this.fireDataFieldChange();
    }

    public short getUse() {
        return this.use;
    }

    public void setUse(short use) {
        this.use = use;
        this.fireDataFieldChange();
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
        this.fireDataFieldChange();
    }

    @Override
    public DesignObject getType() {
        if (this.typeId == null) {
            return this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        if (this.getDesign().getDesignObject(this.typeId) == null) {
            return this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.getDesign().getDesignObject(this.typeId);
    }

    @Override
    public void setType(DesignObject type) {
        this.typeId = type == null ? null : type.getObjectID();
        this.fireDataFieldChange();
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    public String formatDataType() {
        if (this.getType() != null) {
            String fSize = "";
            int fPrecision = 0;
            int fScale = 0;
            Object dtName = "NONE";
            if (this.getType() instanceof LogicalDatatype) {
                fSize = this.size;
                fPrecision = this.precision;
                fScale = this.scale;
                dtName = ((LogicalDatatype)this.getType()).getName();
            } else if (this.getType() instanceof DistinctType) {
                DistinctType dt = (DistinctType)this.getType();
                if (dt.getLogicalDataType() != null) {
                    fSize = dt.getSize();
                    fPrecision = dt.getPrecision();
                    fScale = dt.getScale();
                    dtName = dt.getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                dtName = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
            }
            StringBuffer logical = new StringBuffer((String)dtName);
            boolean needBracket = false;
            boolean needComma = false;
            if (fSize != null && !fSize.equals("") || fPrecision > 0 || fScale > 0) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append('(');
            }
            if (fSize != null && !fSize.equals("")) {
                logical.append(fSize);
                needComma = true;
            }
            if (fPrecision > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fPrecision);
                needComma = true;
            }
            if (fScale > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fScale);
            }
            if (needBracket) {
                logical.append(')');
            }
            return logical.toString();
        }
        return "NONE";
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 table) {
        this.table = table;
        if (table != null) {
            this.setPAC_Element(table);
        }
        this.fireDataFieldChange();
    }
}

