/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyDB2
extends IndexProxy
implements ModelObjectSetListener,
OwnedObject,
StorageObjectListener,
Constants,
PropertiesPropagator {
    private static final String[] INDEX_STATES = new String[]{"Unique Constraint", "Primary Constraint", "Unique Plain Index"};
    private static Set indexUniqueSet = null;
    public static final String[] CLUSTER_TYPES = new String[]{"NONE", "CLUSTERED", "CLUSTERED_PARTITIONED"};
    public static final String[] PIECE_SIZES = new String[]{" ", "254 K", "512 K", "1024 K", "2048 K", "4096 K", "8192 K", "16384 K", "32768 K", "65536 K", "131072 K", "262144 K", "524288 K", "1048576 K", "2097152 K", "4194304 K", "8388608 K", "16777216 K", "33554432 K", "67108864 K"};
    protected OwnedObjectImpl ownedObjectImpl = null;
    protected boolean whereNotNull = false;
    protected StorageTemplateDB2 storageTemplate = null;
    protected StorageGroupDB2 storageGroup = null;
    protected String clusterType = CLUSTER_TYPES[0];
    protected String pieceSize = PIECE_SIZES[0];
    protected BufferPoolDB2 bufferPool = null;
    protected boolean close = true;
    protected boolean defer = false;
    protected boolean copy = false;
    private boolean hasAssignedIntgrityIndex = false;
    protected int isobid = 0;
    protected String createdBy = "";
    protected int firstKeyCard = 0;
    protected int fullKeyCard = 0;
    protected int numberLeaf = 0;
    protected int numberLevels = 0;
    protected int catalogSpace = 0;
    protected int clusterRatio = 0;
    protected IndexSpaceDB2 indexSpace;
    protected long initial = 0L;
    protected long frequencyCount = 0L;
    protected float frequencyPercent = 0.0f;
    protected float updateRatePercent = 0.0f;
    protected TableSpaceDB2 tablespace;
    StorageObjectCollection indparts;
    protected final State UNIQUE = new Unique();
    protected final State NONUNIQUE;
    protected State state = this.NONUNIQUE = new NonUnique();
    protected static final int PRIQTY = 1;
    protected static final int SECQTY = 2;
    protected static final int INITIALROWS = 1;
    protected static final int MAXROWS = 2;
    protected int rowsForCalculation = 1;
    protected StringBuffer proposedQTYRemarks = new StringBuffer();
    private int statusGroup;
    private int oldStatusGroup;
    public static final int STATUSGROUP_CONSTRAINT = 1;
    public static final int STATUSGROUP_INDEX = 2;
    public static final String INTEGRITY_INDEX_PREFIX = "I";
    private boolean processedInDDLImport = false;
    private boolean allowIntegrityIndexNR = true;
    private List propertyWrapperList = null;
    private boolean noIntegrity = false;
    private static int maxQTY = 0x400000;

    public IndexProxyDB2(Index index, StorageDesign storageDesign) {
        this(index, storageDesign, true);
    }

    public IndexProxyDB2(Index index, StorageDesign storageDesign, boolean addIndexes) {
        super(index, storageDesign);
        this.oldStatusGroup = this.statusGroup = this.getStatusGroup(index);
        if (addIndexes) {
            this.indparts = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet());
            this.indparts.setParent(this);
            this.indparts.setName(Messages.getString("IndexProxyDB2.Partitions"));
            this.indparts.setSetMethod("setIndex");
            this.indparts.setClassForParent(IndexProxyDB2.class);
            ((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet().addSetListener(this);
            this.indparts.addSetListener(this);
        }
    }

    public IndexProxyDB2(Design design, String id, String longName, StorageDesign storageDesign) {
        this(design, id, longName, storageDesign, true);
    }

    public IndexProxyDB2(Design design, String id, String longName, StorageDesign storageDesign, boolean addIndexes) {
        super(design, id, longName, storageDesign);
        this.oldStatusGroup = this.statusGroup = this.getStatusGroup((Index)this.getObject());
        if (addIndexes) {
            this.indparts = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet());
            this.indparts.setParent(this);
            this.indparts.setName(Messages.getString("IndexProxyDB2.Partitions"));
            this.indparts.setSetMethod("setIndex");
            this.indparts.setClassForParent(IndexProxyDB2.class);
            ((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet().addSetListener(this);
            this.indparts.addSetListener(this);
        }
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.ownedObjectImpl == null) {
            this.ownedObjectImpl = new OwnedObjectImpl();
            this.ownedObjectImpl.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.ownedObjectImpl;
    }

    public boolean isWhereNotNull() {
        return this.whereNotNull;
    }

    public void setWhereNotNull(boolean whereNotNull) {
        this.whereNotNull = whereNotNull;
        this.fireDataFieldChange();
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplate) {
        this.storageTemplate = storageTemplate;
        this.fireDataFieldChange();
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        if (clusterType != null && clusterType.equals(this.clusterType)) {
            return;
        }
        try {
            this.clusterType = clusterType;
            if (!this.isPartitioned()) {
                this.removePartitions();
                this.indparts.setForbiddenCreateElement(true);
            } else {
                this.indparts.setForbiddenCreateElement(false);
            }
            TableSpaceDB2 tableSpace = ((TableProxyDB2)this.getTableProxy()).getTableSpace();
            if (tableSpace != null) {
                if (this.isPartitioned() && tableSpace.getPartIndex() != this) {
                    tableSpace.setPartIndex(this);
                } else if (!this.isPartitioned() && tableSpace.getPartIndex() == this) {
                    tableSpace.setPartIndex(null);
                }
            }
            this.fireDataFieldChange();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPieceSize() {
        return this.pieceSize;
    }

    public int getPieceSizeKB() {
        String ps = this.getPieceSize();
        if (ps.length() > 2) {
            try {
                String psc = ps.substring(0, ps.length() - 1).trim();
                return Integer.parseInt(psc);
            }
            catch (NumberFormatException e) {
                return 0x200000;
            }
        }
        return 0;
    }

    public void setPieceSize(String pieceSize) {
        this.pieceSize = pieceSize;
        this.fireDataFieldChange();
    }

    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(BufferPoolDB2 bufferPool) {
        this.bufferPool = bufferPool;
        this.fireDataFieldChange();
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
        this.fireDataFieldChange();
    }

    public boolean isDefer() {
        return this.defer;
    }

    public void setDefer(boolean defer) {
        this.defer = defer;
        this.fireDataFieldChange();
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
        this.fireDataFieldChange();
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof IndexPartitionDB2) {
            IndexPartitionDB2 ip = (IndexPartitionDB2)event.getAffected();
            if (ip.getIndex() != null && ip.getIndex() == this && !this.indparts.contains(ip)) {
                ip.setParent(this.indparts);
                this.indparts.add(ip);
                ip.setPAC_Element(this);
                if (!this.getStorageDesign().isLoading()) {
                    ip.removeObjectListener(this);
                    ip.setPartNumber(this.indparts.size());
                    ip.addObjectListener(this);
                }
                this.synchronizeTablespacePartNum();
            } else if ((ip.getIndex() == null || ip.getIndex() != null && ip.getIndex() != this) && this.indparts.contains(ip)) {
                this.indparts.remove(ip);
                this.synchronizeTablespacePartNum();
            }
        }
    }

    private void synchronizeTablespacePartNum() {
        TableProxyDB2 tp;
        if (this.getTableProxy() != null && (tp = (TableProxyDB2)this.getTableProxy()).getTableSpace() != null) {
            tp.getTableSpace().setMaxPartitionCount(this.getNumParts());
        }
    }

    protected boolean checkUniqueness(String value) {
        if (indexUniqueSet == null) {
            indexUniqueSet = new HashSet();
            indexUniqueSet.addAll(Arrays.asList(INDEX_STATES));
        }
        return indexUniqueSet.contains(value);
    }

    @Override
    public boolean isUnique() {
        return this.checkUniqueness(this.getIndex().getIndexState());
    }

    public boolean isUniquePlainIndex() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index");
    }

    public int getNumParts() {
        if (this.indparts != null) {
            return this.indparts.size();
        }
        return 0;
    }

    public IndexPartitionDB2[] getPartitions() {
        IndexPartitionSetDB2 partitionsSet = ((AbstractStorageDesignDB2)this.getStorageDesign()).getIndexPartitionSet();
        return partitionsSet.getPartitionsFor(this);
    }

    public static String[] getClusterTypeValues() {
        return CLUSTER_TYPES;
    }

    public static String[] getPieceSizesValues() {
        return PIECE_SIZES;
    }

    public void setIsobid(int value) {
        this.isobid = value;
        this.fireDataFieldChange();
    }

    public int getIsobid() {
        return this.isobid;
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        this.fireDataFieldChange();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setFirstKeyCard(int value) {
        this.firstKeyCard = value;
        this.fireDataFieldChange();
    }

    public int getFirstKeyCard() {
        return this.firstKeyCard;
    }

    public void setFullKeyCard(int value) {
        this.fullKeyCard = value;
        this.fireDataFieldChange();
    }

    public int getFullKeyCard() {
        return this.fullKeyCard;
    }

    public void setNumberLeaf(int value) {
        this.numberLeaf = value;
        this.fireDataFieldChange();
    }

    public int getNumberLeaf() {
        return this.numberLeaf;
    }

    public void setNumberLevels(int value) {
        this.numberLevels = value;
        this.fireDataFieldChange();
    }

    public int getNumberLevels() {
        return this.numberLevels;
    }

    public void setCatalogSpace(int value) {
        this.catalogSpace = value;
        this.fireDataFieldChange();
    }

    public int getCatalogSpace() {
        return this.catalogSpace;
    }

    public void setClusterRatio(int value) {
        this.clusterRatio = value;
        this.fireDataFieldChange();
    }

    public int getClusterRatio() {
        return this.clusterRatio;
    }

    public void setMaintenanceInterval(int value) {
        this.getIndexSpace().setMaintenanceInterval(value);
        this.fireDataFieldChange();
    }

    public int getMaintenanceInterval() {
        return this.getIndexSpace().getMaintenanceInterval();
    }

    public void setSpaceAllocationInterval(int value) {
        this.getIndexSpace().setSpaceAllocationInterval(value);
    }

    public int getSpaceAllocationInterval() {
        return this.getIndexSpace().getSpaceAllocationInterval();
    }

    public boolean checkInitial(long value) {
        return value <= 0xFFFFFFFEL && value >= 0L;
    }

    public void setInitial(long value) {
        if (this.checkInitial(value)) {
            this.initial = value;
            this.fireDataFieldChange();
        }
    }

    public long getInitial() {
        return this.initial;
    }

    public boolean checkFrequencyCount(long value) {
        return value <= 0xFFFFFFFEL && value >= 0L && value <= this.getInitial();
    }

    public void setFrequencyCount(long value) {
        if (this.checkFrequencyCount(value)) {
            this.frequencyCount = value;
            this.fireDataFieldChange();
        }
    }

    public long getFrequencyCount() {
        return this.frequencyCount;
    }

    public boolean checkFrequencyPercent(float value) {
        return value <= 100.0f && value >= 0.0f;
    }

    public void setFrequencyPercent(float value) {
        if (this.checkFrequencyPercent(value)) {
            this.frequencyPercent = value;
            this.fireDataFieldChange();
        }
    }

    public float getFrequencyPercent() {
        return this.frequencyPercent;
    }

    public boolean checkUpdateRatePercent(float value) {
        return value < 10000.0f && value >= 0.0f;
    }

    public void setUpdateRatePercent(float value) {
        if (this.checkUpdateRatePercent(value)) {
            this.updateRatePercent = value;
            this.fireDataFieldChange();
        }
    }

    public float getUpdateRatePercent() {
        return this.updateRatePercent;
    }

    public IndexSpaceDB2 getIndexSpace() {
        if (this.indexSpace == null) {
            this.indexSpace = new IndexSpaceDB2();
            this.indexSpace.setDesign(this.getDesign());
            this.indexSpace.setStorageDesign(this.getStorageDesign());
            this.indexSpace.setObjectID(this.getObjectID() + "SPACE");
            this.indexSpace.addObjectListener(this);
        }
        return this.indexSpace;
    }

    public int getNumberOfDuplicates() {
        TableProxyDB2 tableProxy = (TableProxyDB2)this.getTableProxy();
        if (this.getInitial() != 0L) {
            return (int)(tableProxy.getInitialRowNumber() / this.getInitial());
        }
        return 1;
    }

    public void setCalculatePrimaryQuantity(boolean calculate) {
        this.getIndexSpace().setCalculatePrimaryQuantity(calculate);
    }

    public boolean getCalculatePrimaryQuantity() {
        return this.getIndexSpace().getCalculatePrimaryQuantity();
    }

    public void setCalculateSecondaryQuantity(boolean calculate) {
        this.getIndexSpace().setCalculateSecondaryQuantity(calculate);
    }

    public boolean getCalculateSecondaryQuantity() {
        return this.getIndexSpace().getCalculateSecondaryQuantity();
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.indparts;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.indparts) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.indparts) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected String applyNameRules(String name) {
        return name;
    }

    @Override
    public void changed(DesignObject obj, ObjectChangeEvent event) {
        super.changed(obj, event);
        Index ind = (Index)obj;
        this.setStatusGroup(this.getStatusGroup(ind));
        if (this.getOldStatusGroup() != this.getStatusGroup()) {
            this.fireDataFieldChange();
        }
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.synchronizeStorageTemplateName();
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        block8: {
            block9: {
                block7: {
                    IndexPartitionDB2 ip;
                    if (set != this.indparts) break block7;
                    if (event.isType(1) && event.getAffected() instanceof IndexPartitionDB2 && (ip = (IndexPartitionDB2)event.getAffected()).getIndex() == null) {
                        ip.setParent(null);
                        this.indparts.remove(ip);
                        if (!this.getStorageDesign().isLoading()) {
                            ip.removeObjectListener(this);
                            ip.setPartNumber(this.indparts.size());
                            ip.addObjectListener(this);
                        }
                        ip.setIndex(this);
                    }
                    break block8;
                }
                if (!event.isType(1)) break block9;
                if (!(event.getAffected() instanceof IndexPartitionDB2)) break block8;
                IndexPartitionDB2 ip = (IndexPartitionDB2)event.getAffected();
                ip.addObjectListener(this);
                if (ip.getIndex() == null || ip.getIndex() != this) break block8;
                ip.setParent(this.indparts);
                if (!this.getStorageDesign().isLoading()) {
                    ip.removeObjectListener(this);
                    ip.setPartNumber(this.indparts.size());
                    ip.addObjectListener(this);
                }
                this.indparts.add(ip);
                ip.setPAC_Element(this);
                break block8;
            }
            if (event.isType(0) && event.getAffected() instanceof IndexPartitionDB2) {
                IndexPartitionDB2 ip = (IndexPartitionDB2)event.getAffected();
                ip.removeObjectListener(this);
                if (this.indparts.contains(ip)) {
                    this.indparts.remove(ip);
                    if (!this.getStorageDesign().isLoading()) {
                        for (int i = 0; i < this.indparts.size(); ++i) {
                            ((IndexPartitionDB2)this.indparts.getElement(i)).removeObjectListener(this);
                            ((IndexPartitionDB2)this.indparts.getElement(i)).setPartNumber(i + 1);
                            ((IndexPartitionDB2)this.indparts.getElement(i)).removeObjectListener(this);
                        }
                    }
                }
            }
        }
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogDB2 dialog = new IndexPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public boolean isPartitioned() {
        return this.clusterType.equalsIgnoreCase(CLUSTER_TYPES[2]);
    }

    protected void checkState() {
        this.state = this.isUnique() ? this.UNIQUE : this.NONUNIQUE;
    }

    private int getSpacePerKeyL() {
        this.checkState();
        return this.state.getSpacePerKeyL();
    }

    private int getSpacePerKeyNL() {
        this.checkState();
        return this.state.getSpacePerKeyNL();
    }

    private int getIndexByteSize() {
        return this.getByteSize() + this.getIndex().getNumberOfNullsAllowingElements();
    }

    private int getByteSize() {
        int bytes = 0;
        Index index = this.getIndex();
        Column[] columns = (Column[])index.getElements();
        for (int i = 0; i < columns.length; ++i) {
            bytes += columns[i].getDataType(this.getRDBMSType().toString()).getByteSize();
        }
        return bytes;
    }

    boolean isLargeTSforTable() {
        if (((TableProxyDB2)this.getTableProxy()).getTableSpace().getType().equalsIgnoreCase("LOB")) {
            return true;
        }
        String dssize = ((TableProxyDB2)this.getTableProxy()).getTableSpace().getDsSize();
        dssize = dssize.replace('M', ' ');
        try {
            int size = Integer.parseInt(dssize);
            if (size >= 4) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int getRIDSize() {
        if (this.getTablespace() != null && this.isLargeTSforTable()) {
            return 5;
        }
        return 4;
    }

    private int getMaxUsableSpacePerPageL() {
        return (int)Math.floor((float)((100 - this.getPercentageFree()) * 4038) / 100.0f);
    }

    private int getMaxUsableSpacePerPageNL() {
        float max = Math.max(90, 100 - this.getPercentageFree());
        return (int)Math.floor(max * 4046.0f / 100.0f);
    }

    private int getEntriesPerPageL() {
        this.checkState();
        return this.state.getEntriesPerPageL();
    }

    private int getEntriesPerPageNL() {
        return (int)Math.floor(this.getMaxUsableSpacePerPageNL() / this.getSpacePerKeyNL());
    }

    private int getPercentageFree() {
        if (this.getStorageTemplate() != null && ((TableProxyDB2)this.getTableProxy()).getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
            return this.getStorageTemplate().getPctFree();
        }
        return 0;
    }

    private int getFreePage() {
        if (this.getStorageTemplate() != null && ((TableProxyDB2)this.getTableProxy()).getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
            return this.getStorageTemplate().getFreePage();
        }
        return 0;
    }

    private int getAverageNumberDuplicatesPerKey() {
        return this.getNumberOfDuplicates();
    }

    private int getKeyEntriesPerPageL() {
        return (int)Math.floor((float)(this.getAverageNumberDuplicatesPerKey() * this.getMaxUsableSpacePerPageL()) / (float)this.getSpacePerKeyL());
    }

    private int getRemainingSpacePerPageL() {
        return (int)Math.floor((float)this.getMaxUsableSpacePerPageL() - (float)(this.getKeyEntriesPerPageL() * this.getSpacePerKeyL()) / (float)this.getAverageNumberDuplicatesPerKey());
    }

    private int getDataRecordsPerPartialEntryL() {
        return (int)Math.floor((float)(this.getRemainingSpacePerPageL() - (this.getIndexByteSize() + 4)) / 5.0f);
    }

    private int getPartialEntriesPerPageL() {
        if (this.getDataRecordsPerPartialEntryL() < 1) {
            return 0;
        }
        float a = (float)this.getAverageNumberDuplicatesPerKey() / (float)this.getDataRecordsPerPartialEntryL();
        return this.getAverageNumberDuplicatesPerKey() / (int)Math.ceil(a);
    }

    private long getRowNumberOfTableProxy() {
        TableProxyDB2 tableProxy = (TableProxyDB2)this.getTableProxy();
        return this.rowsForCalculation == 1 ? tableProxy.getInitialRowNumber() : tableProxy.getMaxRowNumber();
    }

    private long getNumberLeafPages() {
        return (long)Math.ceil((float)this.getRowNumberOfTableProxy() / (float)this.getEntriesPerPageL());
    }

    private int getMinNumberChildPages() {
        return Math.max(2, this.getEntriesPerPageNL() + 1);
    }

    private long getLevel2Pages() {
        return (long)Math.ceil((float)this.getNumberLeafPages() / (float)this.getMinNumberChildPages());
    }

    private long getLevelXPages(float previousLevelPages) {
        return (long)Math.ceil(previousLevelPages / (float)this.getMinNumberChildPages());
    }

    private long getNumberNonleafPages() {
        long result = this.getLevel2Pages();
        long previousLevelPages = this.getLevel2Pages();
        while (previousLevelPages > 1L) {
            previousLevelPages = this.getLevelXPages(previousLevelPages);
            result += previousLevelPages;
        }
        return result;
    }

    private long getFreePages() {
        if (this.getFreePage() != 0) {
            return (long)Math.floor((float)this.getNumberLeafPages() / (float)this.getFreePage());
        }
        return 0L;
    }

    private long getTreePages() {
        return Math.max(2L, this.getNumberLeafPages() + this.getNumberNonleafPages());
    }

    private long getSpaceMapPages() {
        return (long)Math.ceil((float)(this.getFreePages() + this.getTreePages()) / 8131.0f);
    }

    private int getNumberIndexPages() {
        return (int)Math.max(4L, 1L + this.getSpaceMapPages() + this.getTreePages() + this.getFreePages());
    }

    private int getRequiredSpacePages() {
        return this.getNumberIndexPages() + 2;
    }

    public int getInitialNumberUsedPages() {
        this.rowsForCalculation = 1;
        return this.getRequiredSpacePages();
    }

    public int getMaxNumberUsedPages() {
        this.rowsForCalculation = 2;
        return this.getRequiredSpacePages();
    }

    public long getInitialNumberUsedKB() {
        return 4 * this.getInitialNumberUsedPages();
    }

    public long getMaxNumberUsedKB() {
        return 4 * this.getMaxNumberUsedPages();
    }

    private int getNumberOfPieces() {
        if (((TableProxyDB2)this.getTableProxy()).getTableSpace() != null) {
            String dsSize = ((TableProxyDB2)this.getTableProxy()).getTableSpace().getDsSize();
            int dss = 0;
            if (dsSize.length() > 2) {
                try {
                    dss = Integer.parseInt(dsSize.substring(0, dsSize.length() - 2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dss >= 4 || ((TableProxyDB2)this.getTableProxy()).getTableSpace().getType().equalsIgnoreCase("LOB")) {
                return 254;
            }
        }
        return 32;
    }

    public int transformPSizeToLong(String ps) {
        String psc = ps.substring(0, ps.length() - 2);
        return Integer.parseInt(psc);
    }

    int chooseProperPieceSize(int ps) {
        for (int i = 1; i < PIECE_SIZES.length; ++i) {
            int psInt = this.transformPSizeToLong(PIECE_SIZES[i]);
            if (ps >= psInt) continue;
            return this.transformPSizeToLong(PIECE_SIZES[i]);
        }
        return this.transformPSizeToLong(PIECE_SIZES[PIECE_SIZES.length]);
    }

    public int getProposedPRIQTY() {
        return this.getProposedQTY(1);
    }

    public int getProposedQTY(int qtyType) {
        this.proposedQTYRemarks.setLength(0);
        int psizeInK = 4;
        int pieceSizePages = (int)Math.ceil((float)this.getPieceSizeKB() / 4.0f);
        int minPages = 0;
        int maxPages = 0;
        int priQTY = 0;
        int secQTY = 0;
        maxPages = this.getMaxNumberUsedPages();
        minPages = this.getInitialNumberUsedPages();
        minPages = Math.max(3, minPages);
        maxPages = Math.max(3, maxPages);
        if (this.getNumParts() == 0) {
            int numPieces = this.getNumberOfPieces();
            int maxSize = numPieces * pieceSizePages;
            if (maxSize < maxPages) {
                this.proposedQTYRemarks.append(Messages.getString("IndexProxyDB2.CurrentPIECESIZENotSufficient"));
                int ps = maxPages / numPieces;
                ps = this.chooseProperPieceSize(ps * 4);
                this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("IndexProxyDB2.PIECESIZEProposed"), Integer.toString(ps)));
                pieceSizePages = ps / 4;
            }
            if ((priQTY = minPages) >= pieceSizePages) {
                priQTY = pieceSizePages;
                secQTY = priQTY / 10;
            } else {
                long pages;
                secQTY = Math.max(3, priQTY / 10);
                if ((long)(priQTY + 118 * secQTY) < (pages = (long)Math.min(pieceSizePages, maxPages))) {
                    secQTY = priQTY = (int)Math.ceil((float)pages / 119.0f);
                    this.proposedQTYRemarks.append(Messages.getString("IndexProxyDB2.SizeAdjusted"));
                }
            }
        } else {
            priQTY = minPages;
            secQTY = Math.max(3, priQTY / 10);
            if (priQTY + 118 * secQTY < maxPages) {
                secQTY = priQTY = (int)Math.ceil((float)maxPages / 119.0f);
                this.proposedQTYRemarks.append(Messages.getString("IndexProxyDB2.SizeAdjusted"));
            }
        }
        priQTY *= psizeInK;
        secQTY *= psizeInK;
        if (minPages == maxPages) {
            secQTY = 0;
        }
        priQTY = Math.min(priQTY, maxQTY);
        secQTY = Math.min(secQTY, maxQTY);
        return qtyType == 1 ? priQTY : secQTY;
    }

    public int getProposedSECQTY() {
        return this.getProposedQTY(2);
    }

    public String getProposedQTYRemarks() {
        return this.proposedQTYRemarks.toString();
    }

    public int getStatusGroup(Index ind) {
        if (ind.isPK() || ind.isUnique()) {
            return 1;
        }
        return 2;
    }

    private void setStatusGroup(int group) {
        this.oldStatusGroup = this.statusGroup;
        this.statusGroup = group;
    }

    public int getStatusGroup() {
        return this.statusGroup;
    }

    public int getOldStatusGroup() {
        return this.oldStatusGroup;
    }

    private void removePartitions() {
        int size;
        if (this.indparts != null && (size = this.indparts.size()) > 0) {
            IndexPartitionDB2[] indar = new IndexPartitionDB2[size];
            Iterator it = this.indparts.iterator();
            int i = 0;
            while (it.hasNext()) {
                indar[i] = (IndexPartitionDB2)it.next();
                ++i;
            }
            for (i = 0; i < size; ++i) {
                indar[i].remove();
            }
        }
    }

    public TableSpaceDB2 getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceDB2 tablespace) {
        if (tablespace != null) {
            this.tablespace = tablespace;
            this.fireDataFieldChange();
        }
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(StorageGroupDB2 storageGroup) {
        this.storageGroup = storageGroup;
        this.fireDataFieldChange();
    }

    public boolean isProcessedInDDLImport() {
        return this.processedInDDLImport;
    }

    public void setProcessedInDDLImport(boolean processedInDDLImport) {
        this.processedInDDLImport = processedInDDLImport;
    }

    public boolean isAllowIntegrityIndexNR() {
        return this.allowIntegrityIndexNR;
    }

    public void setAllowIntegrityIndexNR(boolean allowIntegrityIndexNR) {
        this.allowIntegrityIndexNR = allowIntegrityIndexNR;
    }

    public StorageObjectCollection getIndexPartitions() {
        return this.indparts;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("Where Not Null", this, "isWhereNotNull", "setWhereNotNull", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Storage Template", this, "getStorageTemplate", "setStorageTemplate", StorageTemplateDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster Type", this, "getClusterType", "setClusterType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Piece Size", this, "getPieceSize", "setPieceSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("BufferPool", this, "getBufferPool", "setBufferPool", BufferPoolDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Close", this, "isClose", "setClose", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Defer", this, "isDefer", "setDefer", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Copy", this, "isCopy", "setCopy", Boolean.TYPE));
        }
        return this.propertyWrapperList;
    }

    public boolean isHasAssignedIntgrityIndex() {
        return this.hasAssignedIntgrityIndex;
    }

    public void setHasAssignedIntgrityIndex(boolean hasAssignedIntgrityIndex) {
        this.hasAssignedIntgrityIndex = hasAssignedIntgrityIndex;
    }

    public void synchronizeStorageTemplateName() {
        StorageTemplateDB2 template;
        if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex() && (template = this.getStorageTemplate()) != null && !template.isUsedInOtherDefinitions(this)) {
            String namingRule = this.getDesign().getAppView().getSettings().getNamingRuleStIndexDB2();
            String tname = ApplyNamingStandards.createIndexStorageTemplateDB2_Name(this.getName(), namingRule, this.getStorageDesign().getPhysicalDesign().getName());
            template.setName(tname);
        }
    }

    public boolean isNoIntegrity() {
        return this.noIntegrity;
    }

    public void setNoIntegrity(boolean noIntegrity) {
        this.noIntegrity = noIntegrity;
    }

    @Override
    public void clearNoneMergableStructure() {
        if (this.indparts != null) {
            this.indparts.removeAll();
        }
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !this.getOwner().isNullInstance()) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String name = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            name = index.getFKAssociation().getName();
        }
        name = this.applyNameSubstitution(name);
        return name;
    }

    public IndexPartitionDB2 createIndexPartition() {
        IndexPartitionDB2 indp = (IndexPartitionDB2)this.indparts.createElement(null);
        indp.setIndex(this);
        indp.setPAC_Element(this);
        return indp;
    }

    @Override
    public String getStorageName() {
        return "";
    }

    class NonUnique
    extends State {
        NonUnique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return IndexProxyDB2.this.getIndexByteSize() + 4 + IndexProxyDB2.this.getAverageNumberDuplicatesPerKey() * (IndexProxyDB2.this.getRIDSize() + 1);
        }

        @Override
        public int getSpacePerKeyNL() {
            return IndexProxyDB2.this.getIndexByteSize() + IndexProxyDB2.this.getRIDSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return Math.max(1, IndexProxyDB2.this.getKeyEntriesPerPageL() + IndexProxyDB2.this.getPartialEntriesPerPageL());
        }
    }

    class Unique
    extends State {
        Unique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return IndexProxyDB2.this.getIndexByteSize() + IndexProxyDB2.this.getRIDSize() + 3;
        }

        @Override
        public int getSpacePerKeyNL() {
            return IndexProxyDB2.this.getIndexByteSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return (int)Math.floor(IndexProxyDB2.this.getMaxUsableSpacePerPageL() / this.getSpacePerKeyL());
        }
    }

    abstract class State {
        State() {
        }

        public abstract int getSpacePerKeyL();

        public abstract int getSpacePerKeyNL();

        public abstract int getEntriesPerPageL();
    }
}

