/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.db2.AbstractSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;

public abstract class DataBaseSpaceDB2
extends AbstractStorageObjectDB2
implements AbstractSpaceDB2,
StorageObjectListener {
    protected int pageFree = 0;
    protected int spaceAllocationInterval = 0;
    protected VCatDB2 vcat = null;
    protected boolean define = true;
    protected int maintenanceInterval = 0;
    private int percentageFree = 5;
    protected boolean dataSetInfoErase = false;
    protected int catalogSpace = 0;
    private int primaryQuantity = 12;
    private int secondaryQuantity = 0;
    private boolean calculatePrimaryQuantity = true;
    private boolean calculateSecondaryQuantity = true;
    private DataBaseDB2 dataBase = null;
    private BufferPoolDB2 bufferPool = null;
    private StorageGroupDB2 storageGroup = null;

    @Override
    public void setDataBase(DataBaseDB2 newDataBase) {
        this.dataBase = newDataBase;
        this.fireDataFieldChange();
    }

    @Override
    public void setBufferPool(BufferPoolDB2 bufferPool) {
        this.bufferPool = bufferPool;
        this.fireDataFieldChange();
    }

    @Override
    public void setFreePage(int value) {
        if (this.checkFreePage(value)) {
            this.pageFree = value;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setSpaceAllocationInterval(int value) {
        if (this.checkSpaceAllocationInterval(value)) {
            this.spaceAllocationInterval = value;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setStorageGroup(StorageGroupDB2 storageGroup) {
        this.storageGroup = storageGroup;
        this.fireDataFieldChange();
    }

    @Override
    public void setVCat(VCatDB2 vcat) {
        this.vcat = vcat;
        this.fireDataFieldChange();
    }

    @Override
    public void setVCatName(String name) {
    }

    @Override
    public void setDefine(boolean value) {
        this.define = value;
        this.fireDataFieldChange();
    }

    @Override
    public boolean getDefine() {
        return this.define;
    }

    @Override
    public void setMaintenanceInterval(int value) {
        if (this.checkSpaceAllocationInterval(value)) {
            this.maintenanceInterval = value;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setDataSetInfoErase(boolean value) {
        this.dataSetInfoErase = value;
        this.fireDataFieldChange();
    }

    @Override
    public void setPercentageFree(int value) {
        if (this.checkPercentageFree(value)) {
            this.percentageFree = value;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setSpace(int value) {
        this.catalogSpace = value;
        this.fireDataFieldChange();
    }

    @Override
    public DataBaseDB2 getDataBase() {
        return this.dataBase;
    }

    @Override
    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public int getFreePage() {
        return this.pageFree;
    }

    @Override
    public int getSpaceAllocationInterval() {
        return this.spaceAllocationInterval;
    }

    @Override
    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    @Override
    public VCatDB2 getVCat() {
        return this.vcat;
    }

    @Override
    public String getVCatName() {
        VCatDB2 vcat = this.getVCat();
        if (vcat != null) {
            return this.getVCat().getName();
        }
        return "";
    }

    @Override
    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    @Override
    public boolean getDataSetInfoErase() {
        return this.dataSetInfoErase;
    }

    @Override
    public int getPercentageFree() {
        return this.percentageFree;
    }

    @Override
    public int getSpace() {
        return this.catalogSpace;
    }

    public boolean checkFreePage(int value) {
        return value >= 0 && value <= 255;
    }

    public boolean checkSpaceAllocationInterval(int value) {
        return value >= 0 && value <= 999;
    }

    public boolean containsStorageGroup() {
        return this.getStorageGroup() != null;
    }

    public boolean checkPercentageFree(int value) {
        return value >= 0 && value <= 99;
    }

    public int getPrimaryQuantity() {
        return this.primaryQuantity;
    }

    public void setPrimaryQuantity(int value) {
        this.primaryQuantity = value;
        this.fireDataFieldChange();
    }

    public int getSecondaryQuantity() {
        return this.secondaryQuantity;
    }

    public void setSecondaryQuantity(int value) {
        this.secondaryQuantity = value;
        this.fireDataFieldChange();
    }

    public boolean getCalculatePrimaryQuantity() {
        return this.calculatePrimaryQuantity;
    }

    public void setCalculatePrimaryQuantity(boolean calculate) {
        this.calculatePrimaryQuantity = calculate;
        this.fireDataFieldChange();
    }

    public boolean getCalculateSecondaryQuantity() {
        return this.calculateSecondaryQuantity;
    }

    public void setCalculateSecondaryQuantity(boolean calculate) {
        this.calculateSecondaryQuantity = calculate;
        this.fireDataFieldChange();
    }

    @Override
    public PropertyHolder getPropertyHolder() {
        return null;
    }
}

