/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.propertyholder.PVInteger;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifier;
import oracle.dbtools.crest.swingui.editor.storage.db2.BufferPoolPropertyDialogDB2;

public class BufferPoolDB2
extends StorageObject {
    private static PropertyVerifier verifier = new PVInteger(0, 400000);
    private int minBuffers;
    private int maxBuffers;
    private String users = "";
    private UserSet userSet = null;
    private String grantOption = "NO";
    private String allBufferpools = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "BufPool";
    public static final String OLD_TYPE_NAME = "Bufferpool";

    public void setMinBuffers(int value) {
        if (this.isNotTooSmall(value) && this.isNotTooLarge(value)) {
            this.minBuffers = value;
            this.sortMinMax();
            this.fireUpdate();
        }
    }

    public void setMaxBuffers(int value) {
        if (this.isNotTooSmall(value) && this.isNotTooLarge(value)) {
            this.maxBuffers = value;
            this.sortMinMax();
            this.fireUpdate();
        }
    }

    protected void sortMinMax() {
    }

    public int getMinBuffers() {
        return this.minBuffers;
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public int pageSize() {
        return 4096;
    }

    public int usablePageSize() {
        return 4074;
    }

    protected boolean isNotTooLarge(int i) {
        return i <= this.maxValue();
    }

    protected int maxValue() {
        return 400000;
    }

    protected boolean isNotTooSmall(int i) {
        return i >= this.minValue();
    }

    protected int minValue() {
        return 0;
    }

    void createName() {
        String name = this.getNamePrefix();
        this.setName(name);
        this.setObjectID(name);
    }

    void createName(int number) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getNamePrefix()).append(number);
        String name = buf.toString();
        this.setName(name);
        this.setObjectID(name);
    }

    protected String getNamePrefix() {
        return "BP";
    }

    public static PropertyVerifier getBufferPropertyVerifier() {
        return verifier;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "IDPREFIXNOTUSED_BUFFERPOOL";
    }

    @Override
    public final void setReadOnly(boolean value) {
        super.setReadOnly(value);
    }

    private void addUser(String user) {
        String userName = user.substring(user.lastIndexOf(46) + 1, user.length());
        if (!this.getUserSet().contains(userName)) {
            this.getUserSet().add(userName);
        }
    }

    private void recreateUserSet(String users) {
        this.getUserSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.getUserSet().add(st.nextToken().trim());
        }
    }

    public void setUsers(String users) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(users);
        } else {
            this.addUser(users);
        }
        this.users = this.getUserSet().toString();
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    public String getAllBufferpools() {
        return this.allBufferpools;
    }

    public void setAllBufferpools(String allBufferpools) {
        if (allBufferpools != null && allBufferpools.equals(this.allBufferpools)) {
            return;
        }
        if (this.checkYesNo(allBufferpools)) {
            this.allBufferpools = allBufferpools;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            BufferPoolPropertyDialogDB2 dialog = new BufferPoolPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        BufferPoolDB2 bufferPool = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                bufferPool = (BufferPoolDB2)stObject;
            }
        } else {
            bufferPool = (BufferPoolDB2)((AbstractStorageDesignDB2)targetDesign).getBufferPoolSet().createElement(null);
        }
        if (bufferPool != null) {
            bufferPool.setMinBuffers(this.getMinBuffers());
            bufferPool.setMaxBuffers(this.getMaxBuffers());
            bufferPool.recreateUserSet(this.getUsers());
            bufferPool.setAllBufferpools(this.getAllBufferpools());
            bufferPool.setGrantOption(this.getGrantOption());
            bufferPool.setComment(this.getComment());
            bufferPool.setRawObject(false);
        }
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

