/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.AUXTablePropertyDialogDB2;

public class AUXTableDB2
extends AbstractStorageObjectDB2
implements ModelObjectSetListener,
StorageObjectListener {
    private Owner owner = null;
    private TableSpaceDB2 tableSpace = null;
    private TableProxyDB2 table = null;
    private ColumnProxyDB2 column = null;
    private int partNumber = 0;
    StorageObjectCollection aindexes;
    public static final String TYPE_NAME = "AXTable";
    public static final String OLD_TYPE_NAME = "AUXTable";

    public AUXTableDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.aindexes = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet());
        this.aindexes.setParent(this);
        this.aindexes.setName(Messages.getString("AUXTableDB2.Indexes"));
        this.aindexes.setClassForParent(AUXTableDB2.class);
        this.aindexes.setSetMethod("setAuxTable");
        this.aindexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet().addSetListener(this);
        this.addAUXIndexesFromDesign(((AbstractStorageDesignDB2)storageDesign).getAUXTableIndexSet());
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "AUXTBL";
    }

    public ColumnProxyDB2 getColumn() {
        return this.column;
    }

    public void setColumn(ColumnProxyDB2 column) {
        this.column = column;
        this.fireDataFieldChange();
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
        this.fireDataFieldChange();
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 table) {
        this.table = table;
        this.fireDataFieldChange();
    }

    public TableSpaceDB2 getTableSpace() {
        return this.tableSpace;
    }

    public DataBaseDB2 getDatabase() {
        if (this.tableSpace != null) {
            return this.tableSpace.getDataBase();
        }
        return null;
    }

    public void setTableSpace(TableSpaceDB2 tableSpace) {
        if (tableSpace != null) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AUXTablePropertyDialogDB2 dialog = new AUXTablePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.aindexes;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.aindexes) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.aindexes) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null) {
            return new StringBuffer(this.getOwner().getName()).append('.').append(this.getName()).toString();
        }
        return super.getName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getOwner() != null && !this.getOwner().isNullInstance()) {
            name = this.getOwner().getName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    private void addAUXIndexesFromDesign(StorageObjectSet set) {
        for (AUXTableIndexDB2 index : set) {
            if (index.getAuxTable() != null && index.getAuxTable() == this) {
                index.setParent(this.aindexes);
                this.aindexes.add(index);
                continue;
            }
            this.aindexes.remove(index);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof AUXTableIndexDB2) {
            AUXTableIndexDB2 ind = (AUXTableIndexDB2)event.getAffected();
            if (ind.getAuxTable() != null && ind.getAuxTable() == this) {
                ind.setParent(this.aindexes);
                this.aindexes.add(ind);
                ind.setPAC_Element(this);
            } else {
                this.aindexes.remove(ind);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof AUXTableIndexDB2) {
                AUXTableIndexDB2 ind = (AUXTableIndexDB2)event.getAffected();
                ind.addObjectListener(this);
                if (ind.getAuxTable() != null && ind.getAuxTable() == this) {
                    ind.setParent(this.aindexes);
                    this.aindexes.add(ind);
                    ind.setPAC_Element(this);
                } else {
                    this.aindexes.remove(ind);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof AUXTableIndexDB2) {
            AUXTableIndexDB2 ind = (AUXTableIndexDB2)event.getAffected();
            this.aindexes.remove(ind);
            ind.removeObjectListener(this);
        }
    }

    public List getAuxIndexes() {
        ArrayList list = new ArrayList();
        this.aindexes.addAllElementsTo(list);
        return list;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        AUXTableDB2 auxTable = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getAUXTableSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                auxTable = (AUXTableDB2)stObject;
            }
        } else {
            auxTable = ((AbstractStorageDesignDB2)targetDesign).getAUXTableSet().createAUXTable();
        }
        if (auxTable != null) {
            auxTable.setName(this.getName());
            for (AUXTableIndexDB2 idx : this.aindexes) {
                AUXTableIndexDB2 targetIndex = (AUXTableIndexDB2)((AbstractStorageDesignDB2)targetDesign).getAUXTableIndexSet().getByName(idx.getName());
                if (targetIndex == null) {
                    AUXTableIndexDB2 newIndex = ((AbstractStorageDesignDB2)targetDesign).getAUXTableIndexSet().createAUXTableIndex();
                    newIndex.setName(idx.getName());
                    newIndex.setAuxTable(auxTable);
                    newIndex.setRawObject(true);
                    auxTable.addAUXIndexesFromDesign(((AbstractStorageDesignDB2)targetDesign).getAUXTableIndexSet());
                    continue;
                }
                targetIndex.setAuxTable(auxTable);
                auxTable.addAUXIndexesFromDesign(((AbstractStorageDesignDB2)targetDesign).getAUXTableIndexSet());
            }
            if (this.getOwner() != null) {
                Owner targetOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (targetOwner == null) {
                    Owner newOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    auxTable.setOwner(newOwner);
                } else {
                    auxTable.setOwner(targetOwner);
                }
            }
            if (this.getTableSpace() != null) {
                TableSpaceDB2 targetTableSpace = (TableSpaceDB2)((AbstractStorageDesignDB2)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (targetTableSpace == null) {
                    TableSpaceDB2 newTableSpace = ((AbstractStorageDesignDB2)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    auxTable.setTableSpace(newTableSpace);
                } else {
                    auxTable.setTableSpace(targetTableSpace);
                }
            }
            if (this.getTable() != null) {
                TableProxyDB2 targetTable = ((TableProxySetDB2)targetDesign.getTableProxySet()).getByName(this.getTable().getName());
                if (targetTable == null) {
                    TableProxyDB2 newTable = (TableProxyDB2)((TableProxySetDB2)targetDesign.getTableProxySet()).createProxy(this.getTable().getObject());
                    newTable.setName(this.getTable().getName());
                    newTable.setRawObject(true);
                    auxTable.setTable(newTable);
                } else {
                    auxTable.setTable(targetTable);
                }
            }
            if (this.getColumn() != null) {
                ColumnProxyDB2 targetColumn = ((ColumnProxySetDB2)targetDesign.getColumnProxySet()).getByName(this.getColumn().getName());
                if (targetColumn == null) {
                    ColumnProxyDB2 newColumn = (ColumnProxyDB2)((ColumnProxySetDB2)targetDesign.getColumnProxySet()).createProxy(this.getColumn().getObject());
                    newColumn.setName(this.getColumn().getName());
                    newColumn.setRawObject(true);
                    auxTable.setColumn(newColumn);
                } else {
                    auxTable.setColumn(targetColumn);
                }
            }
            auxTable.setPartNumber(this.getPartNumber());
            auxTable.setComment(this.getComment());
            auxTable.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.aindexes.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    public StorageObjectCollection getAUXTableIndexes() {
        return this.aindexes;
    }

    public AUXTableIndexDB2 createAUXTableIndex() {
        AUXTableIndexDB2 ind = (AUXTableIndexDB2)this.aindexes.createElement(null);
        ind.setAuxTable(this);
        ind.setPAC_Element(this);
        return ind;
    }
}

