/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class ReadRequestQueue
extends ModelObject {
    private StorageDesign storageDesign;
    private Map idMap = new HashMap();

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public ReadRequest getReadRequest(String id) {
        if (this.idMap.containsKey(id)) {
            return (ReadRequest)this.idMap.get(id);
        }
        ReadRequest readRequest = new ReadRequest(this.getStorageDesign(), id);
        this.idMap.put(id, readRequest);
        return readRequest;
    }

    public void removeReadRequest(ReadRequest readRequest) {
        this.idMap.remove(readRequest.getObjectId());
    }

    public ReadRequest[] getReadRequests() {
        return this.idMap.values().toArray(new ReadRequest[this.idMap.size()]);
    }

    public void clear() {
        this.idMap.clear();
    }

    public int size() {
        return this.idMap.size();
    }

    @Override
    public String toString() {
        return new StringBuffer("Queue(").append(this.idMap).append(")").toString();
    }
}

