/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;

public class DistinctTypeProxy
extends RelationalObjectProxy {
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    private String usedDistinctType = "";
    private UsedDistinctTypeSet usedDTSet = null;
    protected String nullType;
    public static final String[] NULL_STATES = new String[]{"NULL", "NOT NULL"};
    private static Set nullSet = null;
    public static final String TYPE_NAME = "DType";

    public DistinctTypeProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public DistinctTypeProxy(DesignObject object, StorageDesign storageDesign) {
        super(object, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "UDDT-Distinct Type";
    }

    public DistinctType getDistinctType() {
        return (DistinctType)this.getObject();
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean commentChanged) {
        this.commentChanged = commentChanged;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean commentInRDBMSChanged) {
        this.commentInRDBMSChanged = commentInRDBMSChanged;
    }

    public void setUsedDistinctType(String usedDistinctType) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUsedDistinctTypeSet(usedDistinctType);
        } else {
            this.addUsedDistinctType(usedDistinctType);
        }
        this.usedDistinctType = this.getUsedDTSet().toString();
        this.fireDataFieldChange();
    }

    private void addUsedDistinctType(String usedDistinctType) {
        String usedDTName = usedDistinctType.substring(usedDistinctType.lastIndexOf(46) + 1, usedDistinctType.length());
        if (!this.getUsedDTSet().contains(usedDTName)) {
            this.getUsedDTSet().add(usedDTName);
        }
    }

    private void recreateUsedDistinctTypeSet(String users) {
        this.getUsedDTSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            String user = st.nextToken().trim();
            if (this.getUsedDTSet().contains(user)) continue;
            this.getUsedDTSet().add(user);
        }
    }

    public String getUsedDistinctType() {
        return this.usedDistinctType;
    }

    public UsedDistinctTypeSet getUsedDTSet() {
        if (this.usedDTSet == null) {
            this.usedDTSet = new UsedDistinctTypeSet();
        }
        return this.usedDTSet;
    }

    public void clearFromDataBase(DataBaseSqlServer database) {
        UsedUserDefinedData[] usedDTSet = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedDTSet.length; ++i) {
            UsedUserDefinedData usedDT = usedDTSet[i];
            if (usedDT.getDistinctTypeProxy() != this || usedDT.getDatabase() != database) continue;
            this.getUsedDTSet().remove(usedDT.getName());
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedDT);
        }
    }

    @Override
    public void changed(DesignObject obj, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.OBJECT_REMOVED) && event.getAffected() instanceof DistinctType) {
            DistinctType dt = (DistinctType)event.getAffected();
            if (this.getObject() == dt) {
                this.removeUsedDistinctType();
            }
        }
        super.changed(obj, event);
    }

    public void removeUsedDistinctType() {
        UsedUserDefinedData[] usedDTSet = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedDTSet.length; ++i) {
            UsedUserDefinedData usedDT = usedDTSet[i];
            if (usedDT.getDistinctTypeProxy() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedDT);
        }
    }

    protected boolean checkNullType(String value) {
        if (nullSet == null) {
            nullSet = new HashSet();
            nullSet.addAll(Arrays.asList(NULL_STATES));
        }
        return nullSet.contains(value);
    }

    public String getNullType() {
        return this.nullType;
    }

    public void setNullType(String nullType) {
        if (this.checkNullType(nullType)) {
            this.nullType = nullType;
            this.fireDataFieldChange();
        }
    }

    public String getDatatypeString() {
        LogicalDatatype type = this.getDistinctType().getLogicalDataType();
        if (type != null) {
            TreeMap<String, CallSite> map = new TreeMap<String, CallSite>();
            map.put("size", (CallSite)((Object)this.getDistinctType().getSize()));
            map.put("precision", (CallSite)((Object)("" + this.getDistinctType().getPrecision())));
            map.put("scale", (CallSite)((Object)("" + this.getDistinctType().getScale())));
            MDDataType dtype = type.createDataType(this.getRDBMSType().toString(), map);
            return dtype.toString();
        }
        return "";
    }

    public class UsedDistinctTypeSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

