/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.editor.process.InfoStructurePropertiesDialogEx;

public class InfoStructure
extends AbstractProcessObject {
    public static final String[] GROWTH_RATE_UNITS_DISPLAY = new String[]{Messages.getString("InfoStructure.Day"), Messages.getString("InfoStructure.Month"), Messages.getString("InfoStructure.Year")};
    public static final String[] GROWTH_RATE_UNITS = new String[]{"Day", "Month", "Year"};
    private List attributes = new ArrayList();
    private int volume = 0;
    private int growthRatePercent = 0;
    private String growthRateUnit = GROWTH_RATE_UNITS[0];
    private List flows = new ArrayList();
    public static final String TYPE_NAME = "InfoStructure";

    public InfoStructure(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "ISTR";
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void removeAttribute(Attribute attribute) {
        this.attributes.remove(attribute);
    }

    public List getProcesses() {
        return null;
    }

    public List getInfoFlows() {
        this.flows.clear();
        for (DataFlowDesign dfd : this.getDesign().getProcessModel().getDataFlowDesigns()) {
            Iterator it2 = dfd.getFlowSet().iterator();
            while (it2.hasNext()) {
                Flow flow = (Flow)it2.next();
                if (!flow.getInfoStructures().contains(this) || this.flows.contains(flow)) continue;
                this.flows.add(flow);
            }
        }
        Iterator it = this.getDesign().getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage pack = (TransformationPackage)it.next();
            for (TransformationTask task : pack.getTransformationTaskSet()) {
                Iterator it2 = task.getFlowSet().iterator();
                while (it2.hasNext()) {
                    Flow flow = (Flow)it2.next();
                    if (!flow.getInfoStructures().contains(this) || this.flows.contains(flow)) continue;
                    this.flows.add(flow);
                }
            }
        }
        return this.flows;
    }

    public void removeFromFlows() {
        for (Flow flow : this.getInfoFlows()) {
            flow.getInfoStructures().remove(this);
        }
    }

    public int getGrowthRatePercent() {
        return this.growthRatePercent;
    }

    public void setGrowthRatePercent(int growthRatePercent) {
        this.growthRatePercent = growthRatePercent;
    }

    public String getGrowthRateUnit() {
        return this.growthRateUnit;
    }

    public void setGrowthRateUnit(String growthRateUnit) {
        this.growthRateUnit = growthRateUnit;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            InfoStructurePropertiesDialogEx dialog = new InfoStructurePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "infostructure" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Attribute getAttributeByID(String id) {
        for (Attribute attr : this.attributes) {
            if (!attr.getObjectID().equals(id)) continue;
            return attr;
        }
        return null;
    }
}

