/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.swingui.editor.process.AgentPropertiesDialogEx;

public class ExternalAgent
extends AbstractProcessObject
implements EditableFonts {
    public static final int TYPE_ORGANIZATIONAL_UNIT = 0;
    public static final int TYPE_SYSTEM = 1;
    public static final int TYPE_ROLE = 2;
    public static final int TYPE_OTHER = 3;
    public static final String[] FILE_TYPES_DISPLAY = new String[]{Messages.getString("ExternalAgent.CSV"), Messages.getString("ExternalAgent.FixedLengthFields"), Messages.getString("ExternalAgent.Excel"), Messages.getString("ExternalAgent.PlainText")};
    public static final String[] FILE_TYPES_INTERNAL = new String[]{"CSV", "Fixed Length Fields", "Excel", "Plain Text"};
    public static final String[] TRANSFER_TYPES_DISPLAY = new String[]{Messages.getString("ExternalAgent.FullRefresh"), Messages.getString("ExternalAgent.ChangesCapture"), Messages.getString("ExternalAgent.TriggeredCapture"), Messages.getString("ExternalAgent.ApplicationAssistedCapture"), Messages.getString("ExternalAgent.TimeStampBasedCapture"), Messages.getString("ExternalAgent.FileComparisonCapture")};
    public static final String[] TRANSFER_TYPES_INTERNAL = new String[]{"Full Refresh", "Changes Capture", "Triggered Capture", "Application Assisted Capture", "Time-Stamp based Capture", "File Comparison Capture"};
    private int type = 3;
    private String owner = "";
    private String source = "";
    private String fileName = "";
    private String location = "";
    private String fileType = FILE_TYPES_INTERNAL[0];
    private String fieldSeparator = ",";
    private String transferType = TRANSFER_TYPES_INTERNAL[0];
    private List externalDatas = new ArrayList();
    private boolean isSelfDescribing = false;
    private int skipRecords = 0;
    private String textDelimiter = "";
    private List editableFonts = new ArrayList();
    public static final String TYPE_NAME = "ExtAgent";

    public ExternalAgent(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "EXA";
    }

    public int getType() {
        return this.type;
    }

    public String getAgentTypeName() {
        return AgentPropertiesDialogEx.TYPES[this.type];
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AgentPropertiesDialogEx dialog = new AgentPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public void addExternalData(ExternalData externalData) {
        if (!this.externalDatas.contains(externalData)) {
            this.externalDatas.add(externalData);
        }
    }

    public void removeExtData(ExternalData data) {
        this.externalDatas.remove(data);
        data.remove();
    }

    public ExternalData createExternalData() {
        ExternalData ed = ((DataFlowDesign)this.getDesignPart()).createExternalData();
        this.addExternalData(ed);
        return ed;
    }

    public void removeInfoStructure(ExternalData externalData) {
        this.externalDatas.remove(externalData);
    }

    public List getExternalDatas() {
        return this.externalDatas;
    }

    public ExternalData getExternalDataByID(String id) {
        for (ExternalData ed : this.externalDatas) {
            if (!ed.getObjectID().equals(id)) continue;
            return ed;
        }
        return null;
    }

    public List getAttributes() {
        Iterator is;
        List flowlist;
        ArrayList<DesignObject> result = new ArrayList<DesignObject>();
        for (Flow flow : this.getOutgoingFlows()) {
            flowlist = flow.getInfoStructures();
            is = flowlist.iterator();
            while (is.hasNext()) {
                for (DesignObject dobj : ((InfoStructure)is.next()).getAttributes()) {
                    if (result.contains(dobj)) continue;
                    result.add(dobj);
                }
            }
        }
        for (Flow flow : this.getIncomingFlows()) {
            flowlist = flow.getInfoStructures();
            is = flowlist.iterator();
            while (is.hasNext()) {
                for (DesignObject dobj : ((InfoStructure)is.next()).getAttributes()) {
                    if (result.contains(dobj)) continue;
                    result.add(dobj);
                }
            }
        }
        return result;
    }

    public boolean isSelfDescribing() {
        return this.isSelfDescribing;
    }

    public void setSelfDescribing(boolean isSelfDescribing) {
        this.isSelfDescribing = isSelfDescribing;
    }

    public int getSkipRecords() {
        return this.skipRecords;
    }

    public void setSkipRecords(int skipRecords) {
        this.skipRecords = skipRecords;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(String textDelimiter) {
        this.textDelimiter = textDelimiter;
    }

    @Override
    public String getFCObjectType() {
        return "External Agent";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "agent" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void copy(DesignObject desObject) {
        ExternalAgent agent = (ExternalAgent)desObject;
        super.copy(desObject);
        agent.setSynonym(this.getSynonym());
        agent.setType(this.getType());
        agent.setOwner(this.getOwner());
        agent.setSource(this.getSource());
        agent.setFileName(this.getFileName());
        agent.setLocation(this.getLocation());
        agent.setFileType(this.getFileType());
        agent.setFieldSeparator(this.getFieldSeparator());
        agent.setTransferType(this.getTransferType());
        agent.setSelfDescribing(this.isSelfDescribing);
        agent.setSkipRecords(this.getSkipRecords());
        agent.setTextDelimiter(this.getTextDelimiter());
        for (ExternalData exData : this.getExternalDatas()) {
            ExternalData newExData = agent.createExternalData();
            newExData.setName(exData.getName());
            newExData.setComment(exData.getComment());
            newExData.setType(exData.getType());
            newExData.setStartingPos(exData.getStartingPos());
            newExData.setDescription(exData.getDescription());
            newExData.setStructured(exData.isStructured());
            newExData.setRecordStructure(exData.getRecordStructure());
        }
    }
}

