/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.util.GUID;

public class SlowChangingAttribute
extends AbstractMDObject
implements ID_ObjectPropertyTranslator {
    public static final String[] TYPES = new String[]{"NONE", "TYPE 1", "TYPE 2", "TYPE 3"};
    public static final String[] CLASSIFICATIONS = new String[]{"DEFAULT_ORDER", "END_DATE", "TIME_SPAN", "MEMBER_LONG_DESCRIPTION", "MEMBER_SHORT_DESCRIPTION", "MEMBER_VISIBLE", "USER"};
    private ContainedObject attribute;
    private List historyAttributes = new ArrayList();
    private String type = TYPES[0];
    private String classification = CLASSIFICATIONS[6];
    private String name;
    private boolean indexed;
    private String objectID;
    private Level level;
    public static final String NEW_NAME = "New_Descr_Attr";

    public SlowChangingAttribute(Level level, String name) {
        super(level.getDesignPart());
        this.name = name != null ? name : NEW_NAME;
        this.level = level;
        this.objectID = new GUID().toString();
    }

    public SlowChangingAttribute(Level level, ContainedObject attribute) {
        this(level, attribute.getName());
        this.attribute = attribute;
    }

    public SlowChangingAttribute(Level level, SlowChangingAttribute scha) {
        this(level, scha.getName());
        this.attribute = scha.getAttribute();
        this.historyAttributes.addAll(scha.getHistoryAttributes());
        this.type = scha.getType();
        this.classification = scha.getClassification();
        this.indexed = scha.indexed;
    }

    public ContainedObject getAttribute() {
        return this.attribute;
    }

    public void setAttribute(ContainedObject attribute) {
        this.attribute = attribute;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public List getHistoryAttributes() {
        return this.historyAttributes;
    }

    public void addHistoryAttribute(ContainedObject attribute) {
        this.historyAttributes.add(attribute);
    }

    public void removeHistoryAttribute(ContainedObject attribute) {
        this.historyAttributes.remove(attribute);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.attribute != null) {
                return this.attribute.getName();
            }
            return "";
        }
        return this.name;
    }

    @Override
    public boolean setName(String name) {
        this.name = name;
        return true;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public String getObjectID() {
        return this.objectID;
    }

    @Override
    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        return this.level.translateIdToObject(propertyName, id);
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        return this.level.translateObjectToID(propertyName, object);
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getNameInOracleAW() {
        return "";
    }

    @Override
    public String getDirectorySegmentName() {
        return "";
    }

    @Override
    public String getLongName() {
        return this.level.getName() + "." + this.getName();
    }

    @Override
    public void copy(DesignObject desObject) {
        SlowChangingAttribute sca = (SlowChangingAttribute)desObject;
        super.copy(sca);
        sca.setAttribute(this.getAttribute());
        sca.setIndexed(this.isIndexed());
        sca.setType(this.getType());
        sca.getHistoryAttributes().addAll(this.getHistoryAttributes());
        sca.setClassification(this.getClassification());
    }
}

