/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;

public class SQLtoAWGenerator {
    private SQLAccessToAW sqlAccesToAW;
    private boolean formatted;
    private List outSQLAttributes;
    private String olap_calc = "olap_calc";
    private String indent = "   ";
    private String twoindents = this.indent + this.indent;
    private String threeindents = this.twoindents + this.indent;
    private String fourindents = this.threeindents + this.indent;
    private String fiveindents = this.fourindents + this.indent;
    private String sixindents = this.fiveindents + this.indent;
    private String sevindents = this.sixindents + this.indent;
    private StringBuffer sb = new StringBuffer();
    private StringBuffer lmsb = new StringBuffer();

    public String generateSQL(SQLAccessToAW sqlAccesToAW, boolean formatted, List outSQLAttributes) {
        this.formatted = formatted;
        this.outSQLAttributes = outSQLAttributes;
        this.sqlAccesToAW = sqlAccesToAW;
        this.sb.setLength(0);
        this.lmsb.setLength(0);
        this.makeSQL();
        return this.sb.toString();
    }

    private void makeSQL() {
        if (this.sqlAccesToAW.isUseObjectType()) {
            this.addObjectTypeDef();
            this.addTableTypeDef();
        }
        this.addViewDef();
    }

    private void addObjectTypeDef() {
        this.sb.append("CREATE TYPE ").append(this.sqlAccesToAW.getObjectADTName()).append(" AS OBJECT (");
        boolean first = true;
        for (int i = 0; i < this.outSQLAttributes.size(); ++i) {
            SQLAttribute sqla = (SQLAttribute)this.outSQLAttributes.get(i);
            if (first) {
                first = false;
                this.sb.append("\n").append(this.threeindents).append(this.getAttrName(sqla)).append(" ").append(sqla.getDataType());
                continue;
            }
            this.sb.append(",\n").append(this.threeindents).append(this.getAttrName(sqla)).append(" ").append(sqla.getDataType());
        }
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (first) {
                first = false;
                this.sb.append("\n").append(this.threeindents).append(this.olap_calc).append(" raw(32)");
            } else {
                this.sb.append(",\n").append(this.threeindents).append(this.olap_calc).append(" raw(32)");
            }
        }
        this.sb.append("\n").append(this.threeindents).append(");");
        this.sb.append("\n\n");
    }

    private void addTableTypeDef() {
        this.sb.append("CREATE TYPE ").append(this.sqlAccesToAW.getTableADTName()).append(" AS TABLE OF ").append(this.sqlAccesToAW.getObjectADTName());
        this.sb.append(";\n");
    }

    private void addViewDef() {
        this.addCreateView();
        this.addSelect();
    }

    private void addCreateView() {
        this.sb.append("\nCREATE OR REPLACE VIEW ").append(this.sqlAccesToAW.getName().replaceAll(" ", "_")).append(" AS ");
    }

    private void addSelect() {
        this.sb.append("\n" + this.indent).append("SELECT ");
        this.addSelectColumns();
        this.addFromClause();
        this.addAWName();
        this.addTableType();
        this.addOlapCommand();
        this.addLimitMap();
        this.addClosingBrackets();
        this.addModelClause();
    }

    private void addClosingBrackets() {
        this.sb.append("\n").append(this.twoindents).append("))");
    }

    private void addSelectColumns() {
        boolean first = true;
        for (int i = 0; i < this.outSQLAttributes.size(); ++i) {
            SQLAttribute sqla = (SQLAttribute)this.outSQLAttributes.get(i);
            if (first) {
                first = false;
                this.sb.append("\n").append(this.fourindents).append(this.getAttrName(sqla));
                continue;
            }
            this.sb.append(",\n").append(this.fourindents).append(this.getAttrName(sqla));
        }
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (first) {
                first = false;
                this.sb.append("\n").append(this.fourindents).append(this.olap_calc);
            } else {
                this.sb.append(",\n").append(this.fourindents).append(this.olap_calc);
            }
        }
    }

    private void addFromClause() {
        this.sb.append("\n").append(this.twoindents).append("FROM TABLE(OLAP_TABLE(");
    }

    private void addAWName() {
        this.sb.append("\n").append(this.threeindents).append("'" + this.sqlAccesToAW.getAWName().replaceAll(" ", "_") + " duration session',");
    }

    private void addTableType() {
        if (this.sqlAccesToAW.isUseObjectType()) {
            this.sb.append("\n").append(this.threeindents).append("'" + this.sqlAccesToAW.getTableADTName().replaceAll(" ", "_") + "',");
        } else {
            this.sb.append("\n").append(this.threeindents).append("'',");
        }
    }

    private void addOlapCommand() {
        this.sb.append("\n").append(this.threeindents).append("'',");
    }

    private void addLimitMap() {
        String lm = this.makeLimimtMap();
        if (this.formatted) {
            this.sb.append("\n" + this.threeindents + "'").append(lm).append("'");
        } else if (lm.length() <= 32000) {
            int k = lm.length() / 4000;
            boolean first = true;
            for (int i = 0; i < k + 1; ++i) {
                int begind = i * 4000;
                int endind = begind + 4000;
                if (endind > lm.length()) {
                    endind = lm.length();
                }
                String lm_part = lm.substring(begind, endind);
                if (first) {
                    this.sb.append("\n" + this.threeindents + "'" + lm_part + "'");
                    first = false;
                    continue;
                }
                this.sb.append(",\n" + this.threeindents + "'" + lm_part + "'");
            }
        }
    }

    private String makeLimimtMap() {
        this.addDimensions();
        this.addMeasures();
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.fiveindents).append("ROW2CELL ").append(this.olap_calc);
            } else {
                this.lmsb.append(" ROW2CELL ").append(this.olap_calc);
            }
        }
        return this.lmsb.toString();
    }

    private void addModelClause() {
        SQLAttribute sqla;
        int i;
        this.sb.append("\n").append(this.indent).append("model");
        this.sb.append("\n").append(this.twoindents).append("dimension by (");
        boolean first = true;
        for (i = 0; i < this.outSQLAttributes.size(); ++i) {
            sqla = (SQLAttribute)this.outSQLAttributes.get(i);
            if (!sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) continue;
            if (first) {
                first = false;
                this.sb.append(this.getAttrName(sqla));
                continue;
            }
            this.sb.append(",").append(this.getAttrName(sqla));
        }
        for (i = 0; i < this.outSQLAttributes.size(); ++i) {
            sqla = (SQLAttribute)this.outSQLAttributes.get(i);
            if (!sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID)) continue;
            if (first) {
                first = false;
                this.sb.append(this.getAttrName(sqla));
                continue;
            }
            this.sb.append(",").append(this.getAttrName(sqla));
        }
        this.sb.append(")");
        this.sb.append("\n").append(this.twoindents).append("measures (");
        first = true;
        for (i = 0; i < this.outSQLAttributes.size(); ++i) {
            sqla = (SQLAttribute)this.outSQLAttributes.get(i);
            if (sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID) || sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) continue;
            if (first) {
                first = false;
                this.sb.append(this.getAttrName(sqla));
                continue;
            }
            this.sb.append(",").append(this.getAttrName(sqla));
        }
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (first) {
                first = false;
                this.sb.append(this.olap_calc);
            } else {
                this.sb.append(",").append(this.olap_calc);
            }
        }
        this.sb.append(")\n" + this.twoindents + "rules update sequential order();");
    }

    private String getAttrName(SQLAttribute sqla) {
        return sqla.getName().replaceAll(" ", "_");
    }

    private void addDimensions() {
        boolean first = true;
        for (SQLAccessToAW.SQLDimension sqld : this.sqlAccesToAW.getSqlDimensionDefinitions()) {
            this.addDimension(sqld, first);
            first = false;
        }
    }

    private void addDimension(SQLAccessToAW.SQLDimension sqld, boolean first) {
        SQLAttribute id = this.sqlAccesToAW.getIDColumnForDimension(this.outSQLAttributes, sqld.getDimension());
        SQLAttribute gid = this.sqlAccesToAW.getGIDForDimension(this.outSQLAttributes, sqld.getDimension());
        List attributes = this.getAttributesFor(this.outSQLAttributes, sqld);
        if (this.formatted) {
            if (first) {
                this.lmsb.append("DIMENSION ");
            } else {
                this.lmsb.append("\n").append(this.threeindents).append(" DIMENSION ");
            }
        } else {
            this.lmsb.append(" DIMENSION ");
        }
        if (id != null) {
            this.lmsb.append(id.getName()).append(" FROM ");
        }
        this.lmsb.append(sqld.getName());
        this.addWithClause(sqld, attributes);
        for (SQLAccessToAW.SQLHierarchy sqlh : sqld.getSelectedSQLHierarhies()) {
            this.addHierarchy(sqlh, sqld, gid);
            gid = null;
        }
        for (SQLAttribute sqla : attributes) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.fiveindents).append("ATTRIBUTE ");
            } else {
                this.lmsb.append(" ATTRIBUTE ");
            }
            this.lmsb.append(sqla.getName()).append(" FROM ").append(sqla.getSQLAWName());
        }
    }

    private void addMeasures() {
        List measures = this.getMeasures(this.outSQLAttributes);
        for (SQLAttribute sqla : measures) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.threeindents).append("MEASURE ");
            } else {
                this.lmsb.append(" MEASURE ");
            }
            this.lmsb.append(sqla.getName()).append(" FROM ").append(sqla.getSQLAWName());
        }
    }

    private List getAttributesFor(List inlist, SQLAccessToAW.SQLDimension sqld) {
        ArrayList<SQLAttribute> outlist = new ArrayList<SQLAttribute>();
        for (SQLAttribute sqla : inlist) {
            if (!sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR) && !sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME) && !sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_TIME_SPAN) && !sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_END_DATE) && !sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_SHORT_DESC) && !sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_LONG_DESC) || sqla.getDimension() != sqld.getDimension()) continue;
            outlist.add(sqla);
        }
        return outlist;
    }

    private List getMeasures(List inlist) {
        ArrayList<SQLAttribute> outlist = new ArrayList<SQLAttribute>();
        for (SQLAttribute sqla : inlist) {
            if (!sqla.getType().equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) continue;
            outlist.add(sqla);
        }
        return outlist;
    }

    private void addWithClause(SQLAccessToAW.SQLDimension sqld, List attributes) {
        if (sqld.getSelectedSQLHierarhies().size() > 0 || attributes.size() > 0) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.fourindents).append("WITH");
            } else {
                this.lmsb.append(" WITH");
            }
        }
    }

    private void addHierarchy(SQLAccessToAW.SQLHierarchy sqlh, SQLAccessToAW.SQLDimension sqld, SQLAttribute gid) {
        String dname = sqld.getName();
        String hname = sqlh.getHierarchy().getName().replaceAll(" ", "_").toUpperCase();
        if (this.formatted) {
            this.lmsb.append("\n").append(this.fourindents).append("HIERARCHY ").append(dname + "_parentrel ");
            this.lmsb.append("\n").append(this.fiveindents).append("( ").append(dname + "_hierlist ");
            this.lmsb.append("''").append(hname).append("'' ) ");
            this.lmsb.append("\n").append(this.fiveindents).append("INHIERARCHY ").append(dname + "_inhier ");
            if (gid != null) {
                this.lmsb.append("\n").append(this.fiveindents).append("GID ").append(gid.getName()).append(" FROM " + dname + "_gid");
            }
        } else {
            this.lmsb.append(" HIERARCHY ").append(dname + "_parentrel ");
            this.lmsb.append("( ").append(dname + "_hierlist ");
            this.lmsb.append("''").append(hname).append("'' ) ");
            this.lmsb.append("INHIERARCHY ").append(dname + "_inhier ");
            if (gid != null) {
                this.lmsb.append("GID ").append(gid.getName()).append(" FROM " + dname + "_gid");
            }
        }
        if (sqlh.isRollupForm()) {
            this.addFamilyRel(sqlh, dname, sqld);
        }
    }

    private void addFamilyRel(SQLAccessToAW.SQLHierarchy sqlh, String dimname, SQLAccessToAW.SQLDimension sqld) {
        List levels = sqlh.getValidSelLevels();
        ArrayList<String> list = new ArrayList<String>();
        if (levels.size() > 0) {
            if (this.formatted) {
                int i;
                this.lmsb.append("\n").append(this.fiveindents).append("FAMILYREL ");
                boolean first = true;
                for (i = 0; i < levels.size(); ++i) {
                    Level level = (Level)levels.get(i);
                    String lname = level.getName().replaceAll(" ", "_").toUpperCase();
                    SQLAttribute sqla = this.sqlAccesToAW.getSQLLevelAttr(this.outSQLAttributes, sqld.getDimension(), sqlh.getHierarchy(), level);
                    if (sqla == null) continue;
                    if (first) {
                        this.lmsb.append("\n").append(this.sevindents).append(sqla.getName());
                        first = false;
                    } else {
                        this.lmsb.append(",\n").append(this.sevindents).append(sqla.getName());
                    }
                    list.add(lname);
                }
                first = true;
                this.lmsb.append("\n").append(this.sixindents).append("FROM ");
                for (i = 0; i < list.size(); ++i) {
                    String lname = (String)list.get(i);
                    if (first) {
                        this.lmsb.append("\n").append(this.sevindents).append(dimname + "_familyrel");
                        this.lmsb.append("(" + dimname + "_levellist ''" + lname + "'') ");
                        first = false;
                        continue;
                    }
                    this.lmsb.append(",\n").append(this.sevindents).append(dimname + "_familyrel");
                    this.lmsb.append("(" + dimname + "_levellist ''" + lname + "'') ");
                }
                if (sqlh.getLabelAttribute() != null) {
                    this.lmsb.append("\n").append(this.sixindents).append("LABEL ").append(sqlh.getLabelAttribute().getSQLAWName());
                }
            } else {
                int i;
                this.lmsb.append(" FAMILYREL ");
                boolean first = true;
                for (i = 0; i < levels.size(); ++i) {
                    Level level = (Level)levels.get(i);
                    String lname = level.getName().replaceAll(" ", "_").toUpperCase();
                    SQLAttribute sqla = this.sqlAccesToAW.getSQLLevelAttr(this.outSQLAttributes, sqld.getDimension(), sqlh.getHierarchy(), level);
                    if (sqla == null) continue;
                    if (first) {
                        this.lmsb.append(sqla.getName());
                        first = false;
                    } else {
                        this.lmsb.append(",").append(sqla.getName());
                    }
                    list.add(lname);
                }
                first = true;
                this.lmsb.append(" FROM ");
                for (i = 0; i < list.size(); ++i) {
                    String lname = (String)list.get(i);
                    if (first) {
                        this.lmsb.append(dimname + "_familyrel");
                        this.lmsb.append("(" + dimname + "_levellist ''" + lname + "'') ");
                        first = false;
                        continue;
                    }
                    this.lmsb.append(",").append(dimname + "_familyrel");
                    this.lmsb.append("(" + dimname + "_levellist ''" + lname + "'') ");
                }
                if (sqlh.getLabelAttribute() != null) {
                    this.lmsb.append(" LABEL ").append(sqlh.getLabelAttribute().getSQLAWName());
                }
            }
        }
    }
}

