/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;

public class EngineerFromOracle {
    static String REFERENCES = "REFERENCES";
    public static String USE_FK = Messages.getString("EngineerFromOracle.UseFK");
    public static String USE_COLUMN_NAMES = Messages.getString("EngineerFromOracle.UseColumnNames");
    private final MultidimensionalDesign mdmDesign;
    private RelationalDesign phDes;
    private final StorageDesignOracle sdOracle;
    private DimensionAttributeOracle attribute;
    private boolean valid = true;
    private StringBuffer validationSB;
    private int minDimensions;
    private boolean factsOnly = false;
    private boolean matchOnFK = true;

    public EngineerFromOracle(MultidimensionalDesign mdmDesign, RelationalDesign phDes, StorageDesignOracle sdOracle, int minDimensions, boolean factsOnly, String searchType) {
        this.mdmDesign = mdmDesign;
        this.phDes = phDes;
        this.sdOracle = sdOracle;
        this.factsOnly = factsOnly;
        this.matchOnFK = USE_FK.equalsIgnoreCase(searchType);
        if (minDimensions > 2) {
            this.minDimensions = minDimensions;
        }
    }

    public void engineer() {
        this.validationSB = new StringBuffer(Messages.getString("EngineerFromOracle.ErrorsDuringValidationPhase"));
        this.validate();
        if (this.valid) {
            for (DimensionOracle dimora : this.sdOracle.getDimensionSet()) {
                this.processDimension(dimora);
            }
            this.makeCubes();
            ApplicationView.log(MessageFormat.format(Messages.getString("EngineerFromOracle.EngineerFromOracleModel"), this.phDes.getName()));
        } else {
            LogReport lr = new LogReport(this.mdmDesign.getAppView());
            lr.setName(Messages.getString("EngineerFromOracle.ValidationLog"));
            lr.setLog(this.validationSB.toString());
            lr.showDialog(new java.awt.Dimension(750, 550));
        }
    }

    private void processDimension(DimensionOracle dim) {
        Object[] levels = dim.getLevelSet();
        Dimension dimension = null;
        if (dim.getGeneratorID() != null) {
            dimension = (Dimension)this.mdmDesign.getDimensionSet().getObjectByID(dim.getGeneratorID());
        }
        if (dimension == null) {
            dimension = (Dimension)this.mdmDesign.getDimensionSet().getObjectGeneratedBy(dim.getObjectID());
        }
        if (dimension == null) {
            dimension = (Dimension)this.mdmDesign.getDimensionSet().getByName(dim.getName());
        }
        if (dimension != null) {
            this.clearDimension(dimension);
        }
        if (dimension == null) {
            dimension = this.mdmDesign.createDimension();
        }
        dimension.setGeneratorID(dim.getObjectID());
        dimension.setName(dim.getName());
        for (int i = 0; i < levels.length; ++i) {
            LevelOracle level = (LevelOracle)levels[i];
            this.processLevel(level, dim);
        }
        Object[] hiers = dim.getHierarchySet();
        for (int i = 0; i < hiers.length; ++i) {
            HierarchyOracle hier = (HierarchyOracle)hiers[i];
            this.processHierarchy(hier, dimension);
        }
    }

    private void clearDimension(Dimension dim) {
        int i;
        ArrayList list = new ArrayList();
        Object[] objects = dim.getHierarchies().toArray();
        for (i = 0; i < objects.length; ++i) {
            Hierarchy hier = (Hierarchy)objects[i];
            list.addAll(hier.getLevels());
        }
        for (i = 0; i < list.size(); ++i) {
            ((Level)list.get(i)).remove();
        }
    }

    private void processLevel(LevelOracle levelOra, DimensionOracle dim) {
        Table tab;
        Level level = (Level)this.mdmDesign.getLevelSet().getObjectGeneratedBy(levelOra.getObjectID());
        if (level == null) {
            level = this.mdmDesign.createLevel();
            level.setGeneratorID(levelOra.getObjectID());
            level.setName(levelOra.getName());
            if (!level.getName().equalsIgnoreCase(levelOra.getName())) {
                levelOra.setNewName(level.getName());
            } else {
                levelOra.setNewName(levelOra.getName());
            }
            level.setOraDimension(dim.getName());
        } else {
            level.getLevelKey().clear();
            level.getSlowChangingAttributes().clear();
        }
        TableProxy tp = levelOra.getLevelTable();
        if (tp != null && (tab = (Table)tp.getObject()) != null) {
            Column column;
            ColumnProxy col;
            int i;
            ContainerObject ent = null;
            ColumnProxy[] cps = tp.getColumnProxies();
            for (i = 0; i < cps.length; ++i) {
                ContainedObject attribute;
                col = cps[i];
                if (!levelOra.getColumnSet().contains(col.getObjectID()) || (column = (Column)col.getObject()) == null || (attribute = this.getContained(column)) == null) continue;
                level.getLevelKey().add(attribute);
                if (ent != null) continue;
                ent = attribute.getContainer();
            }
            this.attribute = this.getAttributeForLevel(levelOra, this.sdOracle);
            if (this.attribute != null) {
                for (i = 0; i < cps.length; ++i) {
                    ContainedObject attr;
                    col = cps[i];
                    if (!this.attribute.getColumnSet().contains(col.getObjectID()) || (column = (Column)col.getObject()) == null || (attr = this.getContained(column)) == null) continue;
                    level.addDescriptiveAttribute(new SlowChangingAttribute(level, attr));
                    if (ent != null) continue;
                    ent = attr.getContainer();
                }
            }
            if (ent == null) {
                ent = this.getContainer(tab);
            }
            if (ent != null) {
                level.setLevelEntity(ent);
            }
        }
    }

    private void validateLevel(LevelOracle levelOra) {
        Table tab;
        TableProxy tp = levelOra.getLevelTable();
        if (tp != null && (tab = (Table)tp.getObject()) != null) {
            ContainerObject ent = this.getContainer(tab);
            if (ent == null) {
                this.valid = false;
                this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingEentityForTable"), tab.getName()));
            } else {
                ContainedObject attr;
                Column column;
                ColumnProxy col;
                int i;
                ColumnProxy[] cps = tp.getColumnProxies();
                for (i = 0; i < cps.length; ++i) {
                    col = cps[i];
                    if (!levelOra.getColumnSet().contains(col.getObjectID()) || (column = (Column)col.getObject()) == null || (attr = this.getContained(column)) != null) continue;
                    this.valid = false;
                    this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingAttributeForCcolumn"), column.getLongName()));
                }
                this.attribute = this.getAttributeForLevel(levelOra, this.sdOracle);
                if (this.attribute != null) {
                    for (i = 0; i < cps.length; ++i) {
                        col = cps[i];
                        if (!this.attribute.getColumnSet().contains(col.getObjectID()) || (column = (Column)col.getObject()) == null || (attr = this.getContained(column)) != null) continue;
                        this.valid = false;
                        this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingAttributeForCcolumn"), column.getLongName()));
                    }
                }
            }
        }
    }

    private DimensionAttributeOracle getAttributeForLevel(LevelOracle level, StorageDesignOracle stdes) {
        for (DimensionAttributeOracle attr : stdes.getDimensionAttributeSet()) {
            if (attr.getLevel() != level) continue;
            return attr;
        }
        return null;
    }

    private void processHierarchy(HierarchyOracle hierOra, Dimension dimension) {
        List levels = this.getLevels(hierOra);
        AbstractMDObject lastLevel = dimension;
        for (int i = 0; i < levels.size(); ++i) {
            Link link;
            AbstractMDObject level = (AbstractMDObject)levels.get(i);
            if (lastLevel != null && (link = lastLevel.getFirstLinkToTarget(level)) == null) {
                AbstractMDTV tv1 = (AbstractMDTV)lastLevel.getTopView();
                AbstractMDTV tv2 = (AbstractMDTV)level.getTopView();
                if (tv1 != null && tv2 != null) {
                    link = this.mdmDesign.createLink();
                    link.setSourceTV(tv1);
                    link.setTargetTV(tv2);
                    ((TVLink)link.getTopView()).addConnection();
                }
            }
            lastLevel = level;
        }
        Hierarchy hier = this.mdmDesign.getHierarchyDefinedByLevels(levels);
        if (hier != null) {
            hier.setName(hierOra.getName());
            this.processJoins(hierOra, hier);
        }
    }

    private void processJoins(HierarchyOracle hierOra, Hierarchy hier) {
        for (String join : hierOra.getJoinSet()) {
            String upperc = join.toUpperCase();
            int key = upperc.indexOf("KEY");
            int ref = upperc.indexOf(REFERENCES);
            if (key <= -1 || ref <= key + 3) continue;
            String cols = join.substring(key + 3, ref);
            String colsbr = Token.getValBetweenBrackets(cols);
            String[] colsarr = "".equalsIgnoreCase(colsbr) ? new String[]{cols} : colsbr.split(Messages.getString("EngineerFromOracle.10"));
            this.setChildToParentAttributes(colsarr, hier);
        }
    }

    private void validateJoins(HierarchyOracle hierOra) {
        for (String join : hierOra.getJoinSet()) {
            String upperc = join.toUpperCase();
            int key = upperc.indexOf("KEY");
            int ref = upperc.indexOf(REFERENCES);
            if (key <= -1 || ref <= key + 3) continue;
            String cols = join.substring(key + 3, ref);
            String colsbr = Token.getValBetweenBrackets(cols);
            String[] colsarr = "".equalsIgnoreCase(colsbr) ? new String[]{cols} : colsbr.split(",");
            this.checkChildToParentAttributes(colsarr);
        }
    }

    private void validate() {
        for (DimensionOracle dim : this.sdOracle.getDimensionSet()) {
            this.validateDimension(dim);
        }
    }

    private void validateDimension(DimensionOracle dim) {
        int i;
        Object[] objects = dim.getLevelSet();
        for (i = 0; i < objects.length; ++i) {
            this.validateLevel((LevelOracle)objects[i]);
        }
        objects = dim.getHierarchySet();
        for (i = 0; i < objects.length; ++i) {
            this.validateJoins((HierarchyOracle)objects[i]);
        }
    }

    private void setChildToParentAttributes(String[] cols, Hierarchy hier) {
        List levels = hier.getLevels();
        ColumnProxyOracle cp = ((ColumnProxySetOracle)this.sdOracle.getColumnProxySet()).getByLongName(cols[0].trim());
        if (cp != null) {
            ContainerObject ent;
            TableProxyOracle tp = cp.getTableProxy();
            ContainedObject attr = this.getContained(cp.getColumn());
            if (tp != null && attr != null && (ent = this.getContainer((Table)tp.getObject())) != null) {
                block0: for (int j = 0; j < levels.size() - 1; ++j) {
                    Level level;
                    Level lastLevel = level = (Level)levels.get(j);
                    if (level.getLevelEntity() != ent) continue;
                    for (int k = j; k < levels.size(); ++k) {
                        Link link;
                        Level level2 = (Level)levels.get(k);
                        if (ent != level2.getLevelEntity() && (link = lastLevel.getFirstLinkToTarget(level2)) != null) {
                            for (int i = 0; i < cols.length; ++i) {
                                cp = ((ColumnProxySetOracle)this.sdOracle.getColumnProxySet()).getByLongName(cols[i].trim());
                                tp = cp.getTableProxy();
                                attr = this.getContained(cp.getColumn());
                                if (tp == null || attr == null) continue;
                                link.getRollupLink().getChildToParentAttributes().add(attr);
                            }
                            break block0;
                        }
                        lastLevel = level2;
                    }
                    break;
                }
            }
        }
    }

    private void checkChildToParentAttributes(String[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            ContainedObject attr;
            ColumnProxyOracle cp = ((ColumnProxySetOracle)this.sdOracle.getColumnProxySet()).getByLongName(cols[i].trim());
            if (cp == null || (attr = this.getContained(cp.getColumn())) != null) continue;
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingAttributeForCcolumn"), cp.getColumn().getName()));
        }
    }

    private List getLevels(HierarchyOracle hierarchy) {
        ArrayList<Level> list = new ArrayList<Level>();
        String[] levelSet = hierarchy.getLevels().split(",");
        Object[] dimLevels = hierarchy.getDimension().getLevelSet();
        for (int i = 0; i < levelSet.length; ++i) {
            String levelID = levelSet[i].trim();
            for (int j = 0; j < dimLevels.length; ++j) {
                Level level;
                LevelOracle levelOra = (LevelOracle)dimLevels[j];
                if (!levelID.equalsIgnoreCase(levelOra.getObjectID()) || (level = this.getLevel(levelOra, hierarchy.getDimension())) == null) continue;
                list.add(level);
            }
        }
        return list;
    }

    private Level getLevel(LevelOracle levelOra, DimensionOracle dim) {
        Iterator it = this.mdmDesign.getLevelSet().iterator();
        String lname = levelOra.getName();
        if (!levelOra.getName().equalsIgnoreCase(levelOra.getNewName())) {
            lname = levelOra.getNewName();
        }
        while (it.hasNext()) {
            Level level = (Level)it.next();
            if (!level.getOraDimension().equalsIgnoreCase(dim.getName()) || !level.getName().equalsIgnoreCase(lname)) continue;
            return level;
        }
        return null;
    }

    private void makeCubes() {
        if (this.mdmDesign.getDimensionSet().size() >= this.minDimensions) {
            for (ContainerObject ent : this.mdmDesign.getAllColntainers()) {
                String typeID = "";
                if (ent instanceof ContainerWithKeyObject) {
                    typeID = ((ContainerWithKeyObject)ent).getTypeID();
                }
                if ((!this.factsOnly || !typeID.equalsIgnoreCase("1")) && this.factsOnly) continue;
                Iterator itd = this.mdmDesign.getDimensionSet().iterator();
                ArrayList<Dimension> dimlist = new ArrayList<Dimension>();
                while (itd.hasNext()) {
                    Dimension dim = (Dimension)itd.next();
                    if (!this.entityMatch(ent, dim)) continue;
                    dimlist.add(dim);
                }
                if (dimlist.size() < this.minDimensions) continue;
                this.makeCube(ent, dimlist);
            }
        }
    }

    private void makeCube(ContainerObject ent, List dimlist) {
        Cube cube = this.mdmDesign.getCubeOnEntity(ent);
        if (cube == null) {
            cube = this.mdmDesign.createCube();
            cube.setName(ent.getName());
            cube.setFactEntity(ent);
        }
        this.createMeasures(cube);
        for (Dimension dim : dimlist) {
            this.createLink(cube, dim);
        }
    }

    private void createMeasures(Cube cube) {
        ContainerObject entity = cube.getFactEntity();
        if (entity != null) {
            for (ContainedObject attr : entity.getElementsCollection()) {
                Measure measure;
                String dataType = "";
                if (attr instanceof ContainedObjectWithDomain) {
                    dataType = ((ContainedObjectWithDomain)attr).getDataType().getName();
                } else if (attr instanceof AbstractViewElement) {
                    dataType = ((AbstractViewElement)attr).getDataTypeString();
                }
                if (attr.isFKElement() || !this.isNumericDataType(dataType) || (measure = cube.getMeasureForAttribute(attr)) != null) continue;
                measure = this.mdmDesign.createMeasure();
                measure.setName(attr.getName());
                measure.setMeasureFact(attr);
                Measure.AggregateFunction af = measure.createAggregateFunction();
                measure.getAggregateFunctions().add(af);
                measure.setDefaultAggregationFunction(af);
                cube.addMeasure(measure);
            }
        }
    }

    private void createLink(Cube cube, Dimension dim) {
        block9: {
            ContainerObject bent;
            ContainerObject entity;
            RollupLink rlink;
            block10: {
                block7: {
                    block8: {
                        Link link = cube.getFirstLinkToTarget(dim);
                        if (link == null) {
                            link = this.mdmDesign.createLink();
                            link.setSourceTV((AbstractMDTV)cube.getTopView());
                            link.setTargetTV((AbstractMDTV)dim.getTopView());
                            ((TVLink)link.getTopView()).addConnection();
                        }
                        rlink = link.getRollupLink();
                        entity = cube.getFactEntity();
                        bent = dim.getBaseEntity();
                        if (!(entity instanceof Entity) || !(bent instanceof Entity) || bent == null || ((Entity)bent).getPK() == null) break block7;
                        if (!this.matchOnFK) break block8;
                        Relation rel = ((Entity)entity).getRelationTo((Entity)bent);
                        if (rel == null) break block9;
                        Iterator itel = entity.getElementsCollection().iterator();
                        KeyObject pk = ((Entity)bent).getPK();
                        while (itel.hasNext()) {
                            ContainedObject attr = (ContainedObject)itel.next();
                            if (attr.getDelegateElement() == null || !pk.contains(attr.getDelegateElement())) continue;
                            rlink.addChildToParentAttribute(attr);
                        }
                        break block9;
                    }
                    for (Attribute attr : ((Entity)bent).getPK().getElementsCollection()) {
                        Attribute attr2 = (Attribute)entity.getElementByName(attr.getName());
                        if (attr2 == null || !attr2.getDataType().toString().equalsIgnoreCase(attr.getDataType().toString())) continue;
                        rlink.addChildToParentAttribute(attr2);
                        Object[] measar = cube.getMeasures().toArray();
                        for (int i = 0; i < measar.length; ++i) {
                            Measure meas = (Measure)measar[i];
                            if (meas.isFormula() || meas.getMeasureFact() != attr2) continue;
                            cube.getMeasures().remove(meas);
                        }
                    }
                    break block9;
                }
                if (!(entity instanceof Table) || !(bent instanceof Table) || bent == null || ((Table)bent).getPK() == null) break block9;
                if (!this.matchOnFK) break block10;
                KeyObject pk = ((Table)bent).getPK();
                FKIndexAssociation rel = ((Table)entity).getFKIndexAssociationFor(pk);
                if (rel == null) break block9;
                FKElement[] cols = rel.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    rlink.addChildToParentAttribute(cols[i]);
                }
                break block9;
            }
            for (Column attr : ((Table)bent).getPK().getElementsCollection()) {
                Column attr2 = (Column)entity.getElementByName(attr.getName());
                if (attr2 == null || !attr2.getDataType().toString().equalsIgnoreCase(attr.getDataType().toString())) continue;
                rlink.addChildToParentAttribute(attr2);
                Object[] measar = cube.getMeasures().toArray();
                for (int i = 0; i < measar.length; ++i) {
                    Measure meas = (Measure)measar[i];
                    if (meas.isFormula() || meas.getMeasureFact() != attr2) continue;
                    cube.getMeasures().remove(meas);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean entityMatch(ContainerObject entity, Dimension dim) {
        ContainerObject bent = dim.getBaseEntity();
        if (entity instanceof Entity && bent instanceof Entity && bent != null && ((Entity)bent).getPK() != null) {
            if (this.matchOnFK) {
                Relation rel = ((Entity)entity).getRelationTo((Entity)bent);
                if (rel == null) return false;
                Iterator itel = entity.getElementsCollection().iterator();
                KeyObject pk = ((Entity)bent).getPK();
                int count = 0;
                while (itel.hasNext()) {
                    Attribute attr = (Attribute)itel.next();
                    if (attr.getDelegateElement() == null || !pk.contains(attr.getDelegateElement())) continue;
                    ++count;
                }
                if (count != pk.getElementsCollection().size()) return false;
                return true;
            }
            for (Attribute attr : ((Entity)bent).getPK().getElementsCollection()) {
                Attribute attr2 = (Attribute)entity.getElementByName(attr.getName());
                if (attr2 == null) {
                    return false;
                }
                if (attr2.getDataType().toString().equalsIgnoreCase(attr.getDataType().toString())) continue;
                return false;
            }
            return true;
        }
        if (!(entity instanceof Table) || !(bent instanceof Table) || bent == null || ((Table)bent).getPK() == null) return false;
        if (this.matchOnFK) {
            KeyObject pk = ((Table)bent).getPK();
            FKIndexAssociation rel = ((Table)entity).getFKIndexAssociationFor(pk);
            if (rel == null) return false;
            FKElement[] cols = rel.getColumns();
            return cols.length == pk.getElementsCollection().size();
        }
        for (Column attr : ((Table)bent).getPK().getElementsCollection()) {
            Column attr2 = (Column)entity.getElementByName(attr.getName());
            if (attr2 == null) {
                return false;
            }
            if (attr2.getDataType().toString().equalsIgnoreCase(attr.getDataType().toString())) continue;
            return false;
        }
        return true;
    }

    private boolean isNumericDataType(String datatype) {
        String dtype = datatype.toUpperCase();
        return dtype.indexOf("INT") > -1 || dtype.indexOf("DEC") > -1 || dtype.indexOf("NUM") > -1 || dtype.indexOf("FLOAT") > -1 || dtype.indexOf("REAL") > -1 || dtype.indexOf("DOUBLE") > -1;
    }

    private ContainerObject getContainer(ContainerObject cob) {
        if (this.mdmDesign.getBoundModel() instanceof RelationalDesign) {
            return cob;
        }
        if (cob instanceof Table) {
            return ((Table)cob).getEngEntity();
        }
        if (cob instanceof TableView) {
            return ((TableView)cob).getEngEntityView();
        }
        return null;
    }

    private ContainedObject getContained(ContainedObject cob) {
        if (this.mdmDesign.getBoundModel() instanceof RelationalDesign) {
            return cob;
        }
        if (cob instanceof Column) {
            return ((Column)cob).getEngAttribute();
        }
        if (cob instanceof ColumnView) {
            return ((ColumnView)cob).getEngAttributeView();
        }
        return null;
    }
}

