/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.impact.ImpA_Attribute;
import oracle.dbtools.crest.model.design.impact.ImpA_ColumnView;
import oracle.dbtools.crest.model.design.impact.ImpA_PK_UK;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Column
extends LongNameObjectSelection {
    private Column column;

    public ImpA_Column(Column column, ModelIdObjectSelection parent, boolean load) {
        super(column);
        this.column = column;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addColumnNodes(this);
        this.addDependentColumns();
        this.addColumnViews();
        ImpA_Attribute.addDimensionalModels(this, this.column);
        this.loaded = true;
    }

    private void addColumnNodes(ImpA_Column parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        parent.addChild(selection);
        if (this.column.getObjectID() != null) {
            List list = this.column.getDesign().getExtendedMap().getMappingsForDesignPart(this.column, this.column.getDesign().getLogicalDesign().getObjectID());
            for (XtdMapping mapping : list) {
                Attribute attribute = (Attribute)mapping.getObjectMappedTo(this.column);
                if (attribute == null) continue;
                if (!selection.hasAsParent(attribute)) {
                    selection.addChild(new ImpA_Attribute(attribute, selection, false));
                    continue;
                }
                selection.addChild(new LongNameObjectSelection(attribute));
            }
        }
        selection.sortAsString();
        ModelIdObjectSelection pkSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.PKAndUKConstraints"));
        pkSelection.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        parent.addChild(pkSelection);
        ModelIdObjectSelection fkSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.ForeignKeys"));
        fkSelection.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        parent.addChild(fkSelection);
        ModelIdObjectSelection idxSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.Indexes"));
        idxSelection.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        parent.addChild(idxSelection);
        Iterator itk = this.column.getContainerWithKeyObject().getKeySet().iterator();
        while (itk.hasNext()) {
            Index index = (Index)itk.next();
            if ((index.isPK() || index.isUnique()) && index.getElementsCollection().contains(this.column)) {
                if (!pkSelection.hasAsParent(index)) {
                    pkSelection.addChild(new ImpA_PK_UK(index, pkSelection, false));
                    continue;
                }
                pkSelection.addChild(new LongNameObjectSelection(index));
                continue;
            }
            if (index.isFK() && index.getElementsCollection().contains(this.column)) {
                fkSelection.addChild(new LongNameObjectSelection(index.getFKAssociation()));
                continue;
            }
            if (!index.getElementsCollection().contains(this.column)) continue;
            idxSelection.addChild(new LongNameObjectSelection(index));
        }
    }

    private void addDependentColumns() {
        ArrayList<Column> list = new ArrayList<Column>();
        Iterator it = this.column.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            Column clm = (Column)it.next();
            if (clm.getDelegate() != this.column) continue;
            list.add(clm);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection clmSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.DependentFKColumns"));
            clmSelection.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
            this.addChild(clmSelection);
            for (Column col : list) {
                if (!clmSelection.hasAsParent(col)) {
                    clmSelection.addChild(new ImpA_Column(col, clmSelection, false));
                    continue;
                }
                clmSelection.addChild(new LongNameObjectSelection(col));
            }
            clmSelection.sortAsString();
        }
    }

    private void addColumnViews() {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.DependentViewColumns"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        this.addChild(selection);
        ArrayList<ColumnView> list = new ArrayList<ColumnView>();
        Iterator it = ((RelationalDesign)this.column.getDesignPart()).getColumnViewSet().iterator();
        while (it.hasNext()) {
            ColumnView columnView = (ColumnView)it.next();
            if (columnView.getReferencedColumn() == null || columnView.getReferencedColumn() != this.column || columnView.getReferencedColumnView() != null) continue;
            list.add(columnView);
        }
        for (ColumnView view : list) {
            if (!selection.hasAsParent(view)) {
                selection.addChild(new ImpA_ColumnView(view, selection, false));
                continue;
            }
            selection.addChild(new ModelIdObjectSelection(view));
        }
        selection.sortAsString();
    }
}

