/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;

public class EntViewTableViewComparator
extends EngPropertiesComparator {
    private EntityView entityView;
    private TableView tableView;

    public EntViewTableViewComparator(EntityView entityView, TableView tableView) {
        super(entityView, tableView);
        this.entityView = entityView;
        this.tableView = tableView;
        this.initPropertiesList();
    }

    public EntViewTableViewComparator(EntityView entityView, TableView tableView, List filters) {
        this(entityView, tableView);
        this.applyCompareFilter(filters, entityView.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromEntityViewToTableView();
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initDeprecated();
        this.initCommentsAndNotes();
        EngPropertyHolder ph = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.entityView != null && this.entityView.getBasedOnStructuredType() != null) {
            ph.setLeftValue(this.entityView.getBasedOnStructuredType().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.tableView != null && this.tableView.getBasedOnStructuredType() != null) {
            ph.setRightValue(this.tableView.getBasedOnStructuredType().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.entityView != null && this.tableView != null && this.entityView.getBasedOnStructuredType() != this.tableView.getBasedOnStructuredType()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ENT_TABLE_TYPE_SUBSTITUTION);
        ph.setRightValue(this.tableView != null && this.tableView.getTypeSubstitution() != null ? this.tableView.getTypeSubstitution().getParentContainerObject().getName() : "");
        ph.setLeftValue(this.entityView != null && this.entityView.getTypeSubstitution() != null ? this.entityView.getTypeSubstitution().getParentContainerObject().getName() : "");
        if (this.tableView != null && this.entityView != null) {
            if (this.entityView.getTypeSubstitution() != null) {
                EntityView parentEV = (EntityView)this.entityView.getTypeSubstitution().getParentContainerObject();
                TableView parentTV = null;
                if (this.tableView.getTypeSubstitution() != null) {
                    parentTV = (TableView)this.tableView.getTypeSubstitution().getParentContainerObject();
                }
                if (parentEV.getEngTableView((RelationalDesign)this.tableView.getDesignPart()) != parentTV) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else if (this.tableView.getTypeSubstitution() != null) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (this.entityView != null && this.entityView.getTypeSubstitution() != null) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(WHERE_PROPERTY);
        ph.setLeftValue(this.entityView != null ? this.entityView.getWhere() : "");
        ph.setRightValue(this.tableView != null ? this.tableView.getWhere() : "");
        if (this.entityView != null && this.tableView != null && !this.entityView.getWhere().equals(this.tableView.getWhere())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(HAVING_PROPERTY);
        ph.setLeftValue(this.entityView != null ? this.entityView.getHaving() : "");
        ph.setRightValue(this.tableView != null ? this.tableView.getHaving() : "");
        if (this.entityView != null && this.tableView != null && !this.entityView.getHaving().equals(this.tableView.getHaving())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(USER_DEFINED_DQL);
        ph.setLeftValue(this.entityView != null ? this.entityView.getUserDefinedSQL() : "");
        ph.setRightValue(this.tableView != null ? this.tableView.getUserDefinedSQL() : "");
        if (this.entityView != null && this.tableView != null && this.entityView.getUserDefined() && this.tableView.getUserDefined()) {
            String leftDef = this.entityView.getUserDefinedSQL();
            String rightDef = this.tableView.getUserDefinedSQL();
            leftDef = leftDef.replaceAll("\"", "").trim();
            rightDef = rightDef.replaceAll("\"", "").trim();
            leftDef = leftDef.replaceAll("\\(", "").trim();
            rightDef = rightDef.replaceAll("\\(", "").trim();
            if (!(leftDef = leftDef.replaceAll("\\)", "").trim()).equalsIgnoreCase(rightDef = rightDef.replaceAll("\\)", "").trim())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
    }

    private void copyPropertiesFromEntityViewToTableView() {
        if (this.entityView != null && this.tableView != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.tableView.setBasedOnStructuredType(this.entityView.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(WHERE_PROPERTY)) {
                    this.tableView.setWhere(this.entityView.getWhere());
                    continue;
                }
                if (ph.getName().equals(HAVING_PROPERTY)) {
                    this.tableView.setHaving(this.entityView.getHaving());
                    continue;
                }
                if (!ph.getName().equals(USER_DEFINED_DQL)) continue;
                this.tableView.setUserDefinedSQL(this.entityView.getUserDefinedSQL());
                this.tableView.setLayoutSQL(this.entityView.getLayoutSQL());
                this.tableView.setParsed(this.entityView.isParsed());
                this.tableView.setIncorrectSQL(this.entityView.isIncorrectSQL());
                this.tableView.setValidSQL(this.entityView.isValidSQL());
            }
        }
    }

    @Override
    protected boolean shouldApplyNametranslation() {
        return false;
    }
}

