/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;

public class ColumnAttributeComparator
extends EngCOPropertiesComparator {
    private Attribute attribute;
    private Column column;

    public ColumnAttributeComparator(Column column, Attribute attribute) {
        super(column, attribute);
        this.attribute = attribute;
        this.column = column;
        this.initPropertiesList();
    }

    public ColumnAttributeComparator(Column column, Attribute attribute, List filters) {
        this(column, attribute);
        this.applyCompareFilter(filters, column.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyScopeFromColumnToAttribute();
        }
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        EngPropertyHolder ph = new EngPropertyHolder(SCOPE);
        Entity engScope = null;
        if (this.attribute != null && this.attribute.getScope() != null) {
            ph.setRightValue(this.attribute.getScope().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.column != null && this.column.getScope() != null) {
            ph.setLeftValue(this.column.getScope().getName());
            engScope = ((Table)this.column.getScope()).getEngEntity();
        } else {
            ph.setLeftValue("");
        }
        if (this.column != null && this.attribute != null && engScope != this.attribute.getScope()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private void copyScopeFromColumnToAttribute() {
        if (this.column != null && this.attribute != null) {
            this.attribute.setTemporaryWriteable(true);
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(SCOPE)) continue;
                if (this.column.getScope() != null && ((Table)this.column.getScope()).getEngEntity() != null) {
                    this.attribute.setScopeId(((Table)this.column.getScope()).getEngEntity().getObjectID());
                    continue;
                }
                this.attribute.setScopeId(null);
            }
            this.attribute.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.column != null ? this.column.getContainerWithKeyObject().getName() + "." + this.column.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.attribute != null ? this.attribute.getContainerWithKeyObject().getName() + "." + this.attribute.getName() : "";
    }
}

