/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.lang.invoke.CallSite;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public class MethodParam
extends DesignObject
implements DataTypeObject {
    private Design design;
    private String size;
    private int precision;
    private int scale;
    private DesignObject type;
    private boolean reference = false;
    private String defaultValue = "";
    private String typeID = "";
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_PRECISION = "precision";
    public static final String PARAM_SIZE = "size";
    private Method method;
    public static String TYPE_NAME = "arg";

    public MethodParam(DesignPart designPart) {
        super(designPart);
        this.design = designPart.getDesign();
    }

    @Override
    public DesignObject getType() {
        if (this.type == null && !"".equalsIgnoreCase(this.typeID)) {
            this.type = this.getDesign().getDesignObject(this.typeID);
            this.typeID = "";
        } else if (this.type == null) {
            this.type = this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.type;
    }

    @Override
    public void setType(DesignObject type) {
        this.type = type;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public String getDataType() {
        DesignObject type = this.getType();
        if (type != null) {
            String fSize = "";
            int fPrecision = 0;
            int fScale = 0;
            Object dtName = "NONE";
            if (type instanceof Domain) {
                dtName = type.getName();
            } else if (type instanceof LogicalDatatype) {
                fSize = this.size;
                fPrecision = this.precision;
                fScale = this.scale;
                dtName = type.getName();
            } else if (type instanceof DistinctType) {
                DistinctType dt = (DistinctType)type;
                if (dt.getLogicalDataType() != null) {
                    fSize = dt.getSize();
                    fPrecision = dt.getPrecision();
                    fScale = dt.getScale();
                    dtName = dt.getLogicalDataType().getName();
                }
            } else if (type instanceof StructuredType) {
                dtName = type.getName();
                if (this.isReference()) {
                    dtName = "REF " + (String)dtName;
                }
            } else if (type instanceof CollectionType) {
                dtName = type.getName();
            }
            StringBuffer logical = new StringBuffer((String)dtName);
            boolean needBracket = false;
            boolean needComma = false;
            if (fSize != null && !fSize.equals("") || fPrecision > 0 || fScale > 0) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append('(');
            }
            if (fSize != null && !fSize.equals("")) {
                logical.append(fSize);
                needComma = true;
            }
            if (fPrecision > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fPrecision);
                needComma = true;
            }
            if (fScale > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fScale);
            }
            if (needBracket) {
                logical.append(')');
            }
            return logical.toString();
        }
        return "NONE";
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setSize(String size) {
        this.size = size;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public void copy(DesignObject desObject) {
        MethodParam targetParam = (MethodParam)desObject;
        super.copy(desObject);
        this.copyDataType(targetParam);
        targetParam.setDefaultValue(this.getDefaultValue());
    }

    public void copyDataType(MethodParam param) {
        Design targetDesign = param.getDesign();
        DesignObject targetDT = null;
        DesignObject sourceDT = this.getType();
        if (sourceDT instanceof Domain) {
            targetDT = targetDesign.getDesignObject(sourceDT.getObjectID());
            if (!(targetDT instanceof Domain)) {
                targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDomainSet(), sourceDT);
            }
            if (targetDT == null) {
                sourceDT = ((Domain)sourceDT).getLogicalDatatype();
            }
        }
        if (targetDT == null) {
            if (sourceDT instanceof LogicalDatatype) {
                targetDT = targetDesign.getLogicalDatatypeSet().getByName(sourceDT.getName());
            } else if (sourceDT instanceof StructuredType) {
                targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDataTypesDesign().getStructuredTypeSet(), sourceDT);
            } else if (sourceDT instanceof CollectionType) {
                targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDataTypesDesign().getCollectionTypeSet(), sourceDT);
            } else if (sourceDT instanceof DistinctType) {
                targetDT = CompareModelToModel.getCorrespondingObject(targetDesign.getDataTypesDesign().getDistinctTypeSet(), sourceDT);
            }
        }
        param.setDefaultValue(this.getDefaultValue());
        param.setName(this.getName());
        param.setType(targetDT);
        param.setSize(this.getSize());
        param.setPrecision(this.getPrecision());
        param.setScale(this.getScale());
        param.setReference(this.isReference());
    }

    @Override
    public String toString() {
        return this.getDataType();
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "arg";
    }

    @Override
    public void remove() {
        this.method.removeParameter(this);
        super.remove();
    }

    @Override
    public boolean isReference() {
        return this.reference;
    }

    @Override
    public void setReference(boolean reference) {
        this.reference = reference;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public String getDataType(String rdbmsName) {
        if (this.getType() != null) {
            String fSize = "";
            int fPrecision = 0;
            int fScale = 0;
            Object dtName = "NONE";
            if (this.getType() instanceof Domain) {
                Domain dom = (Domain)this.getType();
                LogicalDatatype logicalDatatype = dom.getLogicalDatatype();
                TreeMap<String, CallSite> map = new TreeMap<String, CallSite>();
                if (rdbmsName.toUpperCase().indexOf("ORACLE") == -1) {
                    map.put(PARAM_SIZE, (CallSite)((Object)dom.getSize()));
                    map.put(PARAM_PRECISION, (CallSite)((Object)dom.getPrecision()));
                    map.put(PARAM_SCALE, (CallSite)((Object)dom.getScale()));
                }
                dtName = logicalDatatype.createDataType(rdbmsName, map).toString();
            } else {
                if (this.getType() instanceof LogicalDatatype) {
                    fSize = this.size;
                    fPrecision = this.precision;
                    fScale = this.scale;
                    TreeMap<String, CallSite> map = new TreeMap<String, CallSite>();
                    if (rdbmsName.toUpperCase().indexOf("ORACLE") == -1) {
                        map.put(PARAM_SIZE, (CallSite)((Object)fSize));
                        map.put(PARAM_PRECISION, (CallSite)((Object)("" + this.precision)));
                        map.put(PARAM_SCALE, (CallSite)((Object)("" + this.scale)));
                    }
                    dtName = ((LogicalDatatype)this.getType()).createDataType(rdbmsName, map).toString();
                    return dtName;
                }
                if (this.getType() instanceof DistinctType) {
                    DistinctType dt = (DistinctType)this.getType();
                    if (dt.getLogicalDataType() != null) {
                        try {
                            fSize = dt.getSize();
                        }
                        catch (NumberFormatException logicalDatatype) {
                            // empty catch block
                        }
                        fPrecision = dt.getPrecision();
                        fScale = dt.getScale();
                        dtName = dt.getLogicalDataType().getName();
                    }
                } else if (this.getType() instanceof StructuredType) {
                    dtName = this.isReference() ? "REF " + this.getType().getName() : this.getType().getName();
                } else if (this.getType() instanceof CollectionType) {
                    dtName = this.getType().getName();
                }
            }
            StringBuffer logical = new StringBuffer((String)dtName);
            boolean needBracket = false;
            boolean needComma = false;
            if (!fSize.equals("") || fPrecision > 0 || fScale > 0) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append('(');
            }
            if (!fSize.equals("")) {
                logical.append(fSize);
                needComma = true;
            }
            if (fPrecision > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fPrecision);
                needComma = true;
            }
            if (fScale > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fScale);
            }
            if (needBracket) {
                logical.append(')');
            }
            return logical.toString();
        }
        return "NONE";
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignObject object = null;
        object = this.getDesign().getDesignObject(id);
        if (object != null) {
            return object;
        }
        if ("type".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getLogicalDatatypeSet().getObjectByID(id);
            if (object != null) {
                return object;
            }
            object = this.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public String getTypeID() {
        if (this.type != null) {
            return this.type.getObjectID();
        }
        return this.typeID;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public String getLongName() {
        if (this.method != null && this.method.getStructuredType() != null) {
            StringBuffer sb = new StringBuffer(this.method.getStructuredType().getName());
            sb.append('.').append(this.method.getName()).append('.').append(this.getName());
            return sb.toString();
        }
        return super.getLongName();
    }
}

