/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;

public class AbstractDTObject
extends DesignObject {
    Collection allViews = new ArrayList();
    private List relationConnections = new ArrayList();
    private boolean predefined = false;
    private boolean isNullInstance = false;

    public AbstractDTObject(DesignPart designPart) {
        super(designPart);
        this.addObjectListener((DataTypesDesign)this.getDesignPart());
    }

    void add(DTRelation.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(null);
    }

    void remove(DTRelation.Connection connection) {
        this.relationConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(null);
    }

    public DTRelation.Connection[] getAllLinks() {
        return (DTRelation.Connection[])this.relationConnections.toArray(DTRelation.CONNECTION_PROTO_ARRAY);
    }

    public void removeLinks() {
        for (int i = this.relationConnections.size() - 1; i >= 0; --i) {
            TVDTRelation tv;
            DTRelation.Connection c;
            DTRelation dtRelation;
            if (this.relationConnections.size() <= 0 || (dtRelation = (c = (DTRelation.Connection)this.relationConnections.get(i)).getDTRelation()) == null) continue;
            if (dtRelation.getSource() != null) {
                dtRelation.getSource().remove(c);
            }
            if (dtRelation.getTargetDTObject() != null) {
                dtRelation.getTargetDTObject().remove(c);
            }
            if ((tv = (TVDTRelation)dtRelation.getTopView()) == null) continue;
            tv.remove();
        }
    }

    @Override
    public void remove() {
        this.removeLinks();
        this.removeAllViews();
        super.remove();
    }

    @Override
    public void setTopView(TopView tv) {
        this.addTopView(tv);
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (!views.contains(view)) {
            views.add(view);
            this.addObjectListener(view);
        }
    }

    @Override
    public TopView getTopView() {
        Iterator it;
        TopViewCollection tvc;
        if (!this.allViews.isEmpty() && !(tvc = (TopViewCollection)(it = this.allViews.iterator()).next()).isEmpty()) {
            Iterator it2 = tvc.iterator();
            return (TopView)it2.next();
        }
        return null;
    }

    @Override
    public TopView getTopViewByID(DesignPartView dpv, String id, int viewnumber) {
        if (id != null) {
            Collection tvc = this.getAllViews(dpv);
            for (TopView tv : tvc) {
                if (!id.equalsIgnoreCase(tv.getViewID())) continue;
                return tv;
            }
            int i = 0;
            for (TopView tv : tvc) {
                if (viewnumber == i) {
                    tv.setViewNumber(viewnumber);
                    return tv;
                }
                ++i;
            }
        }
        return null;
    }

    public Collection getAllViews(DesignPartView dpv) {
        ArrayList vs = new ArrayList();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (views.size() > 0) {
            Iterator it = views.iterator();
            while (it.hasNext()) {
                vs.add(it.next());
            }
        }
        return vs;
    }

    @Override
    public Collection getAffectedDPVs() {
        HashSet<DesignPartView> col = new HashSet<DesignPartView>();
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.dpv == null || tvc.size() <= 0) continue;
            col.add(tvc.dpv);
        }
        return col;
    }

    public TopView getTopViewByID(String id) {
        TopViewCollection tvc2 = null;
        for (TopViewCollection tvc2 : this.allViews) {
            for (TopView tv : tvc2) {
                if (!id.equalsIgnoreCase(tv.getViewID())) continue;
                return tv;
            }
        }
        return this.getTopView();
    }

    public void removeAllViews() {
        TopViewCollection[] tvcar = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < tvcar.length; ++i) {
            DesignPartView dpv = tvcar[i].getDPV();
            dpv.getWorkSpace().removeDTObject(this);
            TopView[] tvar = tvcar[i].toArray(new TopView[0]);
            for (int j = 0; j < tvar.length; ++j) {
                dpv.unregisterFromTreemodel(tvar[j]);
                this.removeTopView(tvar[j]);
            }
        }
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView dpv) {
        TopViewCollection tvc2;
        for (TopViewCollection tvc2 : this.allViews) {
            if (tvc2.getDPV() != dpv) continue;
            return tvc2;
        }
        tvc2 = new TopViewCollection();
        tvc2.setDPV(dpv);
        this.allViews.add(tvc2);
        return tvc2;
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection tvc : this.allViews) {
            for (TopView tv : tvc) {
                tv.setViewNumber(this.getViewNumber(tv));
            }
        }
    }

    public TopView getAnotherView(TopView tv) {
        DesignPartView dpv = tv.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        for (TopView v : views) {
            if (v == tv) continue;
            return v;
        }
        return null;
    }

    @Override
    public int getTopViewsCount() {
        int count = 0;
        for (TopViewCollection tvc : this.allViews) {
            count += tvc.size();
        }
        return count;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            return tvc.size();
        }
        return 0;
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            if (tvc.size() > 0) {
                return (TopView)tvc.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public void removeViewSynonim(TopView tv) {
        this.removeTopView(tv);
    }

    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (dpv == this.getDesignPart().getMainView()) {
            if (views.size() > 1) {
                views.remove(view);
            }
        } else {
            views.remove(view);
        }
        if (views.size() == 0) {
            this.allViews.remove(views);
        }
        this.removeObjectListener(view);
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setPredefined(boolean predefined) {
        if (this.predefined != predefined) {
            this.predefined = predefined;
            this.fireChange(ObjectChangeEvent.PREDEFINED_STATUS_CHANGED);
        }
    }

    public boolean isNullInstance() {
        return this.isNullInstance;
    }

    public void setIsNullInstance(boolean value) {
        this.isNullInstance = value;
    }

    public List getAllViewsWithCellViews() {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (TopViewCollection tvc : this.allViews) {
            for (TopView tv : tvc) {
                if (tv.getCellView() == null) continue;
                list.add(tv);
            }
        }
        return list;
    }
}

