/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.ArrayList;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;

public class UserComparatorOracle
extends StoragePropertiesComparator {
    public static final String AUTHENTICATION = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.Authentication");
    public static final String IDENTIFIER = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.Identifier");
    public static final String TABLESPACE = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.TableSpace");
    public static final String TEMP_TABLESPACE = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.TempTableSpace");
    public static final String TEMP_TABLESPACE_GROUP = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.TempTSGroup");
    public static final String PROFILE = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.Profile");
    public static final String PASSWORD_EXPIRE = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.PasswordExpire");
    public static final String ACCOUNT_LOCK = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.AccountLock");
    public static final String EXTERNAL_NAME = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.ExternalName");
    public static final String IMPLEMENTS_SCHEMA = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.ImplementsSchema");
    public static final String ROLES = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.Roles");
    public static final String ROLES_WITH_ADMIN = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.RolesAdmin");
    public static final String PRIVILEGES = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.SystemPrivileges");
    public static final String PRIVILEGES_WITH_ADMIN = UserComparatorOracle.getPropertyNameOracle("UserPropertyDialogOracle.PrivilegesAdmin");
    private UserOracle sourceUser;
    private UserOracle targetUser;

    public UserComparatorOracle(UserOracle sourceUser, UserOracle targetUser) {
        super(sourceUser, targetUser);
        this.sourceUser = sourceUser;
        this.targetUser = targetUser;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(AUTHENTICATION, "authType");
        this.initProperty(TABLESPACE, "defTableSpace");
        this.initProperty(TEMP_TABLESPACE, "temptableSpace");
        if (this.sourceUser instanceof UserOraclev10g || this.targetUser instanceof UserOraclev10g) {
            this.initProperty(TEMP_TABLESPACE_GROUP, "temptSGroupName");
        }
        this.initProperty(PROFILE, "profile");
        this.initProperty(PASSWORD_EXPIRE, "passwordExpire");
        this.initProperty(ACCOUNT_LOCK, "accountLock");
        this.initProperty(EXTERNAL_NAME, "externalName");
        this.initProperty(IMPLEMENTS_SCHEMA, "schemaObject");
        this.initProperty(PRIVILEGES, this.getPrivileges(this.sourceUser), this.getPrivileges(this.targetUser), "privileges");
        this.initProperty(PRIVILEGES_WITH_ADMIN, this.getPrivilegesWithAdmin(this.sourceUser), this.getPrivilegesWithAdmin(this.targetUser), "privilegesWithAdminOption");
        this.initProperty(ROLES, this.getRoles(this.sourceUser), this.getRoles(this.targetUser), "roles");
        this.initProperty(ROLES_WITH_ADMIN, this.getRolesWithAdmin(this.sourceUser), this.getRolesWithAdmin(this.targetUser), "rolesWithAdminOption");
    }

    private String getPrivileges(UserOracle user) {
        UserOracle.InlineList privList;
        if (user != null && (privList = user.getPrivilegesSet()).size() > 0) {
            return this.listToString(privList);
        }
        return "";
    }

    private String getPrivilegesWithAdmin(UserOracle user) {
        UserOracle.InlineList privList;
        if (user != null && (privList = user.getPrivilegesWithAdminOptionSet()).size() > 0) {
            return this.listToString(privList);
        }
        return "";
    }

    private String getRoles(UserOracle user) {
        UserOracle.InlineList roleIdList;
        if (user != null && (roleIdList = user.getRolesSet()).size() > 0) {
            ArrayList<String> roleNameList = new ArrayList<String>(roleIdList.size());
            StorageDesignOracle sd = (StorageDesignOracle)user.getStorageDesign();
            for (String roleId : roleIdList) {
                ModelIDObject role = sd.getRoleSet().getObjectByID(roleId);
                if (role == null) continue;
                roleNameList.add(role.getName());
            }
            return this.listToString(roleNameList);
        }
        return "";
    }

    private String getRolesWithAdmin(UserOracle user) {
        UserOracle.InlineList roleIdList;
        if (user != null && (roleIdList = user.getRolesWithAdminOptionSet()).size() > 0) {
            ArrayList<String> roleNameList = new ArrayList<String>(roleIdList.size());
            StorageDesignOracle sd = (StorageDesignOracle)user.getStorageDesign();
            for (String roleId : roleIdList) {
                ModelIDObject role = sd.getRoleSet().getObjectByID(roleId);
                if (role == null) continue;
                roleNameList.add(role.getName());
            }
            return this.listToString(roleNameList);
        }
        return "";
    }
}

