/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ColumnComparatorOracle;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;

public class CSSBAlterColumnOraclev10g
extends AbstractCSSBOraclev10g {
    private Column sourceColumn;
    private Table sourceTable;
    private SSBAutoIncrementColumnOracle targetSSBAutoIncCol = null;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        this.sourceColumn = (Column)obj.getObject();
        this.sourceTable = (Table)this.sourceColumn.getContainer();
        if (this.sourceTable != null) {
            Design design = this.sourceTable.getDesign();
            RDBMSSite site = this.sourceTable.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, this.sourceTable);
            if (obj.canBeCreate()) {
                this.appendAddColumn(oldbuffer, obj, this.sourceColumn, this.sourceTable, prettyPrint);
            } else {
                this.appendModifyColumn(oldbuffer, obj, tobj, prettyPrint);
            }
        }
    }

    public static boolean isNotSkipColumnFromObjectTable(TableProxy tp, Map propMap) {
        Table table = (Table)tp.getObject();
        if (table.isBST()) {
            int count = 0;
            if (propMap.containsKey(PropertiesComparator.NAME)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.DATA_TYPE)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.COMPUTED)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.FORMULA_DESC)) {
                ++count;
            }
            if (propMap.size() > count) {
                return false;
            }
        }
        return true;
    }

    private void dropAndAddNNC(StringBuffer oldbuffer, String tableName, Column sourceColumn, ColumnProxyOracle columnProxy, Column targetColumn, ColumnProxyOracle targetColumnProxy, boolean prettyPrint, Map propMap) {
        boolean ora12 = targetColumnProxy.getStorageDesign() instanceof StorageDesignOraclev12c;
        String constr = this.storageDesign.getFormatedName(targetColumn.getNotNullConstraintName());
        String cname = this.storageDesign.getFormatedName(targetColumn);
        StringBuffer buffer = new StringBuffer();
        String def = targetColumn.getDefaultValue();
        if (ora12 && targetColumn.isDefaultOnNull() && def != null && !def.isEmpty()) {
            String dt = targetColumn.getDatatypeString(this.storageDesign.getRDBMSType().getName());
            String df = this.addQuotesToDefault(dt, def);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER TABLE " + tableName + " MODIFY " + cname + " DEFAULT " + df);
        } else {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER TABLE " + tableName + " MODIFY " + cname + " NULL");
        }
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementAlterTable();
        this.addNNC(oldbuffer, tableName, sourceColumn, columnProxy, targetColumn, targetColumnProxy, prettyPrint, propMap);
    }

    private void addNNC(StringBuffer oldbuffer, String tableName, Column sourceColumn, ColumnProxyOracle columnProxy, Column targetColumn, ColumnProxyOracle targetColumnProxy, boolean prettyPrint, Map propMap) {
        String constr = this.storageDesign.getFormatedName(sourceColumn.getNotNullConstraintName());
        StringBuffer buffer = new StringBuffer();
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        if (!sourceColumn.getNullsAllowed()) {
            String snnc = sourceColumn.getNotNullConstraintName();
            if (snnc != null && !snnc.isEmpty()) {
                CSSBAlterColumnOraclev10g.appendString(buffer, ' ');
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, snnc);
            }
            CSSBAlterColumnOraclev10g.appendString(buffer, ' ');
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
            this.appendNNCStatusOptions(buffer, columnProxy, targetColumnProxy, propMap);
        } else {
            this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.MANDATORY));
        }
        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CDDLFileMaker.incrementAlterTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void appendModifyColumn(StringBuffer oldbuffer, CompareObjectSelection obj, CompareObjectSelection tobj, boolean prettyPrint) {
        tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(this.sourceTable.getObjectID());
        propMap = this.getPropertiesMap(obj);
        this.addPhysicalPropertiesNNC(obj, propMap);
        if (tableProxy != null && !propMap.isEmpty() && CSSBAlterColumnOraclev10g.isNotSkipColumnFromObjectTable(tableProxy, propMap)) {
            tableName = this.getTableName(obj);
            col = (Column)obj.getObject();
            buffer = new StringBuffer();
            columnProxy = (ColumnProxyOraclev10g)obj.getProxy();
            targetColumn = (Column)tobj.getObject();
            targetColumnProxy = (ColumnProxyOracle)tobj.getProxy();
            if (propMap.containsKey(PropertiesComparator.NAME) && !this.sourceTable.isBST()) {
                if (targetColumn.getTable().isOnPrebuiltTable() && (propsComp = (tableSel = (CompareObjectSelection)((CompareObjectSelection)tobj.getParent()).getParent()).getPropertiesComparator()) instanceof TableComparator && !((TableComparator)propsComp).isSnapshotDropped()) {
                    dropbuffer = new StringBuffer();
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(dropbuffer, "DROP");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(dropbuffer, "MATERIALIZED");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(dropbuffer, "VIEW");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(dropbuffer, this.storageDesign.getFormatedLongNameDDL(tableSel.getProxy()));
                    advancedComment = dropbuffer.toString();
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(dropbuffer, "PRESERVE TABLE");
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CSSBAlterColumnOraclev10g.appendNewLine(dropbuffer, prettyPrint, 0);
                    CSSBAlterColumnOraclev10g.appendLineFinisher(dropbuffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CDDLFileMaker.incrementDropSnapshot();
                    ((TableComparator)propsComp).setSnapshotDropped(true);
                }
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                this.appendRenameColumn(oldbuffer, obj, tobj, prettyPrint);
            }
            if (propMap.containsKey(PropertiesComparator.COMMENT_IN_RDBMS) && this.storageDesign.getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(oldbuffer, tableName, obj, columnProxy, prettyPrint);
            }
            updateVirtualColDef = columnProxy.isVirtual() != false && (propMap.containsKey(PropertiesComparator.FORMULA_DESC) != false || propMap.containsKey(PropertiesComparator.COMPUTED) != false);
            udt = propMap.containsKey(PropertiesComparator.DATA_TYPE);
            umand = propMap.containsKey(PropertiesComparator.MANDATORY);
            unnc = propMap.containsKey(PropertiesComparator.NNC_NAME);
            udef = propMap.containsKey(PropertiesComparator.DEFAULT_VALUE);
            udefon = propMap.containsKey(ColumnComparator.DEFAULT_ON_NULL);
            renamed = false;
            nncStatus = this.hasColumnNNCCStatushanges(propMap);
            nncdefer = propMap.containsKey(ColumnComparatorOracle.NOT_NULL_DEFERRABLE);
            ident = (Boolean)propMap.get(PropertiesComparator.IDENTITY_COLUMN);
            if (nncStatus && !umand && !col.isMandatory()) {
                nncStatus = false;
            }
            if (ident != null) {
                umand = false;
            }
            if (umand) {
                nncdefer = false;
                nncStatus = false;
            }
            if (nncdefer) {
                unnc = false;
                this.dropAndAddNNC(oldbuffer, tableName, col, columnProxy, targetColumn, targetColumnProxy, prettyPrint, propMap);
                umand = false;
                udefon = false;
                nncStatus = false;
            }
            nncdropped = false;
            if (updateVirtualColDef || udt && !this.sourceTable.isBST() || umand || unnc || nncStatus || udef || udefon) {
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                if (unnc && !umand && this.sourceColumn.isMandatory() && targetColumn.isMandatory()) {
                    nnc = targetColumn.getNotNullConstraintName();
                    snnc = this.sourceColumn.getNotNullConstraintName();
                    if (nnc != null && !"".equals(nnc) && snnc != null && !"".equals(snnc)) {
                        renamed = true;
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                        addvancedComment = buffer.toString() + "RENAME CONSTRAINT " + this.storageDesign.getFormatedName(nnc);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "RENAME");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nnc) + " TO " + this.storageDesign.getFormatedName(snnc));
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    }
                }
                if (udt || updateVirtualColDef || umand || nncStatus || (udef || udefon) && !col.isIdentityColumn() && !columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("IDENTITY_CLAUSE")) {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                    addvancedComment = buffer.toString() + "MODIFY " + this.storageDesign.getFormatedName(columnProxy);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    if (propMap.get(PropertiesComparator.DATA_TYPE) != null && !this.sourceTable.isBST()) {
                        this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.DATA_TYPE));
                    }
                    if (updateVirtualColDef) {
                        this.appendVirtualColumnDefinition(buffer, tableProxy, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
                    } else if ((udef && propMap.get(PropertiesComparator.DEFAULT_VALUE) != null || udefon) && !col.isIdentityColumn() && !columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("IDENTITY_CLAUSE")) {
                        this.appendWithDefaultDefinition(buffer, columnProxy);
                        if (udefon && targetColumn.isDefaultOnNull()) {
                            nncdropped = true;
                        }
                    }
                    if (umand) {
                        if (ident == null) {
                            if (!this.sourceColumn.getNullsAllowed()) {
                                snnc = this.sourceColumn.getNotNullConstraintName();
                                if (unnc && snnc != null && !snnc.isEmpty()) {
                                    CSSBAlterColumnOraclev10g.appendString(buffer, ' ');
                                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, snnc);
                                }
                                CSSBAlterColumnOraclev10g.appendString(buffer, ' ');
                                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
                                this.appendNNCStatusOptions(buffer, columnProxy, targetColumnProxy, propMap);
                                nncStatus = false;
                            } else {
                                this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.MANDATORY));
                            }
                        }
                    } else if (renamed || propMap.get(PropertiesComparator.NNC_NAME) != null) {
                        // empty if block
                    }
                    if (nncStatus) {
                        this.appendNNCStatusOptions(buffer, columnProxy, targetColumnProxy, propMap);
                    }
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                    this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                    CDDLFileMaker.incrementAlterTable();
                    if (nncdropped) {
                        this.addNNC(oldbuffer, tableName, col, columnProxy, targetColumn, targetColumnProxy, prettyPrint, propMap);
                    }
                } else if (udef || udefon) {
                    // empty if block
                }
            }
            this.appendColumnConstraint(oldbuffer, this.sourceColumn, targetColumn, tableName, columnProxy, obj, prettyPrint);
            if (propMap.containsKey(PropertiesComparator.IDENTITY_COLUMN)) {
                oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (((Boolean)propMap.get(PropertiesComparator.IDENTITY_COLUMN)).booleanValue()) {
                        CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        if (targetColumnProxy != null) {
                            CSSBAlterColumnOraclev10g.appendStringWithSpace(oldbuffer, "--ERROR non identity column " + targetColumnProxy.getLongName() + " cannot be set to identity column");
                        }
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(oldbuffer, "--ERROR non identity column  cannot be set to identity column");
                    }
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(targetColumnProxy));
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DROP");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IDENTITY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                    advancedComment = buffer.toString();
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementAlterTable();
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            } else if (this.hasIdentityColumnChanges(buffer, columnProxy, targetColumnProxy, propMap)) {
                this.appendIdentityColumnChanges(buffer, columnProxy, targetColumnProxy, propMap, tableName, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "alter identity colum");
                CDDLFileMaker.incrementAlterTable();
            } else if (propMap.containsKey(PropertiesComparator.AUTO_INCREMENT)) {
                oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (((Boolean)propMap.get(PropertiesComparator.AUTO_INCREMENT)).booleanValue()) {
                        if (this.ssbAutoIncCol == null) {
                            this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                        }
                        this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, this.sourceColumn, prettyPrint);
                    }
                    if (targetColumnProxy == null) ** GOTO lbl240
                    targetStorageDesign = (StorageDesignOracle)targetColumnProxy.getStorageDesign();
                    if (this.targetSSBAutoIncCol == null) {
                        this.targetSSBAutoIncCol = new SSBAutoIncrementColumnOracle(targetStorageDesign);
                    }
                    if ((targetAutoIncDDL = targetColumnProxy.getDDLTypeForAutoIncCol()).equals("TRIGGER")) {
                        this.appendDropTrigger(oldbuffer, targetColumn, prettyPrint);
                    }
                    if (targetAutoIncDDL.equals("DEFAULT_CLAUSE")) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(targetColumnProxy));
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                        advancedComment = buffer.toString();
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, advancedComment);
                        CDDLFileMaker.incrementAlterTable();
                    }
                    if (!targetAutoIncDDL.equals("IDENTITY_CLAUSE")) ** GOTO lbl240
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(targetColumnProxy));
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DROP");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IDENTITY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                    advancedComment = buffer.toString();
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementAlterTable();
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            } else if (propMap.containsKey(PropertiesComparator.SEQUENCE_NAME) || propMap.containsKey(PropertiesComparator.TRIGGER_NAME)) {
                oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (this.ssbAutoIncCol == null) {
                        this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                    }
                    if (targetColumnProxy != null) {
                        targetStorageDesign = (StorageDesignOracle)targetColumnProxy.getStorageDesign();
                        if (this.targetSSBAutoIncCol == null) {
                            this.targetSSBAutoIncCol = new SSBAutoIncrementColumnOracle(targetStorageDesign);
                        }
                        newSequenceName = this.ssbAutoIncCol.generateSequenceName(null, this.sourceColumn, false);
                        sourceAutoIncDDL = columnProxy.getDDLTypeForAutoIncCol();
                        if ((sourceAutoIncDDL.equals("TRIGGER") || sourceAutoIncDDL.equals("DEFAULT_CLAUSE")) && !newSequenceName.equalsIgnoreCase(oldSequenceName = this.targetSSBAutoIncCol.generateSequenceName(null, targetColumn, false))) {
                            newSequenceName = this.ssbAutoIncCol.generateSequenceName(oldbuffer, this.sourceColumn, prettyPrint);
                        }
                        settings = this.storageDesign.getAppView().getSettings();
                        newTriggerName = this.ssbAutoIncCol.generateAutoIncrementObjectName(obj.getChoosedPropertyValue(PropertiesComparator.TRIGGER_NAME), settings.getDefaultOracleTriggerName(), "TRG", this.sourceColumn);
                        if (!newTriggerName.equalsIgnoreCase(oldTriggerName = this.targetSSBAutoIncCol.generateAutoIncrementObjectName(targetColumn.getAutoIncrementTriggerName(), settings.getDefaultOracleTriggerName(), "TRG", targetColumn)) && (targetAutoIncDDL = targetColumnProxy.getDDLTypeForAutoIncCol()).equals("TRIGGER")) {
                            this.appendDropTrigger(oldbuffer, targetColumn, prettyPrint);
                        }
                        if (sourceAutoIncDDL.equals("TRIGGER") && this.sourceColumn.isAutoIncrementGenerateTrigger()) {
                            this.ssbAutoIncCol.appendAutoIncrementTrigger(newTriggerName, newSequenceName, this.sourceColumn, oldbuffer, prettyPrint);
                        }
                    }
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            }
        }
        if (tableProxy != null) {
            this.processPhysicalproperties(oldbuffer, obj, tableProxy, prettyPrint);
        }
    }

    private boolean hasIdentityColumnChanges(StringBuffer buffer, ColumnProxyOracle scolumnProxy, ColumnProxyOracle tcolumnProxy, Map propMap) {
        Column col = tcolumnProxy.getColumn();
        if (!col.isIdentityColumn() && !scolumnProxy.getColumn().isIdentityColumn()) {
            return false;
        }
        return propMap.containsKey(ColumnComparator.START_WITH) || propMap.containsKey(ColumnComparator.INCREMENT_BY) || propMap.containsKey(ColumnComparator.MIN_VALUE) || propMap.containsKey(ColumnComparator.MAX_VALUE) || propMap.containsKey(ColumnComparator.CYCLE) || propMap.containsKey(ColumnComparator.NOCACHE) || propMap.containsKey(ColumnComparator.CACHE) || propMap.containsKey(ColumnComparator.ORDER) || propMap.containsKey(ColumnComparator.CACHE) || propMap.containsKey(ColumnComparator.IDENTITY_GENERATION) || propMap.containsKey(ColumnComparator.DEFAULT_ON_NULL);
    }

    private boolean hasColumnNNCCStatushanges(Map propMap) {
        return propMap.containsKey(ColumnComparatorOracle.NOT_NULL_VALIDATE) || propMap.containsKey(ColumnComparatorOracle.NOT_NULL_ENABLE) || propMap.containsKey(ColumnComparatorOracle.NOT_NULL_DEFERRABLE) || propMap.containsKey(ColumnComparatorOracle.NOT_NULL_INITIALLY) || propMap.containsKey(ColumnComparatorOracle.NOT_NULL_CONSTRAINT_NAME);
    }

    private void appendNotNullConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable())) {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getNncInitially())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
    }

    protected void appendNNCStatusOptions(StringBuffer buffer, ColumnProxyOracle columnProxy, ColumnProxyOracle targetColProxy, Map propMap) {
        if (propMap.containsKey(ColumnComparatorOracle.NOT_NULL_DEFERRABLE)) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncDeferrable())) {
                if (propMap.containsKey(ColumnComparatorOracle.NOT_NULL_INITIALLY)) {
                    if ("IMMEDIATE".equalsIgnoreCase(columnProxy.getNncInitially())) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                    } else {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                    }
                } else if ("IMMEDIATE".equalsIgnoreCase(targetColProxy.getNncInitially())) {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                } else {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                }
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOT");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            }
        } else if ("YES".equalsIgnoreCase(targetColProxy.getNncDeferrable())) {
            if (propMap.containsKey(ColumnComparatorOracle.NOT_NULL_INITIALLY)) {
                if ("IMMEDIATE".equalsIgnoreCase(columnProxy.getNncInitially())) {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                } else {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                }
            } else if ("IMMEDIATE".equalsIgnoreCase(targetColProxy.getNncInitially())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            }
        } else {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOT");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (propMap.containsKey(ColumnComparatorOracle.NOT_NULL_ENABLE)) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
        } else if ("YES".equalsIgnoreCase(targetColProxy.getNncEnable())) {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ENABLE");
        } else {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DISABLE");
        }
        if (propMap.containsKey(ColumnComparatorOracle.NOT_NULL_VALIDATE)) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else if ("YES".equalsIgnoreCase(targetColProxy.getNncValidate())) {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
        } else {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
        }
    }

    private void appendIdentityColumnChanges(StringBuffer buffer, ColumnProxyOracle scolumnProxy, ColumnProxyOracle tcolumnProxy, Map propMap, String formattedTableName, boolean prettyPrint) {
        Column tcol = tcolumnProxy.getColumn();
        Column scol = scolumnProxy.getColumn();
        if (!tcol.isIdentityColumn() && !scol.isIdentityColumn()) {
            return;
        }
        if ((propMap.containsKey(ColumnComparator.START_WITH) || propMap.containsKey(ColumnComparator.INCREMENT_BY) || propMap.containsKey(ColumnComparator.MIN_VALUE) || propMap.containsKey(ColumnComparator.MAX_VALUE) || propMap.containsKey(ColumnComparator.CYCLE) || propMap.containsKey(ColumnComparator.NOCACHE) || propMap.containsKey(ColumnComparator.CACHE) || propMap.containsKey(ColumnComparator.ORDER) || propMap.containsKey(ColumnComparator.CACHE) || propMap.containsKey(ColumnComparator.IDENTITY_GENERATION) || propMap.containsKey(ColumnComparator.DEFAULT_ON_NULL)) && scol.isIdentityColumn() && !scol.getTable().isBST() && scolumnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("IDENTITY_CLAUSE")) {
            String dt = scol.getDatatypeString(this.storageDesign.getRDBMSType().getName());
            if (dt.toUpperCase().indexOf("CHAR") == -1) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName);
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tcolumnProxy));
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "GENERATED");
                Object value = propMap.get(ColumnComparator.IDENTITY_GENERATION);
                if (value != null) {
                    if (scol.isAutoIncrementGenerateAlways()) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALWAYS");
                    } else {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "BY");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                        if (propMap.containsKey(ColumnComparator.DEFAULT_ON_NULL)) {
                            if (((ColumnProxyOraclev12c)scolumnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ON");
                                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                            }
                        } else if (((ColumnProxyOraclev12c)tcolumnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ON");
                            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                        }
                    }
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "AS");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IDENTITY");
                } else {
                    if (tcol.isAutoIncrementGenerateAlways()) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALWAYS");
                    } else {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "BY");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                        if (propMap.containsKey(ColumnComparator.DEFAULT_ON_NULL)) {
                            if (((ColumnProxyOraclev12c)scolumnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ON");
                                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                            }
                        } else if (((ColumnProxyOraclev12c)tcolumnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ON");
                            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                        }
                    }
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "AS");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IDENTITY");
                }
                this.appendIdentityOptions(buffer, scol, propMap);
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                return;
            }
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "--ERROR : Identity column has to be of type NUMBER");
        }
    }

    protected void appendIdentityOptions(StringBuffer buffer, Column column, Map propMap) {
        if (propMap.containsKey(ColumnComparator.START_WITH) || propMap.containsKey(ColumnComparator.INCREMENT_BY) || propMap.containsKey(ColumnComparator.MIN_VALUE) || propMap.containsKey(ColumnComparator.MAX_VALUE) || propMap.containsKey(ColumnComparator.CYCLE) || propMap.containsKey(ColumnComparator.NOCACHE) || propMap.containsKey(ColumnComparator.CACHE) || propMap.containsKey(ColumnComparator.ORDER) || propMap.containsKey(ColumnComparator.CACHE) || propMap.containsKey(ColumnComparator.IDENTITY_GENERATION) || propMap.containsKey(ColumnComparator.DEFAULT_ON_NULL)) {
            // empty if block
        }
        if (propMap.containsKey(ColumnComparator.START_WITH) && !"".equals(column.getAutoIncrementStartWith())) {
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "START");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "WITH");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, column.getAutoIncrementStartWith());
        }
        int incr = 0;
        Integer incrementBy = column.getAutoIncrementIncrementBy();
        if (incrementBy != null) {
            incr = incrementBy;
        }
        if (propMap.containsKey(ColumnComparator.INCREMENT_BY)) {
            if (incrementBy != null && (incrementBy < 0 || incrementBy > 1)) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INCREMENT");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "BY");
                this.appendStringWithSpace(buffer, incrementBy);
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "INCREMENT");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "BY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "1");
            }
        }
        if (propMap.containsKey(ColumnComparator.MAX_VALUE)) {
            String maxValue = column.getAutoIncrementMaxValue();
            if (maxValue != null && !maxValue.equals("")) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MAXVALUE");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, maxValue);
            } else if (incr > 0) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOMAXVALUE");
            }
        }
        if (propMap.containsKey(ColumnComparator.MIN_VALUE)) {
            String minValue = column.getAutoIncrementMinValue();
            if (minValue != null && !minValue.equals("")) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MINVALUE");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, minValue);
            } else if (incr < 0) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOMINVALUE");
            }
        }
        if (propMap.containsKey(ColumnComparator.CYCLE)) {
            if (column.isAutoIncrementCycle()) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CYCLE");
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOCYCLE");
            }
        }
        if (propMap.containsKey(ColumnComparator.NOCACHE) || propMap.containsKey(ColumnComparator.CACHE)) {
            Integer cacheInteger = column.getAutoIncrementCache();
            if (column.isAutoIncrementDisableCache()) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
            } else if (cacheInteger != null && cacheInteger > 0) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CACHE");
                this.appendStringWithSpace(buffer, cacheInteger);
            }
        }
        if (propMap.containsKey(ColumnComparator.ORDER)) {
            if (column.isAutoIncrementOrder()) {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ORDER");
            } else {
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NOORDER");
            }
        }
    }

    private void appendDropTrigger(StringBuffer oldbuffer, Column targetColumn, boolean prettyPrint) {
        if (targetColumn.isAutoIncrementGenerateTrigger()) {
            int dotIndex;
            Settings settings = targetColumn.getAppView().getSettings();
            String triggerName = this.targetSSBAutoIncCol.generateAutoIncrementObjectName(targetColumn.getAutoIncrementTriggerName(), settings.getDefaultOracleTriggerName(), "TRG", targetColumn);
            if (!settings.isIncludeSchemaInDDL() && (dotIndex = triggerName.indexOf(46)) > -1) {
                triggerName = triggerName.substring(dotIndex + 1);
            }
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DROP");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TRIGGER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementDropTrigger();
        }
    }

    private void appendCommentOnColumn(StringBuffer oldbuffer, String formattedTableName, CompareObjectSelection columnObj, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        String commentOn = columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnObj.getChoosedPropertyValue(PropertiesComparator.COMMENT_IN_RDBMS);
        if (commentOn.trim().length() > 0) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COMMENT ON");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COLUMN");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName + "." + CSSBAlterColumnOraclev10g.getFormattedSelectedName(columnObj, this.storageDesign));
            String advancedComment = buffer.toString();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IS");
            CSSBAlterColumnOraclev10g.appendString(buffer, '\'');
            CSSBAlterColumnOraclev10g.appendString(buffer, this.replaceSingleQuote(commentOn));
            CSSBAlterColumnOraclev10g.appendString(buffer, '\'');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendColumnConstraint(StringBuffer oldbuffer, Column sourceColumn, Column targetColumn, String tableName, ColumnProxyOracle columnProxy, CompareObjectSelection obj, boolean prettyPrint) {
        boolean add = CSSBCreateRenameTableOraclev10g.isApplyColumnConstraint(obj);
        if (add && sourceColumn.isGenerateConstraintInDDL()) {
            if (!"".equals(targetColumn.getConstraintName())) {
                String constr = this.storageDesign.getFormatedName(targetColumn.getConstraintName());
                StringBuffer buffer = new StringBuffer();
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constr);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD ");
            int len = buffer.length();
            CSSBCreateRenameTableOraclev10g.appendColumnConstraints(buffer, sourceColumn, columnProxy, prettyPrint, obj);
            if (len < buffer.length()) {
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    @Override
    public Map getPropertiesMap(CompareObjectSelection obj) {
        TreeMap<String, Object> propMap = new TreeMap<String, Object>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
            if (!ph.isSelected() || !ph.isModified() || !ph.isDDLHolder() || ph.isExcluded() || ph.isFiltered()) continue;
            if (ph.getName().equals(PropertiesComparator.NAME)) {
                propMap.put(PropertiesComparator.NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DATA_TYPE)) {
                propMap.put(PropertiesComparator.DATA_TYPE, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.MANDATORY)) {
                if (!Boolean.parseBoolean(ph.getLeftValue())) {
                    propMap.put(PropertiesComparator.MANDATORY, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.MANDATORY, "NOT NULL");
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.NNC_NAME)) {
                propMap.put(PropertiesComparator.NNC_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DEFAULT_VALUE)) {
                String def = ph.getLeftValue();
                if ("".equals(def.trim())) {
                    propMap.put(PropertiesComparator.DEFAULT_VALUE, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.DEFAULT_VALUE, def);
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS)) {
                propMap.put(PropertiesComparator.COMMENT_IN_RDBMS, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.RANGE_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.LOV_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.COMPUTED)) {
                propMap.put(PropertiesComparator.COMPUTED, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.FORMULA_DESC)) {
                propMap.put(PropertiesComparator.FORMULA_DESC, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.AUTO_INCREMENT)) {
                propMap.put(PropertiesComparator.AUTO_INCREMENT, Boolean.valueOf(ph.getLeftValue()));
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.IDENTITY_COLUMN)) {
                propMap.put(PropertiesComparator.IDENTITY_COLUMN, Boolean.valueOf(ph.getLeftValue()));
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.SEQUENCE_NAME)) {
                propMap.put(PropertiesComparator.SEQUENCE_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.TRIGGER_NAME)) {
                propMap.put(PropertiesComparator.TRIGGER_NAME, ph.getLeftValue());
                continue;
            }
            propMap.put(ph.getName(), ph.getLeftValue());
        }
        return propMap;
    }

    public void addPhysicalPropertiesNNC(CompareObjectSelection obj, Map map) {
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPhysicalPropertiesList()) {
            if (!ph.isSelected()) continue;
            if (ph.getName().equals(ColumnComparatorOracle.NOT_NULL_VALIDATE)) {
                map.put(ColumnComparatorOracle.NOT_NULL_VALIDATE, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(ColumnComparatorOracle.NOT_NULL_ENABLE)) {
                map.put(ColumnComparatorOracle.NOT_NULL_ENABLE, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(ColumnComparatorOracle.NOT_NULL_DEFERRABLE)) {
                map.put(ColumnComparatorOracle.NOT_NULL_DEFERRABLE, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(ColumnComparatorOracle.NOT_NULL_INITIALLY)) {
                map.put(ColumnComparatorOracle.NOT_NULL_INITIALLY, ph.getLeftValue());
                continue;
            }
            if (!ph.getName().equals(ColumnComparatorOracle.NOT_NULL_CONSTRAINT_NAME)) continue;
            map.put(ColumnComparatorOracle.NOT_NULL_CONSTRAINT_NAME, ph.getLeftValue());
        }
    }

    private void appendRenameColumn(StringBuffer oldbuffer, CompareObjectSelection sobj, CompareObjectSelection tobj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.getTableName(sobj));
        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "RENAME");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COLUMN");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tobj.getObject()));
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TO");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sobj.getObject()));
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementAlterTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddColumn(StringBuffer oldbuffer, CompareObjectSelection obj, Column column, Table table, boolean prettyPrint) {
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null) {
            RelationalObjectProxy proxy;
            ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
            if (column.isAutoIncrementColumn()) {
                this.appendAutoIncrementSequence(oldbuffer, column, prettyPrint);
            }
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            String formattedTableName = this.getTableName(obj);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD");
            String advancedComment = buffer.toString() + this.storageDesign.getFormatedName(columnProxy);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendSpace(buffer);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            Object datatypeString = "";
            Datatype datatype = column.getDataType();
            if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (proxy = this.storageDesign.getProxy(datatype)) != null) {
                datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                if (column.isReference() && datatype instanceof StructuredType) {
                    datatypeString = "REF " + (String)datatypeString;
                }
            }
            if (((String)datatypeString).equals("") && ((String)(datatypeString = column.getDatatypeString("Oracle Database 10g"))).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                datatypeString = (String)datatypeString + " (4000)";
            }
            this.appendDatatype(buffer, (String)datatypeString, columnProxy, prettyPrint);
            if (tableProxy != null) {
                this.appendColumnOptions(buffer, tableProxy, column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, true, prettyPrint);
                LobStorageOracle ls = tableProxy.getLobStorageForColumn(columnProxy.getName());
                if (ls != null) {
                    CSSBCreateTableOraclev10g.appendLobStorage(buffer, ls, tableProxy, prettyPrint);
                }
            }
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
            } else if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                } else {
                    this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                }
            } else if (datatype instanceof StructuredType) {
                this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            this.appendOutOfLineConstraint(oldbuffer, column, columnProxy, formattedTableName, prettyPrint);
            this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            if (this.storageDesign.getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(oldbuffer, formattedTableName, obj, columnProxy, prettyPrint);
            }
            if (column.isAutoIncrementColumn()) {
                DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (this.ssbAutoIncCol == null) {
                        this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                    }
                    this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            }
        }
    }

    private void appendOutOfLineConstraint(StringBuffer oldbuffer, Column column, ColumnProxyOracle columnProxy, String formattedTableName, boolean prettyPrint) {
        String text;
        if (column.isGenerateConstraintInDDL() && !column.getAppView().getSettings().isGenerateInlineColumnCC() && !"".equals(text = column.getConstraintsText(columnProxy.getStorageDesign().getFormatedName(columnProxy), columnProxy.getStorageDesign().getRDBMSType()))) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD");
            String cname = column.getConstraintName();
            if (cname.length() > columnProxy.getMaxNameLength() || cname.toUpperCase().startsWith("SYS_")) {
                cname = "";
            }
            if (cname.length() > 0) {
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedName(cname));
            }
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CHECK");
            CSSBAlterColumnOraclev10g.appendString(buffer, '(');
            CSSBAlterColumnOraclev10g.appendString(buffer, text);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateTableOraclev10g.appendConstraintState(buffer, columnProxy, prettyPrint);
            String advancedComments = "Alter Table " + formattedTableName + " Add Constraint " + cname;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    protected void appendVirtualColumnDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Column;
    }

    public String getTableName(CompareObjectSelection column) {
        CompareObjectSelection table = column.getTableNode();
        if (table != null) {
            return CSSBAlterColumnOraclev10g.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }

    public void processPhysicalproperties(StringBuffer oldbuffer, Object object, TableProxyOraclev10g tp, boolean prettyPrint) {
    }
}

