/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.FKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBFKIndex
extends AbstractCSSBOracle {
    private Map fkMap;
    private StorageDesignOracle storageDesign;
    private boolean isRenamedTable = true;
    private List pkColumns;
    private List fkColumns;

    public CSSBFKIndex(Map fkMap) {
        this.fkMap = fkMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        FKIndexAssociation fkObj = (FKIndexAssociation)obj.getObject();
        FKIndexAssociation tfkObj = (FKIndexAssociation)tobj.getObject();
        if (tfkObj != null && this.fkMap.get(tfkObj.getObjectID()) != null) {
            this.isRenamedTable = true;
            if (obj.isSelected() && tobj.canBeDrop()) return;
            FKContainer targetTable = tfkObj.getTable();
            this.appendRenameFK(oldbuffer, prettyPrint, tfkObj, targetTable, tobj);
            return;
        } else if (fkObj != null) {
            this.isRenamedTable = false;
            FKContainer table = fkObj.getTable();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            KeyObject remoteIndex = fkObj.getRemoteIndex();
            if (remoteIndex != null && this.fkMap.get(remoteIndex.getObjectID()) != null) {
                this.appendFK(oldbuffer, prettyPrint, fkObj, table, obj);
                return;
            } else {
                if (!fkObj.shouldBeMerge() || !table.shouldBeMerge() || !obj.isModified()) return;
                if (!obj.canBeCreate()) {
                    boolean dropAndRecreate = false;
                    String formattedNewName = null;
                    String formattedOldName = null;
                    for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
                        if (!ph.isSelected()) continue;
                        String propertyName = ph.getName();
                        if (propertyName.equals(PropertiesComparator.NAME)) {
                            formattedNewName = this.storageDesign.getFormatedName(obj.getObject());
                            formattedOldName = this.storageDesign.getFormatedName(obj.getCorrespondentNode().getObject());
                            continue;
                        }
                        if (propertyName.equals(PropertiesComparator.COLUMN_ASSOCIATION)) {
                            CompareObjectSelection sourcePkIndObject = this.getPKObjectSelection(obj, fkObj.getKeyObject());
                            if (sourcePkIndObject != null && sourcePkIndObject.isModified() && !sourcePkIndObject.isSelected()) continue;
                            dropAndRecreate = true;
                            continue;
                        }
                        if (!propertyName.equals(PropertiesComparator.REFERRED_COLUMNS) && !propertyName.equals(PropertiesComparator.DELETE_RULE) && !propertyName.equals(PropertiesComparator.TRANSFERABLE)) continue;
                        dropAndRecreate = true;
                    }
                    if (dropAndRecreate) {
                        KeyObject tfkRemoteIndex;
                        if (obj.isSelected() && tfkObj != null && ((tfkRemoteIndex = tfkObj.getRemoteIndex()) == null || this.fkMap.get(tfkRemoteIndex.getObjectID()) == null)) {
                            this.appendDropFK(oldbuffer, fkObj, obj, prettyPrint);
                        }
                    } else {
                        if (formattedNewName == null) return;
                        if (table instanceof TableView) {
                            this.appendDropFK(oldbuffer, fkObj, obj, prettyPrint);
                        } else {
                            this.renameConstraint(oldbuffer, formattedOldName, formattedNewName, obj, prettyPrint);
                            return;
                        }
                    }
                }
                this.appendFK(oldbuffer, prettyPrint, fkObj, table, obj);
            }
            return;
        } else {
            KeyObject remoteIndex;
            if (tfkObj == null || !obj.isSelected() || (remoteIndex = tfkObj.getRemoteIndex()) != null && this.fkMap.get(remoteIndex.getObjectID()) != null) return;
            this.appendDropFK(oldbuffer, tfkObj, obj, prettyPrint);
        }
    }

    private void renameConstraint(StringBuffer oldbuffer, String formattedOldName, String formattedNewName, CompareObjectSelection obj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBFKIndex.appendStringWithSpace(buffer, "ALTER");
        CSSBFKIndex.appendStringWithSpace(buffer, "TABLE");
        CSSBFKIndex.appendStringWithSpace(buffer, this.getTableName(obj));
        String advancedComment = buffer.toString() + "RENAME CONSTRAINT " + formattedOldName;
        CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
        CSSBFKIndex.appendStringWithSpace(buffer, "RENAME");
        CSSBFKIndex.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBFKIndex.appendStringWithSpace(buffer, formattedOldName);
        CSSBFKIndex.appendStringWithSpace(buffer, "TO");
        CSSBFKIndex.appendStringWithSpace(buffer, formattedNewName);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBFKIndex.appendLineFinisher(buffer, prettyPrint);
        CSSBFKIndex.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropFK(StringBuffer oldbuffer, FKIndexAssociation fkObj, CompareObjectSelection obj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        FKContainer table = fkObj.getTable();
        FKIndexAssociation fkModObj = (FKIndexAssociation)obj.getCorrespondentNode().getObject();
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(site, table);
        CSSBFKIndex.appendStringWithSpace(buffer, "ALTER");
        CSSBFKIndex.appendStringWithSpace(buffer, "TABLE");
        CSSBFKIndex.appendStringWithSpace(buffer, this.getTableName(obj));
        CSSBFKIndex.appendStringWithSpace(buffer, "DROP");
        CSSBFKIndex.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBFKIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkModObj));
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBFKIndex.appendNewLine(buffer, prettyPrint, 0);
        CSSBFKIndex.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CDDLFileMaker.incrementAlterTable();
        this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
    }

    private void appendFK(StringBuffer oldbuffer, boolean prettyPrint, FKIndexAssociation fkObj, FKContainer table, CompareObjectSelection obj) {
        this.pkColumns = null;
        StringBuffer buffer = new StringBuffer();
        Object advancedComment = "";
        FKProxyOraclev9i fk = (FKProxyOraclev9i)this.storageDesign.getFKProxySet().getProxy(fkObj.getLocalFKIndex().getObjectID());
        if (fk != null) {
            this.appendComment(oldbuffer, fk);
            CSSBFKIndex.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            CompareObjectSelection tableSelection = (CompareObjectSelection)((CompareObjectSelection)obj.getParent()).getParent();
            CompareObjectSelection sourcePkIndObject = null;
            String remoteTableLongName = null;
            KeyObject localFKIndex = fkObj.getLocalFKIndex();
            KeyObject remoteKey = fkObj.getKeyObject();
            if (remoteKey != null) {
                sourcePkIndObject = this.getPKObjectSelection(obj, remoteKey);
                if (sourcePkIndObject == null) {
                    this.initFKandRefColumns(fkObj);
                } else if (sourcePkIndObject.isSelected() || !sourcePkIndObject.isModified()) {
                    this.initFKandRefColumns(sourcePkIndObject, fkObj);
                }
            } else {
                this.fkColumns = new ArrayList();
                ContainedObject[] fkCols = localFKIndex.getElements();
                for (int i = 0; i < fkCols.length; ++i) {
                    CompareObjectSelection cs = tableSelection.getChildNested(fkCols[i], 2);
                    if (cs == null) continue;
                    this.fkColumns.add(cs);
                }
                remoteTableLongName = fkObj.getReferredTableLongName();
            }
            if (this.pkColumns != null && !this.pkColumns.isEmpty() || remoteTableLongName != null && !remoteTableLongName.isEmpty()) {
                CSSBFKIndex.appendStringWithSpace(buffer, "ALTER");
                CSSBFKIndex.appendStringWithSpace(buffer, "TABLE");
                CSSBFKIndex.appendStringWithSpace(buffer, this.getTableName(obj));
                advancedComment = buffer.toString() + "ADD CONSTRAINT " + this.storageDesign.getFormatedName(fk);
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndex.appendStringWithSpace(buffer, "ADD");
                if (!fk.getName().startsWith("SYS_")) {
                    CSSBFKIndex.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBFKIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                }
                CSSBFKIndex.appendStringWithSpace(buffer, "FOREIGN KEY");
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndex.appendStringWithSpace(buffer, '(');
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                this.appendColumns(buffer, this.fkColumns);
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndex.appendStringWithSpace(buffer, ')');
                this.appendReferences(buffer, fk, prettyPrint);
                this.appendOnDelete(buffer, obj, prettyPrint);
                if (this.isRenamedTable) {
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndex.appendStringWithSpace(buffer, "DEFERRABLE");
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndex.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBFKIndex.appendStringWithSpace(buffer, "DEFERRED");
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndex.appendStringWithSpace(buffer, "NOVALIDATE");
                } else {
                    this.appendConstraintState(buffer, fk, prettyPrint);
                }
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 0);
                CSSBFKIndex.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                CDDLFileMaker.incrementAlterTable();
                if ((fk.getRely().equals("YES") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) && fk.getValidate().equals("NO")) {
                    CSSBFKIndex.appendStringWithSpace(buffer, "ALTER");
                    CSSBFKIndex.appendStringWithSpace(buffer, "TABLE");
                    CSSBFKIndex.appendStringWithSpace(buffer, this.getTableName(obj));
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndex.appendStringWithSpace(buffer, "MODIFY");
                    CSSBFKIndex.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBFKIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                    advancedComment = buffer.toString();
                    if (fk.getRely().equals("YES")) {
                        CSSBFKIndex.appendStringWithSpace(buffer, "RELY");
                    } else {
                        CSSBFKIndex.appendStringWithSpace(buffer, "NORELY");
                    }
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 0);
                    CSSBFKIndex.appendLineFinisher(buffer, prettyPrint);
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                    CDDLFileMaker.incrementAlterTable();
                }
                this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            }
        }
    }

    private void appendColumns(StringBuffer buffer, List fkColumns) {
        Iterator it = fkColumns.iterator();
        boolean first = true;
        while (it.hasNext()) {
            FKElement col = (FKElement)it.next();
            if (!first) {
                CSSBFKIndex.appendString(buffer, ',');
                CSSBFKIndex.appendNewLine(buffer, true, 1);
            }
            CSSBFKIndex.appendString(buffer, ' ');
            if (col != null) {
                CSSBFKIndex.appendString(buffer, this.storageDesign.getFormatedName(col));
            }
            first = false;
        }
    }

    private void appendRenameFK(StringBuffer oldbuffer, boolean prettyPrint, FKIndexAssociation fkObj, FKContainer table, CompareObjectSelection obj) {
        this.pkColumns = null;
        StringBuffer buffer = new StringBuffer();
        Object advancedComment = "";
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(site, table);
        FKProxyOraclev9i fk = (FKProxyOraclev9i)this.storageDesign.getFKProxySet().getProxy(fkObj.getLocalFKIndex().getObjectID());
        if (fk != null) {
            ModelIDObject sFKInd;
            CompareObjectSelection sourcePKIndObj;
            this.appendComment(oldbuffer, fk);
            CSSBFKIndex.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            CompareObjectSelection targetPkIndObject = this.getPKObjectSelection(obj, fkObj.getKeyObject());
            if (targetPkIndObject != null && ((sourcePKIndObj = targetPkIndObject.getCorrespondentNode()).isSelected() || !sourcePKIndObj.isModified()) && (sFKInd = obj.getCorrespondentNode().getObject()) != null) {
                this.initFKandRefColumns(sourcePKIndObj, (FKIndexAssociation)sFKInd);
            }
            if (this.pkColumns != null && this.pkColumns.size() > 0) {
                CSSBFKIndex.appendStringWithSpace(buffer, "ALTER");
                CSSBFKIndex.appendStringWithSpace(buffer, "TABLE");
                CSSBFKIndex.appendStringWithSpace(buffer, this.getTableName(obj));
                String fkName = obj.getCorrespondentNode().isSelected() ? CSSBFKIndex.getFormattedSelectedName(obj, this.storageDesign) : this.storageDesign.getFormatedName(fk);
                advancedComment = buffer.toString() + "ADD CONSTRAINT " + fkName;
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndex.appendStringWithSpace(buffer, "ADD");
                if (!fkName.startsWith("SYS_")) {
                    CSSBFKIndex.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBFKIndex.appendStringWithSpace(buffer, fkName);
                }
                CSSBFKIndex.appendStringWithSpace(buffer, "FOREIGN KEY");
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndex.appendStringWithSpace(buffer, '(');
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                this.appendColumns(buffer, this.fkColumns);
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                CSSBFKIndex.appendStringWithSpace(buffer, ')');
                this.appendReferences(buffer, fk, prettyPrint);
                this.appendOnDelete(buffer, obj, prettyPrint);
                TableProxyOracle targetProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(fk.getFKTable().getObjectID());
                if (this.isRenamedTable && (targetProxy.getBackupOption().equals(TableProxy.NONE) || targetProxy.getRestoreOption().equals(TableProxy.NONE))) {
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndex.appendStringWithSpace(buffer, "DEFERRABLE");
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndex.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBFKIndex.appendStringWithSpace(buffer, "DEFERRED");
                    CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
                    CSSBFKIndex.appendStringWithSpace(buffer, "NOVALIDATE");
                } else {
                    this.appendConstraintState(buffer, fk, prettyPrint);
                }
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                CSSBFKIndex.appendNewLine(buffer, prettyPrint, 0);
                CSSBFKIndex.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComment);
                CDDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            }
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyOraclev9i fk, boolean prettyPrint) {
        boolean refStructType = false;
        CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
        CSSBFKIndex.appendStringWithSpace(buffer, "REFERENCES");
        FKContainer refTable = fk.getFKTable();
        if (refTable == null) {
            CSSBFKIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk.getIndex().getFKAssociation().getFormattedReferredTableLongName()));
        } else {
            ModelIDObject refTableObj = fk.getStorageDesign().getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObj == null) {
                refTableObj = refTable;
            }
            CSSBFKIndex.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObj));
            if (refTable.isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || ((ContainedObjectWithDomain)column).getUse() != 3) continue;
                    refStructType = true;
                }
            }
        }
        if (!refStructType) {
            CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndex.appendStringWithSpace(buffer, '(');
            CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
            if (refTable == null) {
                CSSBFKIndex.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(fk.getIndex().getFKAssociation().getReferredColumnNames()));
            } else {
                this.appendColumns(buffer, this.pkColumns);
            }
            CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndex.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendOnDelete(StringBuffer buffer, CompareObjectSelection obj, boolean prettyPrint) {
        String onDelete = obj.getChoosedPropertyValue(PropertiesComparator.DELETE_RULE);
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            String mandatory = obj.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
            boolean isMandatory = Boolean.parseBoolean(mandatory);
            onDelete = isMandatory ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
            CSSBFKIndex.appendStringWithSpace(buffer, "ON");
            CSSBFKIndex.appendStringWithSpace(buffer, "DELETE");
            CSSBFKIndex.appendStringWithSpace(buffer, onDelete);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            // empty if block
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOraclev9i fk, boolean prettyPrint) {
        CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
        if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
            CSSBFKIndex.appendStringWithSpace(buffer, "NOT");
            CSSBFKIndex.appendStringWithSpace(buffer, "DEFERRABLE");
        } else {
            CSSBFKIndex.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                CSSBFKIndex.appendStringWithSpace(buffer, "INITIALLY");
                CSSBFKIndex.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBFKIndex.appendStringWithSpace(buffer, "INITIALLY");
                CSSBFKIndex.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(fk.getEnable())) {
                CSSBFKIndex.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBFKIndex.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(fk.getValidate())) {
                CSSBFKIndex.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBFKIndex.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                CSSBFKIndex.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    CSSBFKIndex.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                CSSBFKIndex.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (fk.getExceptionsTable() != null) {
            CSSBFKIndex.appendNewLine(buffer, prettyPrint, 1);
            buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof FKIndexAssociation || ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof FKIndexAssociation;
    }

    private void initFKandRefColumns(CompareObjectSelection pkObject, FKIndexAssociation fkIndAss) {
        this.pkColumns = this.getColumnsForRestore(pkObject);
        this.fkColumns = new ArrayList();
        FKContainer fkTable = (FKContainer)fkIndAss.getContainerWithKeyObject();
        for (FKElement pkColumn : this.pkColumns) {
            FKElement fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
            if (fkColumn == null) continue;
            this.fkColumns.add(fkColumn);
        }
    }

    private void initFKandRefColumns(FKIndexAssociation fkIndAss) {
        this.pkColumns = new ArrayList();
        this.fkColumns = new ArrayList();
        if (fkIndAss.getRemoteIndex() != null) {
            this.pkColumns.addAll(fkIndAss.getRemoteIndex().getElementsCollection());
            FKContainer fkTable = (FKContainer)fkIndAss.getContainerWithKeyObject();
            for (FKElement pkColumn : this.pkColumns) {
                FKElement fkColumn = fkTable.getFKColumn(fkIndAss, pkColumn);
                if (fkColumn == null) continue;
                this.fkColumns.add(fkColumn);
            }
        }
    }

    private CompareObjectSelection getPKObjectSelection(CompareObjectSelection object, KeyObject pkIndex) {
        CompareObjectSelection pkIndexObj = null;
        if (pkIndex != null) {
            FKContainer table = (FKContainer)pkIndex.getContainerWithKeyObject();
            CompareObjectSelection fkParent = (CompareObjectSelection)object.getParent();
            CompareObjectSelection rootTables = (CompareObjectSelection)((CompareObjectSelection)fkParent.getParent()).getParent();
            CompareObjectSelection tableObj = rootTables.getChild(table);
            if (tableObj == null) {
                return null;
            }
            CompareObjectSelection pkIndexes = (CompareObjectSelection)tableObj.getChild(2);
            pkIndexObj = pkIndexes.getChild(pkIndex);
        }
        return pkIndexObj;
    }

    private List getColumnsForRestore(CompareObjectSelection object) {
        CompareObjectSelection pkIndexes;
        CompareObjectSelection tableObj;
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        KeyObject pkIndex = (KeyObject)object.getObject();
        if (pkIndex != null && (tableObj = (CompareObjectSelection)(pkIndexes = (CompareObjectSelection)object.getParent()).getParent()) != null) {
            List sourceColumns = tableObj.getChildObjects(0);
            for (FKElement pkCol : pkIndex.getElementsCollection()) {
                for (CompareObjectSelection obj : sourceColumns) {
                    if (pkCol != obj.getObject() || obj.canBeCreate() && !obj.isSelected() || obj.canBeDrop() && obj.getCorrespondentNode().isSelected()) continue;
                    list.add(pkCol);
                }
            }
        }
        return list;
    }

    private String getTableName(CompareObjectSelection index) {
        CompareObjectSelection table = index.getTableNode();
        if (table != null) {
            return CSSBFKIndex.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }
}

