/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBDropType
extends AbstractCSSBOracle {
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        RelationalObjectProxy typeProxy;
        ModelIDObject modelIDObject = ((CompareObjectSelection)object).getCorrespondentNode().getObject();
        ProxyDesignObjectSet proxySet = null;
        StorageDesign storageDesign = modelIDObject.getDesign().getStorageDesign(modelIDObject.getSelectedRDBMSSite());
        if (storageDesign != null) {
            if (modelIDObject instanceof StructuredType) {
                proxySet = storageDesign.getStructuredTypeProxySet();
            } else if (modelIDObject instanceof CollectionType) {
                proxySet = storageDesign.getCollectionTypeProxySet();
            }
        }
        if (proxySet != null && (typeProxy = proxySet.getProxy(modelIDObject.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            this.appendDrop(buffer);
            CSSBDropType.appendStringWithSpace(buffer, "TYPE");
            CSSBDropType.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(typeProxy));
            String advancedComment = buffer.toString();
            CSSBDropType.appendStringWithSpace(buffer, "VALIDATE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBDropType.appendNewLine(buffer, prettyPrint, 0);
            CSSBDropType.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementDropType();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        ModelIDObject modelIDObject = ((CompareObjectSelection)object).getCorrespondentNode().getObject();
        return modelIDObject instanceof StructuredType || modelIDObject instanceof CollectionType;
    }
}

