/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.compare.storage.oracle.MethodParamComparatorOracle;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.MethodParamProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;

public class MethodParamComparator
extends PropertiesComparator {
    private MethodParam source;
    private MethodParam target;
    private StorageDesign sourceSD;
    private StorageDesign targetSD;
    private CompareCWDDesigns selectionObject;

    public MethodParamComparator(MethodParam source, MethodParam target) {
        this(source, target, null, null);
    }

    public MethodParamComparator(MethodParam source, MethodParam target, StorageDesign sourceSD, StorageDesign targetSD) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.sourceSD = sourceSD;
        this.targetSD = targetSD;
        this.initPropertiesList();
        this.initPropertiesFilterList();
        this.initPhysicalPropertiesComparator();
    }

    private void initPhysicalPropertiesComparator() {
        if (this.sourceSD != null && this.targetSD != null) {
            MethodParamProxy MethodParamProxy2;
            MethodParamProxy sourceMethodParamProxy = null;
            if (this.source != null) {
                sourceMethodParamProxy = (MethodParamProxy)this.sourceSD.getStorageObject(this.source.getObjectID());
            }
            MethodParamProxy targetMethodParamProxy = null;
            if (this.target != null) {
                targetMethodParamProxy = (MethodParamProxy)this.targetSD.getStorageObject(this.target.getObjectID());
            }
            MethodParamComparatorOracle physicalComparator = null;
            MethodParamProxy methodParamProxy = MethodParamProxy2 = sourceMethodParamProxy != null ? sourceMethodParamProxy : targetMethodParamProxy;
            if (MethodParamProxy2 instanceof MethodParamProxyOracle) {
                physicalComparator = new MethodParamComparatorOracle(sourceMethodParamProxy, targetMethodParamProxy);
            }
            this.setPhysicalPropertiesComparator(physicalComparator);
        }
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(DATA_TYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? this.source.getDataType() : "");
        ph.setRightValue(this.target != null ? this.target.getDataType() : "");
        if (this.isExcludedFromComparison(DATA_TYPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(DEFAULT_VALUE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? this.source.getDefaultValue() : "");
        ph.setRightValue(this.target != null ? this.target.getDefaultValue() : "");
        if (this.isExcludedFromComparison(DEFAULT_VALUE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.initCommentsAndNotes(false);
        this.initDynamicProperties();
    }

    @Override
    public void copySelectedProperties() {
        if (this.source != null && this.target != null) {
            this.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(DATA_TYPE)) {
                    MergingCWDDesigns.copyDataTypeFromDTO_To_DTO(this.source, this.target);
                    continue;
                }
                if (!ph.getName().equals(DEFAULT_VALUE)) continue;
                this.target.setDefaultValue(this.source.getDefaultValue());
            }
        }
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }
}

