/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.storage.oracle.MethodComparatorOracle;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;

public class MethodComparator
extends PropertiesComparator {
    private Method source;
    private Method target;
    private StorageDesign sourceSD;
    private StorageDesign targetSD;
    private CompareCWDDesigns selectionObject;

    public MethodComparator(Method source, Method target) {
        this(source, target, null, null);
    }

    public MethodComparator(Method source, Method target, StorageDesign sourceSD, StorageDesign targetSD) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.sourceSD = sourceSD;
        this.targetSD = targetSD;
        this.initPropertiesList();
        this.initPropertiesFilterList();
        this.initPhysicalPropertiesComparator();
    }

    private void initPhysicalPropertiesComparator() {
        if (this.sourceSD != null && this.targetSD != null) {
            MethodProxy MethodProxy2;
            MethodProxy sourceMethodProxy = null;
            if (this.source != null) {
                sourceMethodProxy = (MethodProxy)this.sourceSD.getStorageObject(this.source.getObjectID());
            }
            MethodProxy targetMethodProxy = null;
            if (this.target != null) {
                targetMethodProxy = (MethodProxy)this.targetSD.getStorageObject(this.target.getObjectID());
            }
            MethodComparatorOracle physicalComparator = null;
            MethodProxy methodProxy = MethodProxy2 = sourceMethodProxy != null ? sourceMethodProxy : targetMethodProxy;
            if (MethodProxy2 instanceof MethodProxyOracle) {
                physicalComparator = new MethodComparatorOracle(sourceMethodProxy, targetMethodProxy);
            }
            this.setPhysicalPropertiesComparator(physicalComparator);
        }
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(PARAMETER_ORDER);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? this.getParameterNames(this.source) : "");
        ph.setRightValue(this.target != null ? this.getParameterNames(this.target) : "");
        if (this.isExcludedFromComparison(PARAMETER_ORDER)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(RETURN_DATATYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? this.source.getReturnDataType() : "");
        ph.setRightValue(this.target != null ? this.target.getReturnDataType() : "");
        if (this.isExcludedFromComparison(RETURN_DATATYPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(CONSTRUCTOR);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isConstructor()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isConstructor()) : "");
        if (this.isExcludedFromComparison(CONSTRUCTOR)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(OVERRIDING);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isOverriding()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isOverriding()) : "");
        if (this.isExcludedFromComparison(OVERRIDING)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(BODY);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? this.source.getBody() : "");
        ph.setRightValue(this.target != null ? this.target.getBody() : "");
        if (this.isExcludedFromComparison(BODY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.initCommentsAndNotes(false);
        this.initDynamicProperties();
    }

    private String getParameterNames(Method method) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        Iterator it = method.getParameters().iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            MethodParam param = (MethodParam)it.next();
            buffer.append(param.getName());
        }
        return buffer.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copySelectedProperties(null);
    }

    protected void copySelectedProperties(Map objectsMap) {
        if (this.source != null && this.target != null) {
            this.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(PARAMETER_ORDER)) {
                    this.reorderParameters(objectsMap);
                    continue;
                }
                if (ph.getName().equals(RETURN_DATATYPE)) {
                    MethodParam rdt = null;
                    if (!ph.getLeftValue().isEmpty()) {
                        rdt = new MethodParam(this.target.getDesignPart());
                        this.source.getReturnValue().copyDataType(rdt);
                    }
                    this.target.setReturnValue(rdt);
                    continue;
                }
                if (ph.getName().equals(CONSTRUCTOR)) {
                    this.target.setConstructor(this.source.isConstructor());
                    continue;
                }
                if (ph.getName().equals(OVERRIDING)) {
                    this.target.setOverriding(this.source.isOverriding());
                    continue;
                }
                if (!ph.getName().equals(BODY)) continue;
                this.target.setBody(this.source.getBody());
            }
        }
    }

    private void reorderParameters(Map objectsMap) {
        if (objectsMap != null) {
            int targetPos = 0;
            List targetParamList = this.target.getParameters();
            for (MethodParam sourceParam : this.source.getParameters()) {
                int currentPos;
                MethodParam targetParam = (MethodParam)objectsMap.get(sourceParam.getObjectID());
                if (targetParam == null || (currentPos = targetParamList.indexOf(targetParam)) == -1) continue;
                if (currentPos != targetPos) {
                    targetParamList.remove(targetParam);
                    targetParamList.add(targetPos, targetParam);
                }
                ++targetPos;
            }
        }
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }
}

