/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.Collections;
import java.util.Map;
import oracle.dbtools.crest.model.design.compare.COPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;

public class AttributeComparator
extends COPropertiesComparator {
    private Attribute source;
    private Attribute target;
    private Map objectsMap;

    public AttributeComparator(Attribute source, Attribute target) {
        this(source, target, Collections.EMPTY_MAP);
    }

    public AttributeComparator(Attribute source, Attribute target, Map objectsMap) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initDynamicProperties();
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        PropertyHolder ph = new PropertyHolder(SCOPE);
        if (this.target != null && this.target.getScope() != null) {
            ph.setRightValue(this.target.getScope().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.source != null && this.source.getScope() != null) {
            ph.setLeftValue(this.source.getScope().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.isExcludedFromComparison(SCOPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyScopeFromAttributeToAttribute();
    }

    private void copyScopeFromAttributeToAttribute() {
        if (this.source != null && this.target != null) {
            this.target.setTemporaryWriteable(true);
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(SCOPE)) continue;
                if (this.source.getScope() != null) {
                    Entity tTable;
                    Entity sTable = (Entity)this.source.getScope();
                    if (sTable == null || (tTable = (Entity)this.objectsMap.get(sTable.getObjectID())) == null) continue;
                    this.target.setScopeId(tTable.getObjectID());
                    continue;
                }
                this.target.setScopeId(null);
            }
            this.target.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.source != null ? this.source.getContainerWithKeyObject().getName() + "." + this.source.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.target != null ? this.target.getContainerWithKeyObject().getName() + "." + this.target.getName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(NATIVE_DATA_TYPE) || !ph.isSelected()) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    public boolean isDataTypeChanged() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(NATIVE_DATA_TYPE) || !ph.isModified()) continue;
                return true;
            }
        }
        return false;
    }
}

