/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableViewComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.util.string.DMSQLFormatter;

public class TableViewComparator
extends PropertiesComparator {
    private TableView sourceTableView;
    private TableView targetTableView;
    private TableViewProxy sourceTableViewProxy;
    private TableViewProxy targetTableViewProxy;
    private static DMSQLFormatter command;

    public TableViewComparator(TableView sourceView, TableView targetView, TableViewProxy sourceViewProxy, TableViewProxy targetViewProxy, boolean includePhysicalProps) {
        super(sourceView, targetView);
        this.sourceTableView = sourceView;
        this.targetTableView = targetView;
        this.sourceTableViewProxy = sourceViewProxy;
        this.targetTableViewProxy = targetViewProxy;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
        if (includePhysicalProps) {
            this.initPhysicalPropertiesComparator();
        }
    }

    private void initPhysicalPropertiesComparator() {
        TableViewProxy viewProxy;
        TableViewComparatorOracle physicalComparator = null;
        TableViewProxy tableViewProxy = viewProxy = this.sourceTableViewProxy != null ? this.sourceTableViewProxy : this.targetTableViewProxy;
        if (viewProxy instanceof TableViewProxyOracle) {
            physicalComparator = new TableViewComparatorOracle((TableViewProxyOracle)this.sourceTableViewProxy, (TableViewProxyOracle)this.targetTableViewProxy);
        }
        this.setPhysicalPropertiesComparator(physicalComparator);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromTableViewToTableView();
    }

    @Override
    protected void initPropertiesList() {
        List<String> rightAliases;
        int i;
        StringBuffer buffer;
        List<String> leftAliases;
        String rightDef;
        this.initNameProperty();
        if (this.sourceTableViewProxy != null || this.targetTableViewProxy != null) {
            this.initSchemaProperty();
        }
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(STRUCTURED_TYPE);
        String sname = null;
        if (this.sourceTableView != null && this.sourceTableView.getBasedOnStructuredType() != null) {
            sname = this.sourceTableView.getBasedOnStructuredType().getName();
            ph.setLeftValue(sname);
        } else {
            ph.setLeftValue("");
        }
        String tname = null;
        if (this.targetTableView != null && this.targetTableView.getBasedOnStructuredType() != null) {
            tname = this.targetTableView.getBasedOnStructuredType().getName();
            ph.setRightValue(tname);
        } else {
            ph.setRightValue("");
        }
        if (this.isExcludedFromComparison(STRUCTURED_TYPE)) {
            ph.setExcluded(true);
        } else if (sname != null && tname != null) {
            if (!sname.equalsIgnoreCase(tname)) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (sname != tname) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(USER_DEFINED_DQL);
        String leftDef = this.sourceTableView != null ? this.sourceTableView.getUserDefinedSQLAsDDL() : "";
        String string = rightDef = this.targetTableView != null ? this.targetTableView.getUserDefinedSQLAsDDL() : "";
        if (!"".equals(leftDef)) {
            leftDef = leftDef.replaceAll("[\\p{javaWhitespace}]+", " ").trim();
            leftDef = Token.getStringAfterToken(leftDef, "AS").trim();
        }
        if (!"".equals(rightDef)) {
            rightDef = rightDef.replaceAll("[\\p{javaWhitespace}]+", " ").trim();
            rightDef = Token.getStringAfterToken(rightDef, "AS").trim();
        }
        ph.setLeftValue(leftDef);
        ph.setRightValue(rightDef);
        if (this.isExcludedFromComparison(USER_DEFINED_DQL)) {
            ph.setExcluded(true);
        } else if (this.sourceTableView != null && this.targetTableView != null) {
            leftDef = leftDef.replaceAll("\"", "").trim();
            rightDef = rightDef.replaceAll("\"", "").trim();
            leftDef = leftDef.replaceAll("\\(", "").trim();
            rightDef = rightDef.replaceAll("\\(", "").trim();
            if (!(leftDef = leftDef.replaceAll("\\)", "").trim()).equalsIgnoreCase(rightDef = rightDef.replaceAll("\\)", "").trim())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(VIEW_ALIASES);
        String leftVA = "";
        String rightVA = "";
        if (this.sourceTableView != null && !(leftAliases = this.sourceTableView.getHeaderAliases()).isEmpty()) {
            buffer = new StringBuffer();
            for (i = 0; i < leftAliases.size(); ++i) {
                buffer.append(i == 0 ? "" : "\n");
                buffer.append(leftAliases.get(i));
            }
            leftVA = buffer.toString();
        }
        if (this.targetTableView != null && !(rightAliases = this.targetTableView.getHeaderAliases()).isEmpty()) {
            buffer = new StringBuffer();
            for (i = 0; i < rightAliases.size(); ++i) {
                buffer.append(i == 0 ? "" : "\n");
                buffer.append(rightAliases.get(i));
            }
            rightVA = buffer.toString();
        }
        ph.setLeftValue(leftVA);
        ph.setRightValue(rightVA);
        if (this.isExcludedFromComparison(VIEW_ALIASES)) {
            ph.setExcluded(true);
        } else if (this.sourceTableView != null && this.targetTableView != null && !leftVA.equalsIgnoreCase(rightVA)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    public static String formatSQL(TableView view) {
        String sql = view.getUserDefinedSQLAsDDL();
        String dbtype = view.getDesignPart().getSelectedRDBMSType().getName().toUpperCase();
        DMSQLFormatter command = TableViewComparator.getDMSQLFormatter();
        if (dbtype.indexOf("ORACLE") > -1) {
            return command.formatSQL(sql, "Oracle");
        }
        if (dbtype.indexOf("SQL SERVER") > -1) {
            return command.formatSQL(sql, "Microsoft SQL Server");
        }
        if (dbtype.indexOf("DB2") > -1) {
            return command.formatSQL(sql, "DB2");
        }
        return command.formatSQL(sql, "Oracle");
    }

    private void copyPropertiesFromTableViewToTableView() {
        if (this.sourceTableView != null && this.targetTableView != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.targetTableView.setBasedOnStructuredType(this.sourceTableView.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(WHERE_PROPERTY)) {
                    this.targetTableView.setWhere(this.sourceTableView.getWhere());
                    continue;
                }
                if (ph.getName().equals(HAVING_PROPERTY)) {
                    this.targetTableView.setHaving(this.sourceTableView.getHaving());
                    continue;
                }
                if (ph.getName().equals(USER_DEFINED_DQL)) {
                    this.targetTableView.setUserDefinedSQL(this.sourceTableView.getUserDefinedSQL());
                    MergingModels.synchronizeColumnsView(this.sourceTableView, this.targetTableView);
                    continue;
                }
                if (ph.getName().equals(VIEW_ALIASES)) {
                    MergingModels.synchronizeColumnsView(this.sourceTableView, this.targetTableView);
                    continue;
                }
                if (!ph.getName().equals(SCHEMA) || this.sourceTableViewProxy == null || this.targetTableViewProxy == null) continue;
                if (this.sourceTableViewProxy.getUserSchema() != null) {
                    this.targetTableViewProxy.setUserSchema(this.sourceTableViewProxy.getUserSchema().getName());
                }
                if (this.sourceTableView == null || this.targetTableView == null) continue;
                this.setSchemaObject(this.sourceTableView, this.targetTableView);
            }
        }
    }

    private void setSchemaObject(TableView source, TableView target) {
        SchemaObject s_sch = source.getSchemaObject();
        if (s_sch != null) {
            SchemaObject t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getObjectByID(s_sch.getObjectID());
            if (t_sch == null) {
                t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getByName(s_sch.getName());
            }
            if (t_sch != null) {
                target.setSchemaObject(t_sch);
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceTableView == null && this.targetTableView != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceTableView != null && this.targetTableView != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (ph.isSelected() && ph.getName().equals(NAME)) {
                    return true;
                }
                if (!ph.isSelected() || (!ph.getName().equals(SCHEMA) || this.settings != null && !this.settings.isIncludeSchemaInDDL()) && !ph.getName().equals(STRUCTURED_TYPE) && !ph.getName().equals(USER_DEFINED_DQL) && !ph.getName().equals(VIEW_ALIASES)) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    protected void initSchemaProperty() {
        ModelIDObject sch;
        if (this.sourceTableViewProxy != null && this.sourceTableViewProxy instanceof TableViewProxySqlServer || this.targetTableViewProxy != null && this.targetTableViewProxy instanceof TableViewProxySqlServer) {
            PropertyHolder phd = new PropertyHolder(DATABASE);
            String ldatabase = this.sourceTableViewProxy != null && ((TableViewProxySqlServer)this.sourceTableViewProxy).getDataBase() != null ? ((TableViewProxySqlServer)this.sourceTableViewProxy).getDataBase().getName() : "";
            String rdatabase = this.targetTableViewProxy != null && ((TableViewProxySqlServer)this.targetTableViewProxy).getDataBase() != null ? ((TableViewProxySqlServer)this.targetTableViewProxy).getDataBase().getName() : "";
            phd.setLeftValue(ldatabase);
            phd.setRightValue(rdatabase);
            if (this.isExcludedFromComparison(DATABASE)) {
                phd.setExcluded(true);
            } else if (!"".equals(ldatabase) && !"".equals(rdatabase)) {
                if (this.caseSensitive) {
                    if (!ldatabase.equals(rdatabase)) {
                        phd.setModified(true);
                        if (this.useSchema) {
                            phd.setSelected(true);
                        } else {
                            phd.setFiltered(true);
                        }
                    }
                } else if (!ldatabase.equalsIgnoreCase(rdatabase)) {
                    phd.setModified(true);
                    if (this.useSchema) {
                        phd.setSelected(true);
                    } else {
                        phd.setFiltered(true);
                    }
                }
            }
            this.propertiesList.add(phd);
        }
        PropertyHolder ph = new PropertyHolder(SCHEMA);
        String sSchema = "";
        String tSchema = "";
        if (this.sourceTableViewProxy != null) {
            sch = this.sourceTableViewProxy.getSchemaImplementingObject();
            if (sch != null) {
                sSchema = sch.getName();
            } else if (this.sourceTableViewProxy.getObject() != null) {
                sSchema = this.sourceTableViewProxy.getObject().getSchema();
            }
            if (this.sourceTableViewProxy instanceof TableViewProxySqlServer) {
                sSchema = this.getSqlServerSchemaName(this.sourceTableViewProxy, sSchema);
            }
        }
        if (this.targetTableViewProxy != null) {
            sch = this.targetTableViewProxy.getSchemaImplementingObject();
            if (sch != null) {
                tSchema = sch.getName();
            } else if (this.targetTableViewProxy.getObject() != null) {
                tSchema = this.targetTableViewProxy.getObject().getSchema();
            }
            if (this.targetTableViewProxy instanceof TableViewProxySqlServer) {
                tSchema = this.getSqlServerSchemaName(this.targetTableViewProxy, tSchema);
            }
        }
        ph.setLeftValue(sSchema);
        ph.setRightValue(tSchema);
        if (this.isExcludedFromComparison(SCHEMA)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!sSchema.equals(tSchema)) {
                ph.setModified(true);
                if (this.useSchema) {
                    ph.setSelected(true);
                } else {
                    ph.setFiltered(true);
                }
            }
        } else if (!sSchema.equalsIgnoreCase(tSchema)) {
            ph.setModified(true);
            if (this.useSchema) {
                ph.setSelected(true);
            } else {
                ph.setFiltered(true);
            }
        }
        this.propertiesList.add(ph);
    }

    private String getSqlServerSchemaName(TableViewProxy proxy, String schema) {
        String prefix;
        if (proxy != null && proxy instanceof TableViewProxySqlServer && ((TableViewProxySqlServer)proxy).getDataBase() != null && schema.startsWith(prefix = ((TableViewProxySqlServer)proxy).getDataBase().getName() + "_")) {
            return schema.substring(prefix.length());
        }
        return schema;
    }

    public static DMSQLFormatter getDMSQLFormatter() {
        if (command == null) {
            command = new DMSQLFormatter();
        }
        return command;
    }
}

