/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.FileUtils;

public class CompareModelsController {
    private ApplicationView view;
    private Design design;
    private Design tempDesign;

    public CompareModelsController(ApplicationView view) {
        this.view = view;
        this.design = view.getCurrentDesign();
    }

    public void initTempDesign() {
        ApplicationView view = this.getApplicationView();
        this.tempDesign = new Design(view, view.getCurrentDesign());
    }

    public void loadTempDesign(File importFile) throws Exception {
        String ext = ".dmd";
        String designPath = importFile.getParentFile().getAbsolutePath();
        String fileName = importFile.getName();
        int pos = fileName.lastIndexOf(".");
        if (pos > -1) {
            ext = fileName.substring(pos);
        }
        String choice = FileUtils.removeExt(importFile.getName());
        ApplicationView view = this.getApplicationView();
        this.tempDesign = new Design(view, view.getCurrentDesign());
        this.tempDesign.setOldRepositoryType(".xml".equalsIgnoreCase(ext));
        this.tempDesign.setCompressedDesign(".dmdz".equalsIgnoreCase(ext));
        this.tempDesign.setFileName(choice);
        this.tempDesign.setDesignPath(designPath);
        ProgressDialog monitor = null;
        this.tempDesign.getBusinessInfoDesign().setLoaded(false);
        this.tempDesign.getLogicalDesign().setLoaded(false);
        view.setCurrentDesign(this.tempDesign);
        view.setDesignName(String.valueOf(choice));
        view.getPersistenceManager().setAppView(view);
        if (this.tempDesign.isOldRepositoryType()) {
            view.getPersistenceManager().setAppView(view);
            view.getPersistenceManager().read((Object)choice, this.tempDesign, monitor);
            view.getPersistenceManager().readSystemInit(this.tempDesign);
            this.tempDesign.loadDomainFiles();
            this.tempDesign.loadRDBMSSites();
        } else {
            view.getXMLTransformationManager().openDesign(this.tempDesign, importFile);
            view.getPersistenceManager().readSystemInit(this.tempDesign);
            view.getXMLTransformationManager().loadDomains(this.tempDesign);
        }
    }

    public List getDPObject() {
        ArrayList<RelationalDesign> list = new ArrayList<RelationalDesign>();
        for (int i = 0; i < this.tempDesign.getRelationalDesigns().size(); ++i) {
            RelationalDesign physical = (RelationalDesign)this.tempDesign.getRelationalDesigns().getElement(i);
            list.add(physical);
        }
        return list;
    }

    public void removeTempDesign() {
        this.tempDesign = null;
        this.getApplicationView().setCurrentDesign(this.design);
        System.gc();
    }

    public ApplicationView getApplicationView() {
        return this.view;
    }

    public Design getDesign() {
        return this.design;
    }

    public void setApplicationView(ApplicationView view) {
        this.view = view;
    }

    public void loadRelationalDesign(RelationalDesign physical) {
        physical.setShouldBeOpen(true);
        this.getDesign().setClosing(true);
        this.getDesign().setClosing(false);
        if (physical.getDesign().isOldRepositoryType()) {
            physical.load();
        } else {
            this.getApplicationView().getXMLTransformationManager().openDesignPart(physical);
            RMExtendedMap rxmap = physical.getRMExtendedMap();
            physical.getAppView().getXMLTransformationManager().transformFromXMLToObject(rxmap, new File(rxmap.getStorageName()), physical.getDesign().isCompressedDesign());
            RMDeletedMap dxmap = physical.getRMDeletedMap();
            physical.getAppView().getXMLTransformationManager().transformFromXMLToObject(dxmap, new File(dxmap.getStorageName()), physical.getDesign().isCompressedDesign());
        }
        physical.getDesign().getExtendedMap().distributenMappings(physical);
    }
}

