/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.List;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.undo.relational.memento.Memento;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class KeyObject
extends SubsetCO
implements Constants {
    protected boolean unique = false;
    private FKIndexAssociation fkassociation = null;
    private boolean oidKey = false;
    protected transient boolean isPK_temp = false;

    public KeyObject(DesignPart designPart) {
        super(designPart);
    }

    public abstract boolean isSurrogateKey();

    public abstract ContainedObject[] getColumns();

    public abstract Memento getIndexMemento();

    public abstract void synchronizeMarkedGenerate(boolean var1);

    public abstract String getColumnSortOrder(Object var1);

    public abstract String getIndexState();

    public abstract void setColumnSortOrder(Object var1, String var2);

    public boolean isValidPK() {
        ContainedObject[] elements = this.getElements();
        if (elements.length == 0) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < elements.length; ++i) {
            result = result && !elements[i].getNullsAllowed();
        }
        return result;
    }

    public void makeValidPKIfNotEmpty() {
        ContainedObject[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            elements[i].setNullsAllowed(false);
        }
    }

    public void setUnique(boolean unique) {
        if (this.unique != unique) {
            this.unique = unique;
            this.isPK_temp = false;
            this.setColumnsState(unique);
            ObjectChangeEvent event = null;
            event = unique ? ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE : ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE;
            if (!this.backup) {
                this.fireChange(event);
            }
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void makePK() {
        this.setPK(true);
        this.makeValidPKIfNotEmpty();
    }

    public void setColumnsState(boolean value) {
        ContainedObject[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].isUnique() == value) continue;
            elements[i].setUnique(value);
        }
    }

    public void setPK(boolean value) {
        boolean waspk = this.isPK();
        if (!waspk && !value) {
            return;
        }
        if (waspk == value) {
            if (value) {
                ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(this);
            }
            return;
        }
        if (value && this.isUnique()) {
            this.setUnique(false);
        }
        if (this.getTopLevelContainer() != null) {
            KeyObject key = value ? this : null;
            KeyObject oldkey = ((ContainerWithKeyObject)this.getTopLevelContainer()).getPK();
            ObjectChangeEvent event = null;
            boolean belongsToContainer = ((ContainerWithKeyObject)this.getTopLevelContainer()).hasKey(this);
            if (value) {
                if (oldkey != null && oldkey != key && value) {
                    oldkey.firePKRemoved();
                    oldkey.isPK_temp = false;
                }
                if (belongsToContainer) {
                    ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(key);
                    this.isPK_temp = true;
                    this.makeValidPKIfNotEmpty();
                    event = ObjectChangeEvent.KEY_CHANGED_TO_PK;
                } else {
                    this.isPK_temp = true;
                    this.makeValidPKIfNotEmpty();
                }
            } else {
                this.isPK_temp = false;
                if (waspk && belongsToContainer) {
                    ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(null);
                }
                event = ObjectChangeEvent.KEY_CHANGED_NO_PK;
            }
            if (event != null && !this.backup) {
                this.fireChange(event);
            }
            if (!value && !this.isUnique()) {
                this.setUnique(true);
            }
        }
    }

    public void firePKRemoved() {
        ObjectChangeEvent event = ObjectChangeEvent.PK_REMOVED;
        this.fireChange(event);
        this.setUnique(true);
    }

    public boolean isPK() {
        if (this.getTopLevelContainer() != null) {
            if (this.isPK_temp) {
                return true;
            }
            ContainerWithKeyObject cont = (ContainerWithKeyObject)this.getTopLevelContainer();
            KeyObject pkey = cont.getPK();
            if (pkey != null && cont.hasKey(this)) {
                if (this == pkey) {
                    return true;
                }
                String pkObjectID = pkey.getObjectID();
                if (pkObjectID != null && pkObjectID.equals(this.getObjectID())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFK() {
        return this.getFKAssociation() != null;
    }

    public FKIndexAssociation getFKAssociation() {
        return this.fkassociation;
    }

    public void setFKAssociation(FKIndexAssociation fkassociation) {
        this.fkassociation = fkassociation;
    }

    @Override
    public void remove() {
        super.remove();
        if (this.getContainerWithKeyObject() != null) {
            this.getContainerWithKeyObject().remove(this);
        }
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return (ContainerWithKeyObject)this.getTopLevelContainer();
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return this.getContainerWithKeyObject().hasRepresentationInDPV(dpv);
    }

    public boolean isOidKey() {
        return this.oidKey;
    }

    public void setOidKey(boolean oidKey) {
        this.oidKey = oidKey;
    }

    public boolean hasFKAttribute() {
        Attribute[] attributes = (Attribute[])this.getElements();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].isFKAttribute()) continue;
            return true;
        }
        return false;
    }

    public Attribute getFKAttribute() {
        Attribute[] attributes = (Attribute[])this.getElements();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].isFKAttribute()) continue;
            return attributes[i];
        }
        return null;
    }

    @Override
    protected void assignLocalID(ModelIDObject object) {
    }

    public XtdMapping getDeletedMapping(ContainerWithKeyObject co) {
        String coid = co.getObjectID();
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, co.getDesignPartId());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String contID;
                XtdMapping mapping = (XtdMapping)list.get(i);
                if (coid.equals(mapping.getRecreatedContainerID())) {
                    return mapping;
                }
                if (this.getContainerObject() == null || !coid.equals(contID = mapping.getOtherContainerID(this.getContainerObject().getObjectID()))) continue;
                return mapping;
            }
        }
        return null;
    }

    public XtdMapping getDeletedMapping(String containerID, String designPartID) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, designPartID);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                if (containerID.equals(mapping.getRecreatedContainerID())) {
                    return mapping;
                }
                String deletedID = mapping.getDeletedID();
                String contID = ContainerObject.getContainerID_From(deletedID);
                if (!containerID.equals(contID)) continue;
                return mapping;
            }
        }
        return null;
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty && this.getContainerObject() != null) {
            this.getContainerObject().setDirty(dirty);
        }
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        KeyObject key = (KeyObject)desObject;
        this.setOidKey(this.isOidKey());
        ContainerWithKeyObject cont = key.getContainerWithKeyObject();
        key.getElementsCollection().clear();
        for (ContainedObject co : this.getElementsCollection()) {
            ContainedObject co_new = cont.getElementByID(co.getObjectID());
            if (co_new == null) {
                co_new = cont.getElementByName(co.getName());
            }
            if (co_new == null) continue;
            key.getElementsCollection().add(co_new);
        }
    }

    @Override
    public void setObjectID(String id) {
        String oldID = this.getObjectID();
        super.setObjectID(id);
        ContainerWithKeyObject container = this.getContainerWithKeyObject();
        if (container != null && oldID == null) {
            container.putInLocalIDMap(id, this);
        }
        if (container != null && id != null && oldID != null && !id.equals(oldID)) {
            container.updateLocalObjectId(oldID, id);
        }
    }

    public String getColumnsAsString(StorageDesign storageDesign) {
        ContainedObject[] columns = this.getColumns();
        StringBuffer result = new StringBuffer();
        boolean b = false;
        for (int i = 0; i < columns.length; ++i) {
            if (b) {
                result.append(", ");
            } else {
                b = true;
            }
            String name = storageDesign.getFormatedName(columns[i]);
            result.append(name);
        }
        return result.toString();
    }

    public void setIndexState(String indexState) {
    }

    public String getIndexExpression() {
        return "";
    }

    public void setIndexExpression(String indexExpression) {
    }

    @Override
    public boolean isRemoteObject() {
        return super.isRemoteObject() || this.getContainerWithKeyObject().isRemoteObject();
    }

    public int getIndexOfElement(String name) {
        int ind = -1;
        int k = 0;
        for (FKElement el : this.getElementsCollection()) {
            if (name.equalsIgnoreCase(el.getName())) {
                ind = k;
                break;
            }
            ++k;
        }
        return ind;
    }
}

