/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.db2;

import java.util.Map;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDFloat;
import oracle.dbtools.crest.model.datatype.db2.MDBlob;
import oracle.dbtools.crest.model.datatype.db2.MDChar;
import oracle.dbtools.crest.model.datatype.db2.MDClob;
import oracle.dbtools.crest.model.datatype.db2.MDDBClob;
import oracle.dbtools.crest.model.datatype.db2.MDDate;
import oracle.dbtools.crest.model.datatype.db2.MDDecimal;
import oracle.dbtools.crest.model.datatype.db2.MDDouble;
import oracle.dbtools.crest.model.datatype.db2.MDGraphic;
import oracle.dbtools.crest.model.datatype.db2.MDInteger;
import oracle.dbtools.crest.model.datatype.db2.MDLongVarCharDB2;
import oracle.dbtools.crest.model.datatype.db2.MDLongVarGraphicDB2;
import oracle.dbtools.crest.model.datatype.db2.MDNumeric;
import oracle.dbtools.crest.model.datatype.db2.MDReal;
import oracle.dbtools.crest.model.datatype.db2.MDRowIDDB2;
import oracle.dbtools.crest.model.datatype.db2.MDSmallInt;
import oracle.dbtools.crest.model.datatype.db2.MDTime;
import oracle.dbtools.crest.model.datatype.db2.MDTimeStamp;
import oracle.dbtools.crest.model.datatype.db2.MDUnknown;
import oracle.dbtools.crest.model.datatype.db2.MDVarChar;
import oracle.dbtools.crest.model.datatype.db2.MDVarGraphic;

public class MDDataTypeFactoryDB2
extends MDDataTypeFactory {
    @Override
    protected void initFlyWeights() {
        Map flyweights = this.getFlyWeights();
        flyweights.put("UNKNOWN", new MDUnknown());
        flyweights.put("REAL", new MDReal());
        MDDouble real = new MDDouble();
        real.setFloatSynonym();
        flyweights.put("DATE", new MDDate());
        flyweights.put("DOUBLE", new MDDouble());
        flyweights.put("INTEGER", new MDInteger());
        MDInteger int_ = new MDInteger();
        int_.setName("INT");
        flyweights.put("INT", int_);
        flyweights.put("REAL", new MDReal());
        flyweights.put("SMALLINT", new MDSmallInt());
        flyweights.put("TIME", new MDTime());
        flyweights.put("TIMESTAMP", new MDTimeStamp());
        MDBlob blob = new MDBlob();
        blob.setBinaryLargeObjectSynonym();
        flyweights.put("BINARY LARGE OBJECT", blob);
        MDClob charLargeObject = new MDClob();
        charLargeObject.setCharLargeObjectSynonym();
        flyweights.put("CHAR LARGE OBJECT", charLargeObject);
        MDClob characterLargeObject = new MDClob();
        characterLargeObject.setCharacterLargeObjectSynonym();
        flyweights.put("CHARACTER LARGE OBJECT", characterLargeObject);
        MDVarChar charVarying = new MDVarChar();
        charVarying.setCharVaryingSynonym();
        flyweights.put("CHAR VARYING", charVarying);
        MDVarChar characterVarying = new MDVarChar();
        characterVarying.setCharacterVaryingSynonym();
        flyweights.put("CHARACTER VARYING", characterVarying);
        flyweights.put("UNKNOWN", new MDUnknown());
    }

    @Override
    protected void initHeavyWeights() {
        Map heavyweights = this.getHeavyWeights();
        heavyweights.put("BLOB", MDBlob.class);
        heavyweights.put("CLOB", MDClob.class);
        heavyweights.put("CHAR", MDChar.class);
        heavyweights.put("DECIMAL", MDDecimal.class);
        heavyweights.put("NUMERIC", MDNumeric.class);
        heavyweights.put("VARCHAR", MDVarChar.class);
        heavyweights.put("GRAPHIC", MDGraphic.class);
        heavyweights.put("VARGRAPHIC", MDVarGraphic.class);
        heavyweights.put("DBCLOB", MDDBClob.class);
        heavyweights.put("ROWID", MDRowIDDB2.class);
        heavyweights.put("LONG VARCHAR", MDLongVarCharDB2.class);
        heavyweights.put("LONG VARGRAPHIC", MDLongVarGraphicDB2.class);
        heavyweights.put("FLOAT", MDFloat.class);
    }

    @Override
    public MDDataType createType(String name, String size) {
        MDDataType dataType = null;
        if ("CHAR".equals(name)) {
            dataType = new MDChar();
        } else if ("VARCHAR".equals(name)) {
            dataType = new MDVarChar();
        } else if ("GRAPHIC".equals(name)) {
            dataType = new MDGraphic();
        } else if ("BLOB".equals(name)) {
            dataType = new MDBlob();
        } else if ("CLOB".equals(name)) {
            dataType = new MDClob();
        } else if ("DBCLOB".equals(name)) {
            dataType = new MDDBClob();
        } else if ("VARGRAPHIC".equals(name)) {
            dataType = new MDVarGraphic();
        } else {
            if ("DECIMAL".equals(name)) {
                dataType = new MDDecimal();
                dataType.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dataType;
            }
            if ("NUMERIC".equals(name)) {
                MDNumeric dec = new MDNumeric();
                dec.setNumericSynonym();
                dec.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dec;
            }
            if ("FLOAT".equals(name)) {
                dataType = new MDFloat();
                dataType.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dataType;
            }
        }
        if (dataType == null) {
            dataType = super.createUDNativeType(name, size);
        } else {
            dataType.setSize(size);
        }
        return dataType;
    }

    @Override
    public MDDataType createType(String name, int precision, int scale) {
        if ("DECIMAL".equals(name)) {
            MDDecimal dec = new MDDecimal();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        if ("NUMERIC".equals(name)) {
            MDNumeric dec = new MDNumeric();
            dec.setNumericSynonym();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        return super.createUDNativeType(name, precision, scale);
    }

    @Override
    public int getMaxPrecision(String type) {
        String tupper = type.toUpperCase();
        if (tupper.startsWith("DECF")) {
            return 34;
        }
        if (tupper.startsWith("DEC") || tupper.startsWith("NUM")) {
            return 31;
        }
        if (tupper.equals("FLOAT")) {
            return 53;
        }
        return 31;
    }
}

