/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeNames;
import oracle.dbtools.crest.model.datatype.MDUserDefined_NoParams;
import oracle.dbtools.crest.model.datatype.MDUserDefined_PS;
import oracle.dbtools.crest.model.datatype.MDUserDefined_Sized;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.datatype.db2.MDDataTypeFactoryDB2;
import oracle.dbtools.crest.model.datatype.oracle.v10g.MDDataTypeFactoryOraclev10g;
import oracle.dbtools.crest.model.datatype.oracle.v12c.MDDataTypeFactoryOraclev12c;
import oracle.dbtools.crest.model.datatype.oracle.v20c.MDDataTypeFactoryOraclev20c;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDDataTypeFactoryOraclev9i;
import oracle.dbtools.crest.model.datatype.sqlserver.MDDataTypeFactorySqlServer;
import oracle.dbtools.crest.model.datatype.udb.MDDataTypeFactoryUDB;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.util.options.Settings;

public abstract class MDDataTypeFactory
implements MDDataTypeNames {
    protected static MDDataTypeFactory instance = null;
    protected static Map instances = new TreeMap();
    protected Map flyweights = null;
    protected Map heavyweights = null;
    protected RDBMSType dbtype = null;

    protected MDDataTypeFactory() {
    }

    public static MDDataTypeFactory getInstance(Settings settings) {
        return MDDataTypeFactory.getInstance("Oracle Database 11g", settings);
    }

    public static MDDataTypeFactory getInstance(String rdbms, Settings settings) {
        RDBMSType dbtype = MDDataTypeFactory.getRDBMSType(rdbms);
        return MDDataTypeFactory.getInstance(dbtype, settings);
    }

    static RDBMSType getRDBMSType(String rdbms) {
        if (rdbms.equalsIgnoreCase("DB2/390 7")) {
            return StorageDesignDB2v70.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("DB2/390 8")) {
            return StorageDesignDB2v80.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("DB2/UDB 7.1")) {
            return StorageDesignUDBv71.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("DB2/UDB 8.1")) {
            return StorageDesignUDBv81.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("DB2/UDB 9")) {
            return StorageDesignUDBv9.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle9i")) {
            return StorageDesignOraclev9i.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 10g")) {
            return StorageDesignOraclev10g.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 11g")) {
            return StorageDesignOraclev11g.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 12c")) {
            return StorageDesignOraclev12c.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 12cR2")) {
            return StorageDesignOraclev12cR2.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 21c")) {
            return StorageDesignOraclev20c.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("SQL Server 2000")) {
            return StorageDesignSqlServerv2k.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("SQL Server 2005")) {
            return StorageDesignSqlServerv2k5.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("SQL Server 2008")) {
            return StorageDesignSqlServerv2k8.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("SQL Server 2012")) {
            return StorageDesignSqlServerv2k12.RDBMS_TYPE;
        }
        return StorageDesignOraclev11g.RDBMS_TYPE;
    }

    public static MDDataTypeFactory getInstance(RDBMSType rdbms, Settings settings) {
        if (instances.containsKey(rdbms)) {
            return (MDDataTypeFactory)instances.get(rdbms);
        }
        if (rdbms == StorageDesignDB2v70.RDBMS_TYPE || rdbms == StorageDesignDB2v80.RDBMS_TYPE) {
            instance = new MDDataTypeFactoryDB2();
        } else if (rdbms == StorageDesignUDBv71.RDBMS_TYPE || rdbms == StorageDesignUDBv81.RDBMS_TYPE || rdbms == StorageDesignUDBv9.RDBMS_TYPE) {
            instance = new MDDataTypeFactoryUDB();
        } else if (rdbms == StorageDesignOraclev9i.RDBMS_TYPE) {
            instance = new MDDataTypeFactoryOraclev9i(settings);
        } else if (rdbms == StorageDesignOraclev10g.RDBMS_TYPE || rdbms == StorageDesignOraclev11g.RDBMS_TYPE) {
            instance = new MDDataTypeFactoryOraclev10g(settings);
        } else if (rdbms == StorageDesignOraclev12c.RDBMS_TYPE || rdbms == StorageDesignOraclev12cR2.RDBMS_TYPE) {
            instance = new MDDataTypeFactoryOraclev12c(settings);
        } else if (rdbms == StorageDesignOraclev20c.RDBMS_TYPE) {
            instance = new MDDataTypeFactoryOraclev20c(settings);
        } else if (rdbms == StorageDesignSqlServerv2k.RDBMS_TYPE) {
            instance = new MDDataTypeFactorySqlServer();
        } else if (rdbms == StorageDesignSqlServerv2k5.RDBMS_TYPE || rdbms == StorageDesignSqlServerv2k8.RDBMS_TYPE || rdbms == StorageDesignSqlServerv2k12.RDBMS_TYPE) {
            MDDataTypeFactorySqlServer tf = new MDDataTypeFactorySqlServer();
            tf.setAllowVarcharMax(true);
            instance = tf;
        } else {
            instance = new MDDataTypeFactoryOraclev10g(settings);
        }
        MDDataTypeFactory.instance.dbtype = rdbms;
        instances.put(rdbms, instance);
        return instance;
    }

    public MDDataType createType(String name) {
        if (this.getFlyWeights().containsKey(name)) {
            try {
                return (MDDataType)this.getFlyWeights().get(name);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.getHeavyWeights().containsKey(name)) {
            try {
                return (MDDataType)((Class)this.getHeavyWeights().get(name)).newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(name)) {
            NativeDBType nt;
            RDBMSType type = this.dbtype;
            if (type == null) {
                type = StorageDesignOraclev11g.RDBMS_TYPE;
            }
            if ((nt = StandardDatatypeNames.getNativeDBType(type, name)) != null && nt.isHasPrecision()) {
                MDUserDefined_PS dt = new MDUserDefined_PS(name);
                if (!nt.isHasScale()) {
                    dt.setHasScale(false);
                }
                return dt;
            }
            if (nt != null && nt.isHasSize()) {
                return new MDUserDefined_Sized(name);
            }
            if (nt != null) {
                return new MDUserDefined_NoParams(name);
            }
        }
        return null;
    }

    public MDDataType createStringEncodedType(String coded) {
        String[] parts = MDDataTypeFactory.tokenize(coded);
        return this.createStringEncodedType(parts);
    }

    public MDDataType createStringEncodedType(String[] parts) {
        switch (parts.length) {
            case 1: {
                return this.createType(parts[0]);
            }
            case 2: {
                String[] parts_n;
                String numeric = parts[1];
                if (numeric.indexOf(32) > 0 && (parts_n = numeric.split(" ")).length == 2 && (parts_n[1].equalsIgnoreCase("BYTE") || parts_n[1].equalsIgnoreCase("CHAR"))) {
                    return this.createType(parts[0], numeric);
                }
                if ("size".equals(numeric)) {
                    return this.createType(parts[0], "0");
                }
                return this.createType(parts[0], parts[1]);
            }
            case 3: {
                return this.createType(parts[0], parts[1], parts[2]);
            }
        }
        throw new RuntimeException(Messages.getString("MDDataTypeFactory.Expected1to3Parts"));
    }

    public static int parseSafely(String numeric) {
        try {
            int size = AbstractDataType.parseSize(numeric.trim());
            if (size != -1) {
                return size;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int parse(String numeric) {
        try {
            return Integer.parseInt(numeric.trim());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static String[] tokenize(String coded) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(coded, ",;", false);
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken().trim());
        }
        return list.toArray(new String[0]);
    }

    protected Map getFlyWeights() {
        if (this.flyweights == null) {
            this.flyweights = new TreeMap();
            this.initFlyWeights();
        }
        return this.flyweights;
    }

    protected Map getHeavyWeights() {
        if (this.heavyweights == null) {
            this.heavyweights = new TreeMap();
            this.initHeavyWeights();
        }
        return this.heavyweights;
    }

    public static int stringToInt(String string) {
        int pr = 0;
        try {
            pr = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pr;
    }

    public MDDataType createUDNativeType(String name, String size) {
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(name)) {
            NativeDBType nt;
            RDBMSType type = this.dbtype;
            if (type == null) {
                type = StorageDesignOraclev11g.RDBMS_TYPE;
            }
            if ((nt = StandardDatatypeNames.getNativeDBType(type, name)) != null && nt.isHasSize()) {
                MDUserDefined_Sized dt = new MDUserDefined_Sized(name);
                dt.setSize(size);
                return dt;
            }
            if (nt != null && nt.isHasPrecision()) {
                MDUserDefined_PS dt = new MDUserDefined_PS(name);
                dt.setPrecision(MDDataTypeFactory.parseSafely(size));
                return dt;
            }
            if (nt != null) {
                return new MDUserDefined_NoParams(name);
            }
        }
        return null;
    }

    public MDDataType createUDNativeType(String name, int precision, int scale) {
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(name)) {
            NativeDBType nt;
            RDBMSType type = this.dbtype;
            if (type == null) {
                type = StorageDesignOraclev11g.RDBMS_TYPE;
            }
            if ((nt = StandardDatatypeNames.getNativeDBType(type, name)) != null && nt.isHasPrecision()) {
                MDUserDefined_PS dt = new MDUserDefined_PS(name);
                dt.setPrecision(precision);
                dt.setScale(scale);
                return dt;
            }
            if (nt != null) {
                return new MDUserDefined_NoParams(name);
            }
        }
        return null;
    }

    public MDDataType createType(String name, String precision, String scale) {
        int prec = this.getMaxPrecision(name);
        try {
            prec = Integer.valueOf(precision);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int sc = 0;
        try {
            sc = Integer.valueOf(scale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createType(name, prec, sc);
    }

    protected abstract void initFlyWeights();

    protected abstract void initHeavyWeights();

    public abstract MDDataType createType(String var1, String var2);

    public abstract MDDataType createType(String var1, int var2, int var3);

    public RDBMSType getRDBMSType() {
        return this.dbtype;
    }

    public void setRDBMSType(RDBMSType dbtype) {
        this.dbtype = dbtype;
    }

    public int getMaxPrecision(String type) {
        String tupper = type.toUpperCase();
        if (type.startsWith("NUM")) {
            return 38;
        }
        if (tupper.startsWith("TIMES") || tupper.startsWith("INTERVAL")) {
            return 9;
        }
        if (type.equals("FLOAT")) {
            return 126;
        }
        return 38;
    }
}

