/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.PhonePropertiesDialogEx;

public class BIPhone
extends DesignObject {
    private String phoneNumber = "";
    private String phoneType = "";
    private List contacts = new ArrayList();
    public static final String TYPE_NAME = "Phone";

    public BIPhone(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PhonePropertiesDialogEx dialog = new PhonePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(String phoneType) {
        this.phoneType = phoneType;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact contact) {
        if (!this.contacts.contains(contact)) {
            this.contacts.add(contact);
        }
    }

    public void removeContact(BIContact contact) {
        this.contacts.remove(contact);
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        ((BIPhone)desObject).setPhoneNumber(this.getPhoneNumber());
        ((BIPhone)desObject).setPhoneType(this.getPhoneType());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "phone" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

