/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;

public abstract class ModelObject
implements LongNameObject {
    protected Design design;
    private ModelObjectSet objectSet = null;
    protected String name = "";
    protected Object parent;
    private Icon icon = null;
    private String sourceConnName = "";
    private String sourceObjSchema = "";
    private String sourceObjName = "";
    private String sourceDDLFile = "";

    public void setDesign(Design design) {
        this.design = design;
    }

    public Design getDesign() {
        return this.design;
    }

    public ApplicationView getAppView() {
        if (this.design != null) {
            return this.design.getAppView();
        }
        return ApplicationView.getInstance();
    }

    public String getConfiguration(String mdconfigurationConstant) {
        return this.getDesign().getAppView().getMDConfiguration().get(mdconfigurationConstant);
    }

    public String getPreference(String mdpreferenceConstant) {
        return this.getDesign().getAppView().getPreference().get(mdpreferenceConstant);
    }

    public MDPreferences getPreferences() {
        return this.getDesign().getAppView().getPreference();
    }

    public RDBMSType getSelectedRDBMSType() {
        RDBMSSite site = this.getSelectedRDBMSSite();
        if (site != null) {
            return site.getType();
        }
        return StorageDesignOraclev11g.RDBMS_TYPE;
    }

    public RDBMSSite getSelectedRDBMSSite() {
        return this.getDesign().getSelectedRDBMSSite();
    }

    public int getNumberOfChildren() {
        return 0;
    }

    public ModelObject getChild(int index) {
        return null;
    }

    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    public int getIndexForChild(ModelObject child) {
        return -1;
    }

    public int getIndexForChild(Object child) {
        return -1;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isObjectCollection() {
        return false;
    }

    public final Object[] getPath() {
        ArrayList list = new ArrayList();
        this.addToPath(list);
        return list.toArray();
    }

    public final List addToPath(List list) {
        list.add(0, this);
        if (this.getParent() != null && this.getParent() instanceof ModelObject) {
            ((ModelObject)this.getParent()).addToPath(list);
        }
        return list;
    }

    public boolean hasAlternatePaths() {
        return false;
    }

    public Object[][] getAlternatePaths() {
        return new Object[][]{this.getPath()};
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String getLongName(boolean includeContainerSchema) {
        return this.getLongName();
    }

    @Override
    public String getName() {
        if (this.name == null && this.objectSet != null) {
            this.name = this.objectSet.createName();
        }
        return this.name;
    }

    public boolean isWriteable() {
        return true;
    }

    public boolean allowName(String name, boolean isLongName) {
        if (this.objectSet == null) {
            return true;
        }
        if (isLongName) {
            return !this.objectSet.containsLongName(this, name);
        }
        return !this.objectSet.containsName(this, name);
    }

    public boolean setName(String name) {
        if (this.isWriteable() && this.allowName(name, false)) {
            this.name = name;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getLongName();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public ModelObjectSet getObjectSet() {
        return this.objectSet;
    }

    public void setObjectSet(ModelObjectSet objectSet) {
        this.objectSet = objectSet;
    }

    public String getSourceConnName() {
        return this.sourceConnName;
    }

    public void setSourceConnName(String sourceConnName) {
        this.sourceConnName = sourceConnName;
    }

    public String getSourceObjSchema() {
        return this.sourceObjSchema;
    }

    public void setSourceObjSchema(String sourceObjSchema) {
        this.sourceObjSchema = sourceObjSchema;
    }

    public String getSourceObjName() {
        return this.sourceObjName;
    }

    public void setSourceObjName(String sourceObjName) {
        this.sourceObjName = sourceObjName;
    }

    public String getSourceDDLFile() {
        return this.sourceDDLFile;
    }

    public void setSourceDDLFile(String sourceDDLFile) {
        this.sourceDDLFile = sourceDDLFile;
    }

    public void clearSourceDBInfo() {
        this.sourceConnName = "";
        this.sourceObjSchema = "";
        this.sourceObjName = "";
        this.sourceDDLFile = "";
        if (this instanceof DesignObject) {
            ((DesignObject)this).setDirty(true);
        }
    }

    public void copySourceStamp(ModelObject target) {
        target.setSourceConnName(this.getSourceConnName());
        target.setSourceObjName(this.getSourceObjName());
        target.setSourceObjSchema(this.getSourceObjSchema());
    }
}

