/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.util.logging.Logger;

public class VarFileReader {
    private BufferedReader in;
    private String filePath;
    private String version;
    private Fields constants;
    private String type;
    private String line;
    private String name;
    private static final Logger LOGGER = new Logger(VarFileReader.class);

    public VarFileReader(String filePath) {
        try {
            this.filePath = filePath;
            this.in = new BufferedReader(new FileReader(this.filePath));
            this.version = this.readVersionLine();
            this.name = this.readName();
            this.constants = new Fields(this.version);
        }
        catch (FileNotFoundException e) {
            StringBuffer message = new StringBuffer("Can not open file : ");
            message.append(filePath);
            LOGGER.error(message.toString(), e);
        }
    }

    public boolean isSupportedVersion() {
        return this.constants.isSupportedVersion();
    }

    public boolean isLogicalDesign() {
        return this.constants.isLogicalDesign();
    }

    private String readVersionLine() {
        try {
            String read = this.in.readLine().trim();
            return read;
        }
        catch (IOException e) {
            StringBuffer message = new StringBuffer("Can not read file : ");
            message.append(this.filePath);
            LOGGER.error(message.toString(), e);
            return null;
        }
    }

    public VarFileLine readLine() {
        try {
            String fileLine = this.in.readLine();
            while (fileLine != null) {
                if (this.isTypeLine(fileLine)) {
                    this.type = this.getTypeFromLine(fileLine);
                    this.line = "";
                } else {
                    this.line = fileLine;
                }
                if (!this.line.equalsIgnoreCase("") && !this.type.equalsIgnoreCase("")) {
                    return new VarFileLine(this.type, this.line);
                }
                fileLine = this.in.readLine();
            }
        }
        catch (IOException e) {
            StringBuffer message = new StringBuffer("Can not read file : ");
            message.append(this.filePath);
            LOGGER.error(message.toString(), e);
            return null;
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public Fields getConstants() {
        return this.constants;
    }

    public boolean isTypeLine(String row) {
        return (row = row.trim()).startsWith("**") && row.endsWith("**");
    }

    public boolean isDataLine(String row) {
        return !this.isTypeLine(row);
    }

    public String getTypeFromLine(String row) {
        if (this.isTypeLine(row = row.trim())) {
            return row.substring(2, row.length() - 2);
        }
        return "";
    }

    public void closeReader() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            StringBuffer message = new StringBuffer("Cannot close file in VarFileReader.closeReader : ");
            message.append(this.filePath);
            LOGGER.error(message.toString(), e);
        }
    }

    public void startReader() {
        try {
            this.in = new BufferedReader(new FileReader(this.filePath));
            this.version = this.readVersionLine();
            this.constants = new Fields(this.version);
        }
        catch (FileNotFoundException e) {
            StringBuffer message = new StringBuffer("Can not reset file at beginning: ");
            message.append(this.filePath);
            LOGGER.error(message.toString(), e);
        }
    }

    private String readName() {
        int indexOfQuote = this.version.indexOf("\"");
        String temp = this.version.substring(indexOfQuote + 1);
        int indexOfQuoteInTemp = temp.indexOf("\"");
        this.name = temp.substring(0, indexOfQuoteInTemp);
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.filePath;
    }
}

