/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHTablespacePartitions
extends RowHandler {
    public static final String OBJECT_TYPE = "PARTITIONS";
    private static final Logger LOGGER = new Logger(RHTablespacePartitions.class);

    public RHTablespacePartitions(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createPartitions(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createPartitions(VarFileLine line) {
        String tablespaceKey = this.getField(line, "TABLESPACE_PART_TABLESPACE_KEY");
        TableSpaceDB2 tablespace = (TableSpaceDB2)this.getCreatedObject(tablespaceKey);
        String indexKey = this.getField(line, "TABLESPACE_PART_INDEX_KEY");
        Index index = (Index)this.getCreatedObject(indexKey);
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        if (storageDesign != null) {
            if (tablespace != null) {
                PartitionDB2 partition = storageDesign.getPartitionSet().createPartition();
                partition.setTableSpace(tablespace);
                StorageTemplateDB2 st = storageDesign.getStorageTemplateSet().createStorageTemplate();
                partition.setStorageTemplate(st);
                this.fillPartNumber(line, partition, null);
                this.fillCommont(line, partition);
                this.fillCompressed(line, partition);
                this.fillEraseRule(line, st);
                this.fillFreepage(line, st);
                this.fillPercentageFree(line, st);
                this.fillPrimaryQuantity(line, st);
                this.fillSecundaryQuantity(line, st);
                StorageGroupDB2 storageGroup = (StorageGroupDB2)this.getCreatedObject(this.getField(line, "TABLESPACE_PART_STORAGEGROUP_KEY"));
                VCatDB2 vcat = (VCatDB2)this.getCreatedObject(this.getField(line, "TABLESPACE_PART_VCAT_KEY"));
                if (storageGroup != null) {
                    st.setStorageGroup(storageGroup);
                } else if (vcat != null) {
                    st.setVCat(vcat);
                }
                this.addCreatedObject(this.getField(line, "general_id"), partition);
                this.removeSelectedLine(line);
                StorageTemplateDB2 realst = storageDesign.getStorageTemplateSet().removeIfExistEqual(partition.getStorageTemplate());
                if (realst != partition.getStorageTemplate()) {
                    partition.setStorageTemplate(realst);
                }
            } else if (index != null) {
                IndexPartitionDB2 indexPartition = storageDesign.getIndexPartitionSet().createIndexPartition();
                IndexProxyDB2 indexProxy = (IndexProxyDB2)storageDesign.getIndexProxySet().getProxy(index.getObjectID());
                indexPartition.setIndex(indexProxy);
                StorageTemplateDB2 st = storageDesign.getStorageTemplateSet().createStorageTemplate();
                indexPartition.setStorageTemplate(st);
                this.fillPartNumber(line, null, indexPartition);
                this.fillPartConstants(line, indexPartition);
                this.fillEraseRule(line, st);
                this.fillFreepage(line, st);
                this.fillPercentageFree(line, st);
                this.fillPrimaryQuantity(line, st);
                this.fillSecundaryQuantity(line, st);
                this.addCreatedObject(this.getField(line, "general_id"), indexPartition);
                this.removeSelectedLine(line);
                StorageTemplateDB2 realst = storageDesign.getStorageTemplateSet().removeIfExistEqual(indexPartition.getStorageTemplate());
                if (realst != indexPartition.getStorageTemplate()) {
                    indexPartition.setStorageTemplate(realst);
                }
            }
        }
    }

    private void fillPartNumber(VarFileLine line, PartitionDB2 partition, IndexPartitionDB2 indexPartition) {
        try {
            int partNbr = Integer.parseInt(this.getField(line, "TABLESPACE_PART_NUMBER"));
            if (partition != null) {
                partition.setPartNumber(partNbr);
            } else if (indexPartition != null) {
                indexPartition.setPartNumber(partNbr);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in RHTablespacePartitions.fillDeletePercentage :");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong PART NUMBER format for partition " + partition.getName());
        }
    }

    private void fillCommont(VarFileLine line, PartitionDB2 partition) {
        String textKey = this.getField(line, "TABLESPACE_PART_TEXT");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(textKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            partition.setCommentInRDBMS(comment);
            partition.setComment(comment);
        }
    }

    private void fillCompressed(VarFileLine line, PartitionDB2 partition) {
        String compressed = this.getField(line, "TABLESPACE_PART_COMPRESSED").trim();
        if (compressed.equals("1")) {
            partition.setCompress(true);
        }
    }

    private void fillEraseRule(VarFileLine line, StorageTemplateDB2 st) {
        String erase = this.getField(line, "TABLESPACE_PART_ERASE_RULE");
        if (erase.equals("1")) {
            st.setSgErase(true);
        }
    }

    private void fillFreepage(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int freepage = Integer.parseInt(this.getField(line, "TABLESPACE_PART_FREEPAGE"));
            if (freepage > 0 && freepage < 256) {
                st.setFreePage(freepage);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in RHTablespacePartitions.fillFreepage :");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FREE PAGE format for storage template " + st.getName());
        }
    }

    private void fillPercentageFree(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int percentageFree = Integer.parseInt(this.getField(line, "TABLESPACE_PART_PCTFREE"));
            if (percentageFree > 0) {
                st.setPctFree(percentageFree);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in RHTablespacePartitions.fillPercentageFree :");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong PERCENTAGE FREE format for storage template " + st.getName());
        }
    }

    private void fillPrimaryQuantity(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int priqty = Integer.parseInt(this.getField(line, "TABLESPACE_PART_PRIQTY"));
            if (priqty > -1) {
                st.setSgPriqty(priqty);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in RHTablespacePartitions.fillPrimaryQuantity :");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong PRIMARY QUANTITY format for storage template " + st.getName());
        }
    }

    private void fillSecundaryQuantity(VarFileLine line, StorageTemplateDB2 st) {
        try {
            int secqty = Integer.parseInt(this.getField(line, "TABLESPACE_PART_SECQTY"));
            if (secqty > -1) {
                st.setSgSeqty(secqty);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in RHTablespacePartitions.fillSecundaryQuantity :");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong SECONDARY QUANTITY format for storage template " + st.getName());
        }
    }

    private void fillPartConstants(VarFileLine line, IndexPartitionDB2 indexPartition) {
        String key = this.getField(line, "general_id");
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.getAllSelectedLines().iterator();
        while (it.hasNext()) {
            String partKey;
            VarFileLine selectedLine = (VarFileLine)it.next();
            if (!selectedLine.getType().equalsIgnoreCase("PARTITION_BOUNDARY") || !key.equalsIgnoreCase(partKey = this.getField(selectedLine, "PARTITION_BOUNDARY_PARTID"))) continue;
            buffer.append(this.getField(selectedLine, "PARTITION_BOUNDARY_VALUE"));
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        indexPartition.setPartConstants(buffer.toString());
    }
}

