/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;

public class RHMapExtDesign
extends RowHandler {
    public static final String OBJECT_TYPE = "MAP_EXT_DESIGN";
    public static final String OBJECT_TYPE2 = "MAPEXTDGN";
    private String name;
    private List names = new ArrayList();
    private List logLines = new ArrayList();

    public RHMapExtDesign(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE2)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE2);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE2)) {
            this.createMap(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createMap(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE2)) {
            this.name = this.getField(line, OBJECT_TYPE2).trim();
        } else {
            this.names.add(this.getField(line, OBJECT_TYPE).trim());
            if (!this.logLines.contains(line)) {
                this.logLines.add(line);
            }
        }
        this.removeSelectedLine(line);
    }

    public String getNameDesign() {
        return this.name;
    }

    public List getDesignNames() {
        return this.names;
    }

    public VarFileLine getLineForRelationalDesign(String name) {
        Integer desNamePos = new Integer(10);
        for (VarFileLine line : this.logLines) {
            String desName = this.getField(line.getLine(), desNamePos).trim();
            if (!desName.equalsIgnoreCase(name)) continue;
            return line;
        }
        return null;
    }

    public List getLogicalLines() {
        return this.logLines;
    }
}

